/*
 * Decompiled with CFR 0.152.
 */
package me.mulemuledupe.simpletpa.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.mulemuledupe.simpletpa.SimpleTpa;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SimpleTpaUtils {
    SimpleTpa plugin;

    public SimpleTpaUtils(SimpleTpa plugin) {
        this.plugin = plugin;
    }

    public boolean isVanished(Player player) {
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public void sendMessage(Player p, String message) {
        if (!message.equalsIgnoreCase("none")) {
            if (!this.plugin.getConfig().getBoolean("disable-prefix")) {
                p.sendMessage(this.translate(this.plugin.getConfig().getString("prefix") + " " + message));
            } else {
                p.sendMessage(this.translate(message));
            }
        }
    }

    public String translate(String string) {
        if (this.plugin.storage.isAbove16()) {
            Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String color = string.substring(matcher.start(), matcher.end());
                string = string.replace(color, net.md_5.bungee.api.ChatColor.of((String)color) + "");
                matcher = pattern.matcher(string);
            }
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    public void addButtonsMethod(Player p) {
        TextComponent acceptButton = new TextComponent(this.plugin.getConfig().getString("Accept-Button"));
        acceptButton.setColor(net.md_5.bungee.api.ChatColor.valueOf((String)this.plugin.getConfig().getString("Accept-Button-Color")));
        acceptButton.setBold(Boolean.valueOf(this.plugin.getConfig().getBoolean("Accept-Button-Set-Bold")));
        acceptButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept"));
        acceptButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("Accept-Button-Description"))).create()));
        TextComponent middleButton = new TextComponent(this.plugin.getConfig().getString("Middle-Button"));
        middleButton.setColor(net.md_5.bungee.api.ChatColor.valueOf((String)this.plugin.getConfig().getString("Middle-Button-Color")));
        middleButton.setBold(Boolean.valueOf(this.plugin.getConfig().getBoolean("Middle-Button-Set-Bold")));
        middleButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("Middle-Button-Description"))).create()));
        TextComponent denyButton = new TextComponent(this.plugin.getConfig().getString("Deny-Button"));
        denyButton.setColor(net.md_5.bungee.api.ChatColor.valueOf((String)this.plugin.getConfig().getString("Deny-Button-Color")));
        denyButton.setBold(Boolean.valueOf(this.plugin.getConfig().getBoolean("Deny-Button-Set-Bold")));
        denyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny"));
        denyButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("Deny-Button-Description"))).create()));
        p.spigot().sendMessage(new BaseComponent[]{acceptButton, middleButton, denyButton});
    }

    public boolean cancelRequest(Player p) {
        if (this.plugin.storage.tpaRequest.containsKey(p)) {
            Player player = this.plugin.storage.tpaRequest.get(p);
            if (player != null) {
                this.sendMessage(player, this.plugin.getConfig().getString("Timed-Out-Message"));
            }
            this.plugin.storage.tpaRequest.remove(p);
            return true;
        }
        return false;
    }

    public void sendRequest(Player sender, Player receiver) {
        this.sendMessage(sender, this.plugin.getConfig().getString("Sending-Teleport-Request").replace("%player%", receiver.getName()));
        if (this.plugin.versionHandler != null && !this.plugin.getConfig().getBoolean("disable-sound")) {
            this.plugin.versionHandler.sendSound(receiver, Sound.valueOf((String)this.plugin.getConfig().getString("Sound-Name")));
        }
        this.sendMessage(receiver, this.plugin.getConfig().getString("Sent-Request-On-You").replace("%player%", sender.getName()));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Time-Left").replace("%seconds%", String.valueOf(this.plugin.getConfig().getInt("keep-alive"))));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Accept-Message"));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Deny-Message"));
        this.plugin.storage.tpaRequest.put(receiver, sender);
        if (!this.plugin.getConfig().getBoolean("disable-accept-deny-buttons")) {
            this.addButtonsMethod(receiver);
        }
    }

    public boolean cancelTRequest(Player p) {
        if (this.plugin.storage.tpaHereRequest.containsKey(p)) {
            Player player = this.plugin.storage.tpaHereRequest.get(p);
            if (player != null) {
                this.sendMessage(player, this.plugin.getConfig().getString("Timed-Out-Here-Message"));
            }
            this.plugin.storage.tpaHereRequest.remove(p);
            return true;
        }
        return false;
    }

    public void sendTRequest(Player sender, Player receiver) {
        this.sendMessage(sender, this.plugin.getConfig().getString("Sending-Teleport-Here-Request").replace("%player%", receiver.getName()));
        if (this.plugin.versionHandler != null && !this.plugin.getConfig().getBoolean("disable-sound")) {
            this.plugin.versionHandler.sendSound(receiver, Sound.valueOf((String)this.plugin.getConfig().getString("Sound-Name")));
        }
        this.sendMessage(receiver, this.plugin.getConfig().getString("Sent-Here-Request-On-You").replace("%player%", sender.getName()));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Time-Left").replace("%seconds%", String.valueOf(this.plugin.getConfig().getInt("keep-alive"))));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Accept-Message"));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Deny-Message"));
        this.plugin.storage.tpaHereRequest.put(receiver, sender);
        if (!this.plugin.getConfig().getBoolean("disable-accept-deny-buttons")) {
            this.addButtonsMethod(receiver);
        }
    }

    public boolean cancelTAllRequest(Player p) {
        if (this.plugin.storage.tpaHereAllRequest.containsKey(p)) {
            if (p != null) {
                this.sendMessage(p, this.plugin.getConfig().getString("Timed-Out-Here-Message"));
            }
            this.plugin.storage.tpaHereAllRequest.remove(p);
            return true;
        }
        return false;
    }

    public void sendTAllRequest(Player sender, Player receiver) {
        this.sendMessage(sender, this.plugin.getConfig().getString("Teleport-Message-Back-To-Sender-TPHEREALL"));
        if (this.plugin.versionHandler != null && !this.plugin.getConfig().getBoolean("disable-sound")) {
            this.plugin.versionHandler.sendSound(receiver, Sound.valueOf((String)this.plugin.getConfig().getString("Sound-Name")));
        }
        this.sendMessage(receiver, this.plugin.getConfig().getString("Sent-Here-Request-On-You").replace("%player%", sender.getName()));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Time-Left").replace("%seconds%", String.valueOf(this.plugin.getConfig().getInt("keep-alive"))));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Accept-Message"));
        this.sendMessage(receiver, this.plugin.getConfig().getString("Deny-Message"));
        this.plugin.storage.tpaHereAllRequest.put(receiver, sender);
        if (!this.plugin.getConfig().getBoolean("disable-accept-deny-buttons")) {
            this.addButtonsMethod(receiver);
        }
    }

    public void consoleSendMessage(CommandSender sender) {
        String prefix = this.plugin.getConfig().getString("prefix") + " ";
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + this.plugin.getConfig().getString("Console-Isnt-Player"))));
    }

    public boolean checkDisabledWorlds(Player p) {
        if (this.plugin.getConfig().getStringList("disabled-worlds").contains(p.getWorld().getName())) {
            this.plugin.utils.sendMessage(p, this.plugin.getConfig().getString("Disabled-World-Message"));
            return false;
        }
        return true;
    }

    public void runInvincibilityTask(Player p) {
        if (!this.plugin.getConfig().getBoolean("disable-invincibility") && this.plugin.versionHandler != null) {
            this.plugin.versionHandler.setVuneralbleMethod(p, true);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.versionHandler.setVuneralbleMethod(p, false), (long)this.plugin.getConfig().getInt("invincibility-seconds") * 20L);
        }
    }

    public boolean checkGamemode(Player player) {
        if (!this.plugin.getConfig().getBoolean("disable-gamemode-check")) {
            String v = Bukkit.getServer().getClass().getPackage().getName();
            if ((v = v.substring(v.lastIndexOf(46) + 1)).equalsIgnoreCase("v1_7_R1") || v.equalsIgnoreCase("v1_7_R2") || v.equalsIgnoreCase("v1_7_R3") || v.equalsIgnoreCase("v1_7_R4")) {
                return true;
            }
            if (player != null && player.getGameMode() == GameMode.SPECTATOR) {
                this.plugin.utils.sendMessage(player, this.plugin.getConfig().getString("Different-Gamemode"));
                return false;
            }
        }
        return true;
    }
}

