#version 120

#define MAX_COLOR_RANGE 48.0
/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !



///-----CREDIT-----///
Chocapic13	-	base shaderpack
Monsterfish	-	visual design
CrankerMan	-	addition of various effects
CapTsatu	-	original author of the bloom code
Robobo1221	-	original author of the volumetric light code
///-----CREDIT-----///

///----DEVELOPER Triliton----///
Triliton - Developer 
///----DEVELOPER----///

!! DO NOT REMOVE !!
*/

//----------------------------ADJUSTABLE VARIABLES--//
//----------------------------ADJUSTABLE VARIABLES--//
//----------------------------ADJUSTABLE VARIABLES--//

///-----Shadows-----///
	const int shadowMapResolution = 2048;			// shadowmap resolution [1024 4096 8092]
	const float shadowDistance = 180.0;				// draw distance of shadows [50 100 110 120 130 140 150 160 170 190 200 250 300 350]
	#define SHADOW_DARKNESS 0.00340					// shadow darkness levels, lower values mean darker shadows, see .vsh for colors /0.25 is default
	#define HQ_SHADOW_FILTER						// smoother shadows
	//#define SHADOW_FILTER							// smoother shadows


///-----Sunlight-----///
	#define SUNLIGHTAMOUNT  2.75 					// change sunlight strength , see .vsh for colors. /1.70 is default [1.70 2.75 3.00 3.50 4.00 4.50 5.00]


//#define CLOUDS
	#define Clouds									//The shader clouds


///-----Torchlight-----///
	#define TORCH_COLOR_LIGHTING 2.50,0.742,0.21 	// Torch Color RGB - Red, Green, Blue / vec3(0.6,0.32,0.1) is default
		#define TORCH_ATTEN 4.0						// how much the torch light will be attenuated (decrease if you want the torches to cover a bigger area))/3.0 is default [1.0 2.0 3.0 5.0 6.0 7.0 8.0]
		#define TORCH_INTENSITY 0.17155913			// torch light intensity /2.6 is default [0.5 1.0 1.5 2.0 2.5 2.6 3.0 3.5 4.0]
		#define TORCH_MULT 1.25						// Torch lightmap attenuation function, where x is torch light from minecraft lightmap  : ((x*mult)^atten)*intensity
	#define DYNAMIC_HANDLIGHT


///-----Sky-----///
	#define ATTENUATION 2.00						// [1.00 3.00 4.00 5.00 6.00 7.00]

	
///-----Dynamic Exposure-----///
	#define DYNAMIC_EXPOSURE						// added by CrankerMAn and re-edited by Triliton
		#define DYNAMIC_EXPOSURE_VAR 5

#define STARS 
	

///-----Volumetric Light-----///
	#define VOLUMETRIC_LIGHT						// Original code by Robobo1221, added by CrankerMan
		#define VL_QUALITY 	3.0		  				// Quality of the Volumetric Light [1.0 2.0 3.0 4.0 5.0 6.0]


///-----2D Godrays-----///
	//#define GODRAYS
		const float density = 1.0;			
		const int NUM_SAMPLES = 22;					// increase this for better quality at the cost of performance /5 is default
		const float grnoise = 1.;					// amount of noise /0.012 is default


///-----Celshading-----///
	#define CELSHADING
		#define BORDER 0.10							// Celshading border strength [0.5 0.20 0.30 0.40 0.50]

///-----Water Caustics-----/// 						
	#define NEW_WATER_CAUSTIC						// added by Triliton
		#define CAUSTIC_STRENGHT 0.10				// [0.5 1.5 2.0 2.5 3.0 3.5]
		#define CAUSTIC_SIZE 1.0					// [0.5 1.5 2.5 3.0 3.5]
		#define CAUSTIC_SPEED 0.122					// [0.05 0.10 0.20 0.25 0.30]
		
const float	sunPathRotation	= -40.0f;			// determines sun/moon inclination /-25.0 is default - 0.0 is normal rotation

//----------------------------END OF ADJUSTABLE VARIABLES--//
//----------------------------END OF ADJUSTABLE VARIABLES--//
//----------------------------END OF ADJUSTABLE VARIABLES--//



const float 	wetnessHalflife 		= 70.0f;
const float 	drynessHalflife 		= 70.0f;

const bool 		shadowHardwareFiltering = true;

const int RGBA16 = 0;
const int gdepthFormat = RGBA16;

const int 		noiseTextureResolution  = 1024;
#define SHADOW_MAP_BIAS 0.85

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

varying vec4 lightS;

varying float handItemLight;
varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D gcolor;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2DShadow shadow;
uniform sampler2D gaux1;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform int fogMode;

float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float cdist(vec2 coord){
    return distance(coord,vec2(0.5))*2.0;
}

vec3 convertScreenSpaceToWorldSpace(vec2 co, float depth) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, depth) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
    return screenSpace;
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float edepth(vec2 coord) {
	return texture2D(depthtex0,coord).z;
}
vec2 newtc = texcoord.xy;
vec3 sky_color = normalize(vec3(0.1, 0.35, 1.));

vec2 texel = vec2(1.0/viewWidth,1.0/viewHeight);

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

vec3 aux = texture2D(gaux1, texcoord.st).rgb;
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;


float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
float handlight = handItemLight;


float torch_lightmap = pow(max(aux.b,0.0)* TORCH_MULT,TORCH_ATTEN)*TORCH_INTENSITY;


float sky_lightmap = pow(aux.r,ATTENUATION);

float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,upVec),0.0));

	
//poisson distribution for shadow sampling		
	const vec2 shadow_offsets[60] = vec2[60]  (  vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.6495, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.6495, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.6495, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));
									

									

float ctorspec(vec3 ppos, vec3 lvector, vec3 normal,float rough,float fpow) {
	//half vector
	vec3 pos = -normalize(ppos);
	vec3 cHalf = normalize(lvector + pos);
	
	// beckman's distribution function D
	float normalDotHalf = dot(normal, cHalf);
	float normalDotHalf2 = normalDotHalf * normalDotHalf;
	
	float roughness2 = rough;
	float exponent = -(1.0 - normalDotHalf2) / (normalDotHalf2 * roughness2);
	float e = 2.71828182846;
	float D = pow(e, exponent) / (roughness2 * normalDotHalf2 * normalDotHalf2);
	
	// fresnel term F
	float normalDotEye = dot(normal, pos);
	float F = pow(1.0 - normalDotEye, fpow);

	// self shadowing term G
	float normalDotLight = dot(normal, lvector);
	float X = 2.0 * normalDotHalf / dot(pos, cHalf);
	float G = min(1.0, min(X * normalDotLight, X * normalDotEye));
	float pi = 3.1415927;
	float CookTorrance = (D*G)/acos(normalDotEye);
	
	return clamp(CookTorrance/pi,0.0,1.0);
}

float Blinn_Phong(vec3 ppos, vec3 lvector, vec3 normal,float fpow, float gloss, float visibility)  {
	vec3 lightDir = vec3(lvector);
	
	vec3 surfaceNormal = normal;
	float cosAngIncidence = dot(surfaceNormal, lightDir);
	cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);
	
	vec3 viewDirection = normalize(-ppos);
	
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	
	float normalDotEye = dot(normal, normalize(ppos));
	float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0);
	fresnel = fresnel*0.85 + 0.15 * (1.0-fresnel);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss*10.0);
	return (pow(blinnTerm, n )*((n+8.0)/(8*pi)))*visibility;
}

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

#ifdef CELSHADING
vec3 celshade(vec3 clrr) {
	//edge detect
	float d = edepth(newtc.xy);
	float dtresh = 1/(far-near)/5000.0;	
	vec4 dc = vec4(d,d,d,d);
	vec4 sa;
	vec4 sb;
	sa.x = edepth(newtc.xy + vec2(-pw,-ph)*BORDER);
	sa.y = edepth(newtc.xy + vec2(pw,-ph)*BORDER);
	sa.z = edepth(newtc.xy + vec2(-pw,0.0)*BORDER);
	sa.w = edepth(newtc.xy + vec2(0.0,ph)*BORDER);
	
	//opposite side samples
	sb.x = edepth(newtc.xy + vec2(pw,ph)*BORDER);
	sb.y = edepth(newtc.xy + vec2(-pw,ph)*BORDER);
	sb.z = edepth(newtc.xy + vec2(pw,0.0)*BORDER);
	sb.w = edepth(newtc.xy + vec2(0.0,-ph)*BORDER);
	
	vec4 dd = abs(2.0* dc - sa - sb) - dtresh;
	dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));
	
	float e = clamp(dot(dd,vec4(0.25f,0.25f,0.25f,0.25f)),0.0,1.0);
	return clrr*e;
}
#endif

float fx(float x) {
return (2 *(-sin(x)*sin(x)*sin(x) + 3*sin(x) + 3*x)) / 3;

}
float fx2(float x) {
return (-cos(x) * sin(x) + 6*x) / 2;

}

vec3 skyLightColor (vec3 fposition) {
vec3 skycoaa = ivec3(60,170,255)/255.0;
vec3 sky_color = pow(skycoaa,vec3(2.2));
vec3 nsunlight = normalize(pow(sunlight,vec3(2.2)));
sky_color = normalize(mix(sky_color,vec3(0.25,0.3,10.4)*length(ambient_color),rainStrength)); //normalize colors in order to don't change luminance
vec3 sVector = normalize(fposition);
const float PI = 3.14159265359;
float cosT = dot(sVector,upVec); 
float T = acos(cosT);
float absCosT = abs(cosT);
float cosS = SdotU;
float S = acos(cosS);				
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);			

float tL = ((fx(Y+PI/2.0)-fx(Y-PI/2.0))*2.5 + fx2(T+PI/2.0)-fx2(T-PI/2.0))/6.28;

//moon sky color
float McosS = MdotU;
float MS = acos(McosS);
float McosY = dot(moonVec,sVector);
float MY = acos(McosY);
float tLMoon = ((fx(MY+PI/2.0)-fx(MY-PI/2.0))*3.0 + fx2(T+PI/2.0)-fx2(T-PI/2.0))/6.28;

return mix(sky_color, nsunlight,1-exp(-0.16*tL*(1-rainStrength*0.8)))*tL*sunVisibility*(1-rainStrength*0.8) + tLMoon*moonVisibility*moonlight;
}

float subSurfaceScattering(vec3 pos, float N) {

return pow(max(dot(lightVector,normalize(pos)),0.0),N)*(N+1)/6.28;

}

#ifdef Clouds
vec3 drawCloud(vec3 fposition,vec3 color, float mult, float transition_fading) {
   float Size = 1.0;
   vec3 sVector = normalize(fposition);
   float cosT = max(dot(normalize(sVector),upVec),0.0);
   vec3 tpos = vec3(gbufferModelViewInverse * vec4(sVector,0.0));
   vec3 wvec = normalize(tpos);
   vec3 wVector = normalize(tpos);

   vec3 cloudCol = pow(sunlight * 2.4,vec3(3.4))*(TimeSunrise+TimeSunset);
    cloudCol += (vec3(1.0) * 2.0)*(TimeNoon);
    cloudCol += (sunlight * 30.0)*(TimeMidnight); //this changes cloud colour for night
    cloudCol += pow(sunlight * 1.5,vec3(3.0)) * (1-transition_fading);

   float totalcloud = 0.0;

   float height = (700.0)/(wVector.y);
   vec2 wind = vec2(abs(frameTimeCounter/20000.-0.5),abs(frameTimeCounter/20000.-0.5))+vec2(0.5);

   vec3 intersection;
   float density;
   float d1;

   int Steps = 5;
   float weight;

   for (int i = 0; i < Steps; i++) {
    intersection = wVector * (height - i * 150 * Size / Steps);    //curved cloud plane

    vec2 coord1 = (intersection.xz+cameraPosition.xz*2.5)/200000;
    coord1 += (wind);
    vec2 coord = (coord1/Size);

    float noise = texture2D(noisetex,coord - wind * 0.5).x;
    noise += texture2D(noisetex,coord*3.5).x/3.5;
    noise += texture2D(noisetex,coord*6.125).x/6.125;
    noise += texture2D(noisetex,coord*12.25).x/12.25;
    noise /= clamp(texture2D(noisetex,coord / 4.1).x * 1.25,0.0,1.0);
    noise *= (pow(noise, pow(2.0 * pow(1.0,0.5),0.5)));
    noise /= 0.13;

    float cl = max(noise-0.7,0.0);
    cl = max(cl,0.)*0.05 * (1.0 - rainx * 0.9);
    density = max(1-cl*2.5,0.)*max(1-cl*2.5,0.) / 11.0 / 3.0;
    density *= 2.0;

    totalcloud += density;
    if (totalcloud > (1.0 - 1.0 / Steps + 0.1)) break;
    weight ++;

   }

   cloudCol = mix(cloudCol*pow(1-density, 2.0),vec3(cloudCol*0.125),pow(density, 2.0)) * 2.0;

   cloudCol += pow(sunlight * mix(3.0,2.4,TimeSunset + TimeSunrise),vec3(mix(3.4 - (1.0 * (1.0 - transition_fading)),1.0,TimeNoon)))* (50*(pow(1-density, 100.0 * (1-(1-transition_fading * 0.5))))) * mix(1.0,0.1,1.0 - transition_fading) * 1.5 * (1-(TimeMidnight * transition_fading)) * (1-rainx);
   cloudCol += pow(sunlight * mix(3.0,2.4,TimeSunset + TimeSunrise),vec3(mix(3.4 - (1.0 * (1.0 - transition_fading)),1.0,TimeNoon))) * 25 * (1- TimeMidnight);
   cloudCol += moonlight * (50*(pow(1-density, 14.0))) * 70 * transition_fading * (1-rainx);

   cloudCol *= (1- (0.5 * TimeMidnight * transition_fading));
   cloudCol *= (1+ TimeNoon);


   totalcloud = min(totalcloud / weight,1.0);
   totalcloud = mix(totalcloud,(0.0),pow(1-density, 100.0));
   return mix(color.rgb,cloudCol * mult/50/0.1 * 0.1 * 0.1 * (1.0 - rainx * 0.8),clamp(totalcloud*50,0.0,1.0) * pow(cosT,1.0)); //These are cloud colours
 }
#endif
#ifdef STARS
vec3 fake_star(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float McosY = MdotU;
float cosY = SdotU;
//star generation
/*----------*/
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);
vec3 intersection = wVector*(50.0/(wVector.y));



//float canHit = length(intersection)-length(tpos);

	vec2 wind = vec2(frameTimeCounter*(cos(frameTimeCounter/25000.0)+0.5),frameTimeCounter*(sin(frameTimeCounter/25000.0)+0.5));
	
	
	vec3 wpos = tpos.xyz+cameraPosition;
	intersection.xz = intersection.xz + 5.0*cosT*intersection.xz;		//curve the star pattern, because sky is not 100% plane in reality
	vec2 coord = (intersection.xz+(wind/56))/512.0;
	vec2 coord1 = (intersection.xz+(wind/40))/512.0;
	float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;

	  float N = 8.0;
vec3 star_color = vec3(1.0, 1.0, 1.5)*1.0*moonVisibility*(1-rainStrength) + moonlight*0.10*pow(max(McosY,0.0),N)*(N+1)/6.28  * (1-rainStrength)*moonVisibility ;	//coloring stars
/*----------*/

	noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
	noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;

	float cl = max(noise-1.6,0.0);
	float ef = 0.01;
 
      float star2 = (1.0 - (pow((1-rainStrength*0.9)*ef,cl)))*max(cosT,0.0);
	  
	  
vec3 s = mix(color,star_color*(0.2),star2); //star brightness  



//s = mix(s,star_color,star);  //mix up sky color and stars



return s;
}
#endif   
vec3 getSkyColor(vec3 fposition) {
//sky gradient
/*----------*/
vec3 skycoaa = ivec3(30,170,255)/255.0;
vec3 sky_color = pow(skycoaa,vec3(2.2));
vec3 nsunlight = normalize(pow(sunlight,vec3(2.2)));
vec3 sVector = normalize(fposition);

sky_color = normalize(mix(sky_color,vec3(0.25,0.3,0.4)*length(ambient_color),rainStrength)); //normalize colors in order to don't change luminance


float Lz = 1.0;
float cosT = dot(sVector,upVec); //T=S-Y  
float absCosT = abs(cosT);
float cosS = SdotU;
float S = acos(cosS);				//S=Y+T	-> cos(Y+T)=cos(S) -> cos(Y)*cos(T) - sin(Y)*sin(T) = cos(S)
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);				//Y=S-T


float a = -0.7;
float b = -0.2;
float c = 12.0;
float d = -0.9;
float e = 3.0;

//sun sky color
float L =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*Y)+e*cosY*cosY); 
L = pow(L,1.0-rainStrength*0.8)*(1.0-rainStrength*0.2); //modulate intensity when raining
vec3 skyColorSun = mix(sky_color, nsunlight,1-exp(-0.13*L*(1-rainStrength*0.8)))*L ; //affect color based on luminance (0% physically accurate)
skyColorSun *= sunVisibility;


//moon sky color
float McosS = MdotU;
float MS = acos(McosS);
float McosY = dot(moonVec,sVector);
float MY = acos(McosY);

float L2 =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*MY)+e*McosY*McosY);
L2 = pow(L2,1.0-rainStrength*0.8)*(1.0-rainStrength*0.2); //modulate intensity when raining
vec3 skyColormoon = mix(moonlight,normalize(vec3(0.25,0.3,0.4))*length(moonlight),rainStrength)*L2*0.4 ; //affect color based on luminance (0% physically accurate)
skyColormoon *= moonVisibility;

sky_color = skyColormoon+skyColorSun/2.0;
//sky_color = vec3(Lc);
/*----------*/


return sky_color;
}

float PosDot(vec3 v1,vec3 v2) {
return max(dot(v1,v2),0.0);
}

float waterH(vec3 posxz) {

vec2 movement = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement2 = vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement3 = vec2(-abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));
vec2 movement4 = vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));

vec2 coord = (posxz.xz/600)+(movement);
vec2 coord1 = (posxz.xz/599.9)+(movement2);
vec2 coord2 = (posxz.xz/599.8)+(movement3);
vec2 coord3 = (posxz.xz/599.7)+(movement4);
vec2 coord4 = (posxz.xz/1600)+(movement/1.5);
vec2 coord5 = (posxz.xz/1599)+(movement2/1.5);
vec2 coord6 = (posxz.xz/1598)+(movement3/1.5);
vec2 coord7 = (posxz.xz/1597)+(movement4/1.5);
float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;
float noise2 = texture2D(noisetex,fract(coord.xy/2.0)).x;
noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord1.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord1.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord2.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord2.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord2.xy*4.0)).x/8.0;
noise += texture2D(noisetex,fract(coord3.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord3.xy*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord3.xy*4.0)).x/8.0;
noise2 += texture2D(noisetex,fract(coord4.xy)).x/2.0;
noise2 += texture2D(noisetex,fract(coord4.xy*2.0)).x/4.0;
noise2 += texture2D(noisetex,fract(coord4.xy*4.0)).x/8.0;
noise2 += texture2D(noisetex,fract(coord5.xy)).x/2.0;
noise2 += texture2D(noisetex,fract(coord5.xy*2.0)).x/4.0;
noise2 += texture2D(noisetex,fract(coord5.xy*4.0)).x/8.0;
noise2 += texture2D(noisetex,fract(coord6.xy)).x/2.0;
noise2 += texture2D(noisetex,fract(coord6.xy*2.0)).x/4.0;
noise2 += texture2D(noisetex,fract(coord6.xy*4.0)).x/8.0;
noise2 += texture2D(noisetex,fract(coord7.xy)).x/2.0;
noise2 += texture2D(noisetex,fract(coord7.xy*2.0)).x/4.0;
noise2 += texture2D(noisetex,fract(coord7.xy*4.0)).x/8.0;

return noise+noise2;
}



#ifdef VOLUMETRIC_LIGHT

// dirived from: http://devlog-martinsh.blogspot.nl/2011/03/glsl-8x8-bayer-matrix-dithering.html
float find_closest(vec2 pos, float sample)
{
		float dither[64] = float[64](
		0, 32, 8, 40, 2, 34, 10, 42, 			/* 8x8 Bayer ordered dithering 	*/
		48, 16, 56, 24, 50, 18, 58, 26,			/* pattern. Each input pixel 	*/
		12, 44, 4, 36, 14, 46, 6, 38, 			/* is scaled to the 0..63 range */
		60, 28, 52, 20, 62, 30, 54, 22,			/* before looking in this table */
		3, 35, 11, 43, 1, 33, 9, 41, 			/* to determine the action. 	*/
		51, 19, 59, 27, 49, 17, 57, 25,
		15, 47, 7, 39, 13, 45, 5, 37,
		63, 31, 55, 23, 61, 29, 53, 21);

	vec2 texMod = pos;
	vec2 aspectCorrect = vec2(viewWidth, viewHeight);
	texMod = mod(texMod * aspectCorrect, sqrt(64));
	float limit;

	for (int i = 0; i < (int(texMod.x) + int(texMod.y)*sqrt(64)); i++) {
		limit = (dither[i])/sqrt(64 * 64);
	}
	return limit * sample;
}

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float distx(float dist){
	return (((dist - near) * far) / ((far - near) * dist));
}

float dynamicExposure()
{
	return mix(1.0,0.0,(pow(eyeBrightnessSmooth.y / 240.0f, 3.0f)));
}




struct vlStruct {

	vec4 fragpos;
	vec4 worldposition;

	vec3 pos;

	vec2 pushback;

	float Quality;
	float steps;
	float ditherPattern;
	float maxDist;
	float minDist;
	float d;
	float distb;
	float distortFactor;
	float VolumetricRays;
	float weight;

} vl;

float GetVolumetricRays() {

	///////////////////////Setting up functions///////////////////////

		vl.Quality = 4.0 / VL_QUALITY;
		vl.steps = vl.Quality;

		vl.ditherPattern = find_closest(texcoord.st, vl.steps);

		vl.maxDist = (180.0);
		vl.minDist = (0.01);

		vl.minDist += vl.ditherPattern;
		vl.weight = (vl.maxDist / vl.steps);

		vl.pushback = vec2(0.001, -0.001);										//Fixes light leakage from walls

		for (vl.minDist; vl.minDist < vl.maxDist;) {

		///////////////////////MAKING VL NOT GO THROUGH WALLS///////////////////////

			if (getDepth(pixeldepth) < vl.minDist){
				break;
			}

		///////////////////////Getting worldpositon///////////////////////

			vl.d = distx(vl.minDist);
			vl.fragpos = nvec4(convertScreenSpaceToWorldSpace(texcoord.st, vl.d) * 1.0);
			vl.worldposition = vec4(gbufferModelViewInverse * vl.fragpos);

		///////////////////////Converting ScreenSpace to ShadowSpace///////////////////////

			vl.worldposition = (shadowModelView * vl.worldposition);
			vl.worldposition = (shadowProjection * vl.worldposition);

		///////////////////////Rescaling ShadowMaps///////////////////////

			vl.distb = sqrt(vl.worldposition.r*vl.worldposition.r + vl.worldposition.g*vl.worldposition.g);
			vl.distb *= SHADOW_MAP_BIAS;
			vl.distortFactor = 1.0 - SHADOW_MAP_BIAS;
			vl.distortFactor -= vl.distb * - 1.0;

			vl.pos = vl.worldposition.rgb;
			vl.pos.rg /= (sqrt(vl.distortFactor / vl.distortFactor) * (vl.distortFactor));

		///////////////////////Projecting shadowmaps on a linear depth plane///////////////////////

			vl.VolumetricRays += (shadow2D(shadow, vec3(vl.pos.rg, vl.pos.b + vl.pushback.r) * 0.5 + 0.5).z);

			vl.minDist = vl.minDist + vl.steps;
	}

	///////////////////////Returning the program///////////////////////

		vl.VolumetricRays /= vl.weight;
		vl.VolumetricRays *= 0.15;

		return mix(vl.VolumetricRays, clamp(vl.VolumetricRays, 0.0, 0.1), dynamicExposure());
		//return vl.VolumetricRays;
}


#else
	float GetVolumetricRays(){

		return 0.0;
	}
#endif


#ifdef DYNAMIC_EXPOSURE
	vec3 dynamicExposure(vec3 color) {
		return color.rgb * clamp((-eyeBrightnessSmooth.y+230)/100.0,0.0,1.0)*DYNAMIC_EXPOSURE_VAR;
int LOD = int(log2(max(viewWidth, viewHeight)));		
	}
#endif

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	
#ifndef DYNAMIC_HANDLIGHT
		handlight = 0.0;
#endif
	vec2 newtc = texcoord.xy;
	//unpack material flags
	float land = float(aux.g > 0.04);
	float iswater = float(aux.g > 0.04 && aux.g < 0.07);
	float translucent = float(aux.g > 0.3 && aux.g < 0.5);
	float hand = float(aux.g > 0.75 && aux.g < 0.85);
	float emissive = float(aux.g > 0.58 && aux.g < 0.62);
	float shading = 0.0f;
	float spec = 0.0;
	
vec3 nsunlight = normalize(mix(pow(sunlight,vec3(2.2)),vec3(0.25,0.3,0.4),rainStrength));
sky_color = normalize(mix(sky_color,vec3(0.25,0.3,0.4),rainStrength)); //normalize colors in order to don't change luminance
	
	float fresnel_pow = 5.0;
	
	vec3 color = texture2D(gcolor, newtc.st).rgb;
	color = pow(color,vec3(2.2))*(1.0+translucent*0.3);
	
	float NdotL = dot(lightVector,normal);
	float NdotUp = dot(normal,upVec);
	
	vec4 fragposition = gbufferProjectionInverse * vec4(newtc.s * 2.0f - 1.0f, newtc.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	
		vec4 worldposition = vec4(0.0);
		vec4 worldpositionraw = vec4(0.0);
		worldposition = gbufferModelViewInverse * fragposition;	
		float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
		float yDistanceSquared  = worldposition.y * worldposition.y;
		worldpositionraw = worldposition;
		
	vec4 uwPos = gbufferProjectionInverse * vec4(newtc.s * 2.0f - 1.0f, newtc.t * 2.0f - 1.0f, 2.0f * texture2D(depthtex1,texcoord.xy).r - 1.0f, 1.0f);
	uwPos /= uwPos.w;
	uwPos = gbufferModelViewInverse * uwPos + vec4(cameraPosition.xyz,0.0);
		
		
	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13500.0)/300.0,0.0,1.0) + clamp((time-22500.0)/300.0,0.0,1.0)-clamp((time-23400.0)/300.0,0.0,1.0));	//fading between sun/moon shadows
	float night = clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-22800.0)/200.0,0.0,1.0);
	
	vec3 posxz = worldposition.xyz+cameraPosition;
	posxz.x += sin(posxz.z+frameTimeCounter)*0.4;
	posxz.z += cos(posxz.x+frameTimeCounter*0.5)*0.4;
	
	vec3 uPos = vec3(0.0);
	float deltaPos = 0.4;
	float h0 = 0.0;
	float h1 = 0.0;
	float h2 = 0.0;
	float h3 = 0.0;
	float h4 = 0.0;
	
	if (iswater > 0.9) {
	h0 = waterH(posxz);
	h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));
	
	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	
	float refMult = 0.0025-dot(normal,normalize(fragposition).xyz)*0.0015;
	
	vec3 refract = normalize(vec3(xDelta,yDelta,1.0-xDelta*xDelta-yDelta*yDelta));
	vec4 rA = texture2D(gcolor, newtc.st + refract.xy*refMult);
	rA.rgb = pow(rA.rgb,vec3(2.2));
	vec4 rB = texture2D(gcolor, newtc.st);
	rB.rgb = pow(rB.rgb,vec3(2.2));
	float mask = texture2D(gaux1, newtc.st + refract.xy*refMult).g;
	mask =  float(mask > 0.04 && mask < 0.07);
	newtc = (newtc.st + refract.xy*refMult)*mask + texcoord.xy*(1-mask);
	float uDepth = texture2D(depthtex1,newtc.xy).x;
	color.rgb = pow(texture2D(gcolor,newtc.xy).rgb,vec3(2.2));
	uPos  = nvec3(gbufferProjectionInverse * nvec4(vec3(newtc.xy,uDepth) * 2.0 - 1.0));	
	}
	
	
	if (land > 0.9) {
		float dist = length(fragposition.xyz);
		float distof = clamp(1.0-dist/shadowDistance,0.0,1.0);
		float distof2 = clamp(1.0-pow(dist/(shadowDistance*0.75),2.0),0.0,1.0);
		//float shadow_fade = clamp(distof*12.0,0.0,1.0);
		float shadow_fade = sqrt(clamp(1.0 - xzDistanceSquared / (shadowDistance*shadowDistance*1.0), 0.0, 1.0) * clamp(1.0 - yDistanceSquared / (shadowDistance*shadowDistance*1.0), 0.0, 1.0));

		
		/*--reprojecting into shadow space --*/

		worldposition = shadowModelView * worldposition;
		float comparedepth = -worldposition.z;
		worldposition = shadowProjection * worldposition;
		worldposition /= worldposition.w;
		float distb = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
		float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
		worldposition.xy *= 1.0f / distortFactor;
		worldposition = worldposition * 0.5f + 0.5f;
		/*---------------------------------*/
		
		
		float step = 3.0/shadowMapResolution*(1.0+rainStrength*5.0);
		//shadow_fade = 1.0-clamp((max(abs(worldposition.x-0.5),abs(worldposition.y-0.5))*2.0-0.9),0.0,0.1)*10.0;
		
		float NdotL = dot(normal, lightVector);
		float diffthresh = (pow(distortFactor*1.2,2.0)*(0.25/148.0)*(tan(acos(abs(NdotL)))) + (0.02/148.0))*(1.0+iswater*2.0);
		diffthresh = mix(diffthresh,0.0005,translucent);
		
		if (comparedepth > 0.02 &&	worldposition.s < 0.98 && worldposition.s > 0.02 && worldposition.t < 0.98 && worldposition.t > 0.02 ) {
			if ((NdotL < 0.0 && translucent < 0.1) || (sky_lightmap < 0.01 && eyeBrightness.y < 2)) {
					shading = 0.0;
				}
			
			else {
			#ifdef HQ_SHADOW_FILTER
				step = 4.0/shadowMapResolution*(1.0+rainStrength*5.0);
				//diffthresh = 0.0018f * diffthresh * (0.5+(1.0-NdotL)*5.0*(1.0-translucent));
				float weight;
				float totalweight = 0.0;
				float sigma = 0.25;
				float A = 1.0/sqrt(2.0*3.14159265359*sigma);
				
				for(int i = 0; i < 60; i++){
					float dist = length(shadow_offsets[i]);
					float weight = A*exp(-(dist*dist)/(2.0*sigma));
					shading += shadow2D(shadow,vec3(worldposition.st + shadow_offsets[i]*step, worldposition.z-diffthresh*(2.0-weight))).x;
					totalweight += 1;
				}
			
			shading /= totalweight;
			#endif
			
			step = 0.5/shadowMapResolution*(1.0+rainStrength*5.0);
			
			#ifdef SHADOW_FILTER
				shading = shadow2D(shadow,vec3(worldposition.st, worldposition.z-diffthresh)).x;
				shading += shadow2D(shadow,vec3(worldposition.st + vec2(step,0), worldposition.z-diffthresh*2)).x;
				shading += shadow2D(shadow,vec3(worldposition.st + vec2(-step,0), worldposition.z-diffthresh*2)).x;
				shading += shadow2D(shadow,vec3(worldposition.st + vec2(0,step), worldposition.z-diffthresh*2)).x;
				shading += shadow2D(shadow,vec3(worldposition.st + vec2(0,-step), worldposition.z-diffthresh*2)).x;
				shading = shading/5.0;
			#endif
			
			#ifndef SHADOW_FILTER
				#ifndef HQ_SHADOW_FILTER
				shading = shadow2D(shadow,vec3(worldposition.st, worldposition.z-diffthresh)).x;
				#endif
			#endif 
			}
		}
		
		
		else shading = 0.10;
		if (sky_lightmap < 0.02 && eyeBrightness.y < 2) {
					shading = 0.0;
				}
				
		vec3 npos = normalize(fragposition.xyz);

		float diffuse = max(dot(lightVector,normal),0.0);
		//monster
		diffuse = mix(diffuse,0.0150,translucent*1.000);
		float sss = subSurfaceScattering(fragposition.xyz,30.0)*SUNLIGHTAMOUNT*2.0;
		sss = (mix(0.0,sss,max(shadow_fade-0.5,0.0)*2.0)*0.5+0.5)*translucent;
		
		float handLight = (handlight*1.5)/pow(0.30+length(fragposition.xyz/0.4),2.0)*sqrt(dot(normalize(fragposition.xyz), -normal)*0.5+0.51);
		
	//Apply different lightmaps to image Monsterfish
		shading *= 1-isEyeInWater;
		
		vec3 light_col =  mix(pow(sunlight,vec3(2.2)),moonlight,moonVisibility);
		light_col = mix(light_col,vec3(length(light_col))*0.3,rainStrength*0.9);
		vec3 Sunlight_lightmap = light_col*shading*(1.0-rainStrength*0.95)*SUNLIGHTAMOUNT *diffuse*transition_fading ;

		vec3 Ucolor= normalize(vec3(0.1,0.4,0.6));

		//we'll suppose water plane have same height above pixel and at pixel water's surface
			//underwater position
		
		vec3 uVec = fragposition.xyz-uPos;
		float UNdotUP = abs(dot(normalize(uVec),normal));
		float depth = length(uVec)*UNdotUP;
		float sky_absorbance = mix(mix(1.0,exp(-depth/4.0),iswater),1.0,isEyeInWater);
		
		vec3 causticcol = vec3(0.0);
		#ifdef NEW_WATER_CAUSTIC
		float caustic = 0;
		float csmask = mix(iswater,1-iswater,isEyeInWater);
		float cstorchlm = max(1-sky_lightmap*1.2*mix(1-night*0.5,0.5,rainStrength),0.0)*(max(torch_lightmap-0.1,0.0)+pow(handLight*0.9,2.2)*4)*10;
		cstorchlm *= csmask;
		csmask *= max(shading,sky_lightmap*0.1)*(1-night*0.95)*(1-rainStrength);
		vec3 cslc = (sunlight*sunVisibility+moonlight*(1+moonVisibility*128))*(1-isEyeInWater)+isEyeInWater*0.5;

		h0 = waterH(uwPos.xyz);
		h1 = waterH(uwPos.xyz + vec3(deltaPos,0.0,0.0));	
		h2 = waterH(uwPos.xyz + vec3(-deltaPos,0.0,0.0));
		h3 = waterH(uwPos.xyz + vec3(0.0,0.0,deltaPos));
		h4 = waterH(uwPos.xyz + vec3(0.0,0.0,-deltaPos));
		caustic = max(2-(abs(h2-h1)+abs(h4-h3))-pow(abs(h0-0.5),0.95)*0.1,0.0);
		caustic = max(pow(caustic,2.0),0.0);
		causticcol = caustic*((1+color)*cslc*csmask+vec3(TORCH_COLOR_LIGHTING)*cstorchlm);
		#endif

		
		float visibility = sky_lightmap;
		float bouncefactor = sqrt((NdotUp*0.4+0.61) * pow(1.01-NdotL*NdotL,2.0)+2.5)*20.55866; 
		float cfBounce = (-NdotL*0.45+0.56);
		


		vec3 emissive = (1/length(color))*(emissive+handlight*hand)*eyeAdapt*color*0.02;

		vec3 bounceSunlight = 0.16*cfBounce*light_col*sky_lightmap*sky_lightmap*sky_lightmap*SHADOW_DARKNESS * (1-rainStrength*0.9);
		
		float tL = (lightS.x*pow(sky_lightmap,2.2) + lightS.y)/4.5;
		float tLMoon = (lightS.z + lightS.w)/3.;
		
		vec3 skycolor = mix(sky_color, nsunlight,1-exp(-0.11*tL*(1-rainStrength*0.8)))*tL*sunVisibility*(1-rainStrength*0.8) + tLMoon*moonVisibility*moonlight;

		vec3 sky_light = SHADOW_DARKNESS*skycolor*visibility*bouncefactor*(1+moonVisibility*0.7);

		vec3 torchcolor = vec3(TORCH_COLOR_LIGHTING)*eyeAdapt;
		vec3 Torchlight_lightmap = (torch_lightmap + handLight) *  torchcolor ;
		Torchlight_lightmap = max(vec3(0.0005),Torchlight_lightmap);
		vec3 color_torchlight = Torchlight_lightmap;
		
		
		
		color = ((bounceSunlight+sky_light)+ Sunlight_lightmap + color_torchlight  +  sss * light_col * shading *(1.0-rainStrength*0.9)*transition_fading + emissive + causticcol)*color*sky_absorbance;
		//color.rgb  = bounceSunlight;	
		if (iswater > 0.9) color = mix(Ucolor*length(ambient_color)*0.00424*sky_lightmap,color,exp(-depth/16));
		
		//Monster watercolor ambient 
		
		float gfactor = 1.0;
		spec = Blinn_Phong(fragposition.xyz,lightVector,normal,fresnel_pow,gfactor,shading*diffuse) *land * (1.0-isEyeInWater)*transition_fading;
	}
	else{
  #ifdef STARS
    color = fake_star(fragposition.xyz,color);
    #endif
    color = drawCloud(fragposition.xyz,color,1.0,transition_fading);
color *= 2.2;
} 
	

float gr = 0.0;
#ifdef GODRAYS
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;
	

		vec2 deltaTextCoord = vec2( newtc.st - lightPos.xy );
		vec2 textCoord = newtc.st;
		deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
		float avgdecay = 0.0;
		float distx = abs(newtc.x*aspectRatio-lightPos.x*aspectRatio);
		float disty = abs(newtc.y-lightPos.y);
		float fallof = 1.0;
		float noise = getnoise(textCoord);
		
		for(int i=0; i < NUM_SAMPLES ; i++) {			
			textCoord -= deltaTextCoord;

			fallof *= 0.7;
			float sample = step(texture2D(gaux1, textCoord+ deltaTextCoord*noise*grnoise).g,0.01);
			gr += sample*fallof;
		}

#endif
	
#ifdef CELSHADING
	if (iswater < 0.9) color = celshade(color);
#endif


#ifdef DYNAMIC_EXPOSURE
	color.rgb += dynamicExposure(color);
#endif



color = clamp(pow(color/MAX_COLOR_RANGE,vec3(1.0/2.2)),0.0,1.0);
	
/* DRAWBUFFERS:31 */
	gl_FragData[0] = vec4(color, spec);
	#ifdef VOLUMETRIC_LIGHT
	gl_FragData[1] = vec4(0,GetVolumetricRays(),1.0,1.0);
	#else
	gl_FragData[1] = vec4(vec3((gr/NUM_SAMPLES)),1.0);
	#endif
}

