/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import org.apache.commons.lang3.StringUtils;

public abstract class PartialReloader<T> {
    public static final Gson GSON = new Gson();
    protected String[] names;

    protected PartialReloader(String ... name) {
        this.names = name;
    }

    public String toString() {
        return StringUtils.capitalize((String)(this.names[0].replace("_", " ") + " Reloader"));
    }

    protected Map<ResourceLocation, JsonElement> getJsonsInDirectories(ResourceManager resourceManager) {
        HashMap<ResourceLocation, JsonElement> jsons = new HashMap<ResourceLocation, JsonElement>();
        for (String name : this.names) {
            HashMap js = new HashMap();
            SimpleJsonResourceReloadListener.m_278771_((ResourceManager)resourceManager, (String)("polytone/" + name), (Gson)GSON, js);
            PartialReloader.greedyAddAll(js, jsons);
        }
        return jsons;
    }

    private static <T> void greedyAddAll(Map<ResourceLocation, T> js, Map<ResourceLocation, T> jsons) {
        for (Map.Entry<ResourceLocation, T> entry : js.entrySet()) {
            ResourceLocation r = entry.getKey();
            T j = entry.getValue();
            if (jsons.containsKey(r)) {
                Polytone.LOGGER.warn("Duplicate data file ignored with ID {}", (Object)r);
            }
            jsons.put(r, j);
        }
    }

    protected Map<ResourceLocation, ArrayImage> getImagesInDirectories(ResourceManager resourceManager) {
        HashMap<ResourceLocation, ArrayImage> images = new HashMap<ResourceLocation, ArrayImage>();
        for (String name : this.names) {
            HashMap<ResourceLocation, ArrayImage> im = new HashMap<ResourceLocation, ArrayImage>();
            ArrayImage.scanDirectory(resourceManager, "polytone/" + name, im);
            PartialReloader.greedyAddAll(im, images);
        }
        return images;
    }

    protected Map<ResourceLocation, ArrayImage.Group> getGroupedImagesInDirectories(ResourceManager manager) {
        return ArrayImage.groupTextures(this.getImagesInDirectories(manager));
    }

    protected abstract T prepare(ResourceManager var1);

    protected abstract void reset();

    protected abstract void process(T var1, DynamicOps<JsonElement> var2);

    protected void apply() {
    }

    protected void checkConditions(Map<ResourceLocation, JsonElement> object) {
        object.entrySet().removeIf(e -> {
            JsonObject jo;
            JsonElement je;
            Object patt0$temp = e.getValue();
            if (patt0$temp instanceof JsonObject && (je = (jo = (JsonObject)patt0$temp).get("require_mods")) != null) {
                if (je.isJsonArray()) {
                    for (JsonElement el : je.getAsJsonArray()) {
                        if (PlatStuff.isModLoaded(el.getAsString())) continue;
                        return true;
                    }
                } else if (je.isJsonPrimitive()) {
                    return !PlatStuff.isModLoaded(je.getAsString());
                }
            }
            return false;
        });
    }
}

