/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public interface ITargetProvider {
    public static final Codec<Set<ResourceLocation>> TARGET_CODEC = Codec.either((Codec)ResourceLocation.f_135803_.listOf(), (Codec)ResourceLocation.f_135803_).xmap(e -> (List)e.map(fogParam -> fogParam, List::of), Either::left).xmap(Set::copyOf, List::copyOf);

    default public <T> Set<T> mergeSet(Set<T> first, Set<T> second) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(first);
        set.addAll(second);
        return Collections.unmodifiableSet(set);
    }

    default public <T> List<T> mergeList(List<T> first, List<T> second) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(first);
        list.addAll(second);
        return Collections.unmodifiableList(list);
    }

    @NotNull
    public Set<ResourceLocation> explicitTargets();

    default public Set<ResourceLocation> getTargetsKeys(ResourceLocation fileId) {
        Set<ResourceLocation> expl = this.explicitTargets();
        if (expl.isEmpty()) {
            return Set.of(fileId);
        }
        return expl;
    }

    default public <T> Set<T> getTargets(ResourceLocation fileId, Registry<T> registry) {
        HashSet set = new HashSet();
        Set<ResourceLocation> explTargets = this.explicitTargets();
        Optional implicitTarget = registry.m_6612_(fileId);
        if (!explTargets.isEmpty()) {
            if (implicitTarget.isPresent() && !explTargets.contains(fileId)) {
                Polytone.LOGGER.error("Found Polytone file with explicit Targets ({}) also having a valid IMPLICIT (file path) Target ({}).Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", explTargets, (Object)fileId);
            }
            for (ResourceLocation explicitId : explTargets) {
                Optional target = registry.m_6612_(explicitId);
                target.ifPresent(set::add);
            }
        } else if (implicitTarget.isPresent()) {
            set.add(implicitTarget.get());
        } else {
            Polytone.LOGGER.error("Found Polytone file {} with no valid implicit target and no explicit targets from registry {}", (Object)fileId, registry);
        }
        return set;
    }
}

