/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.LazyHolderSet;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class CompoundReloader
extends SimplePreparableReloadListener<List<Object>> {
    private final List<PartialReloader<?>> children;

    public CompoundReloader(PartialReloader<?> ... reloaders) {
        this.children = List.of(reloaders);
    }

    protected List<Object> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (PartialReloader<?> c : this.children) {
            list.add(c.prepare(resourceManager));
        }
        return list;
    }

    protected void apply(List<Object> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        LazyHolderSet.clearAll();
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (PartialReloader<?> c : this.children) {
            c.reset();
        }
        for (int i = 0; i < object.size(); ++i) {
            PartialReloader<?> c;
            c = this.children.get(i);
            try {
                this.processTyped(c, object.get(i));
                continue;
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to parse some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        if (Minecraft.m_91087_().f_91073_ != null) {
            try {
                LazyHolderSet.initializeAll(Minecraft.m_91087_().f_91073_.m_9598_());
            }
            catch (Exception e) {
                String message = "failed to parse some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        for (PartialReloader<?> c : this.children) {
            try {
                c.apply();
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to apply some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        Polytone.LOGGER.info("Reloaded Polytone Resources in {} ms", (Object)stopwatch.elapsed().toMillis());
    }

    private <T> void processTyped(PartialReloader<T> reloader, Object object) {
        reloader.process(object, (DynamicOps<JsonElement>)JsonOps.INSTANCE);
    }
}

