/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.texture;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.texture.VariantTexture;
import net.mehvahdjukaar.polytone.utils.BakedQuadsTransformer;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class VariantTextureManager
extends JsonPartialReloader {
    private final WeakHashMap<BakedQuad, Map<ResourceLocation, BakedQuad>> variantQuadsCache = new WeakHashMap();
    private final Map<Block, VariantTexture> blocksWithVariants = new Object2ObjectOpenHashMap();
    private final Set<Block> forceTintBlocks = new HashSet<Block>();

    public VariantTextureManager() {
        super("variant_textures");
    }

    @Override
    public void process(Map<ResourceLocation, JsonElement> jsonElementMap, DynamicOps<JsonElement> ops) {
        for (Map.Entry<ResourceLocation, JsonElement> j : jsonElementMap.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            VariantTexture variant = (VariantTexture)((Pair)VariantTexture.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Variant Texture with json res {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.addVariant(id, variant);
        }
    }

    private void addVariant(ResourceLocation pathId, VariantTexture mod) {
        for (Block b : mod.getTargets(pathId, BuiltInRegistries.f_256975_)) {
            VariantTexture old = this.blocksWithVariants.put(b, mod);
            if (old == null) continue;
            Polytone.LOGGER.warn("Found 2 Variant Textures jsons with same target ({}). Overriding", (Object)b);
        }
    }

    @Override
    protected void reset() {
        this.blocksWithVariants.clear();
        this.variantQuadsCache.clear();
        this.forceTintBlocks.clear();
    }

    public boolean shouldSetTintTo0(int tintIndex, BlockAndTintGetter blockView, BlockState state, BlockPos blockPos) {
        if (tintIndex == -1 && !this.forceTintBlocks.isEmpty() && state != null) {
            return this.forceTintBlocks.contains(state.m_60734_());
        }
        return false;
    }

    public BakedQuad maybeModify(BakedQuad quad, BlockAndTintGetter level, BlockState state, BlockPos pos) {
        Map<ResourceLocation, ResourceLocation> biomeToTexture;
        if (quad.f_111293_ == -1 && !this.forceTintBlocks.isEmpty() && this.forceTintBlocks.contains(state.m_60734_())) {
            quad.f_111293_ = 0;
        }
        if (this.blocksWithVariants.isEmpty()) {
            return null;
        }
        Block block = state.m_60734_();
        VariantTexture variant = this.blocksWithVariants.get(block);
        if (variant != null && (biomeToTexture = variant.getBiomeMap(quad.m_173410_())) != null && level instanceof RenderChunkRegion) {
            RenderChunkRegion region = (RenderChunkRegion)level;
            Holder biome = region.f_112908_.m_204166_(pos);
            ResourceLocation biomeLoc = ((ResourceKey)biome.m_203543_().get()).m_135782_();
            ResourceLocation newTexture = biomeToTexture.get(biomeLoc);
            if (newTexture != null) {
                return this.getOrCreateQuad(quad, biomeLoc, newTexture);
            }
        }
        return null;
    }

    @NotNull
    private BakedQuad getOrCreateQuad(BakedQuad quad, ResourceLocation biome, ResourceLocation newTexture) {
        return this.variantQuadsCache.computeIfAbsent(quad, q -> new WeakHashMap()).computeIfAbsent(biome, b -> {
            TextureAtlasSprite s = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(newTexture);
            BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingSprite(s);
            return transformer.transform(quad);
        });
    }

    public void addTintOverrideHack(Block block) {
        if (block != Blocks.f_50440_) {
            this.forceTintBlocks.add(block);
        }
    }
}

