/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.mehvahdjukaar.polytone.texture.DayTimeTexture;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteTicker;
import org.jetbrains.annotations.Nullable;

public class DayTimeTextureTicker
implements SpriteTicker {
    private final SpriteContents.AnimatedTexture animationInfo;
    @Nullable
    private final InterpolationData interpolationData;
    private final float animationScaleFactor;
    private final TreeMap<Float, Integer> frameMap = new TreeMap();
    private final int timeCycleDuration;
    private final DayTimeTexture.Mode mode;
    private int lastFrameIndex = 0;

    public DayTimeTextureTicker(SpriteContents.AnimatedTexture animationInfo, SpriteContents spriteContents, boolean interpolateFrames, int dayDuration, DayTimeTexture.Mode mode) {
        this.animationInfo = animationInfo;
        this.timeCycleDuration = dayDuration;
        this.mode = mode;
        this.interpolationData = interpolateFrames ? new InterpolationData(spriteContents) : null;
        int totalDuration = 0;
        for (SpriteContents.FrameInfo frameInfo : animationInfo.f_243714_) {
            totalDuration += frameInfo.f_244553_;
        }
        this.animationScaleFactor = 1.0f / (float)totalDuration;
        float accumulatedTime = 0.0f;
        for (int i = 0; i < animationInfo.f_243714_.size(); ++i) {
            SpriteContents.FrameInfo frameInfo = (SpriteContents.FrameInfo)animationInfo.f_243714_.get(i);
            float scaledDuration = (float)frameInfo.f_244553_ * this.animationScaleFactor;
            this.frameMap.put(Float.valueOf(accumulatedTime), i);
            accumulatedTime += scaledDuration;
        }
    }

    public void m_247697_(int x, int y) {
        Float delta = this.getDelta();
        if (delta == null) {
            return;
        }
        Map.Entry<Float, Integer> currentFrame = this.frameMap.floorEntry(delta);
        Integer frameOrdinal = currentFrame.getValue();
        List frames = this.animationInfo.f_243714_;
        SpriteContents.FrameInfo frameInfo = (SpriteContents.FrameInfo)frames.get(frameOrdinal);
        if (frameInfo.f_243751_ != this.lastFrameIndex) {
            this.animationInfo.m_245074_(x, y, frameInfo.f_243751_);
        }
        if (this.interpolationData != null) {
            SpriteContents.FrameInfo nextFrameInfo = (SpriteContents.FrameInfo)frames.get((frameOrdinal + 1) % frames.size());
            float floorKey = currentFrame.getKey().floatValue();
            float frameDelta = (delta.floatValue() - floorKey) / this.animationScaleFactor;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.interpolationData.uploadInterpolatedFrame(x, y, frameInfo, nextFrameInfo, frameDelta, this.animationInfo));
            } else {
                this.interpolationData.uploadInterpolatedFrame(x, y, frameInfo, nextFrameInfo, frameDelta, this.animationInfo);
            }
        }
        this.lastFrameIndex = frameInfo.f_243751_;
    }

    @Nullable
    private Float getDelta() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        if (this.mode == DayTimeTexture.Mode.WEATHER) {
            float rainAndThunder = ClientFrameTicker.getRainAndThunder() * 2.0f / 3.0f;
            return Float.valueOf(rainAndThunder + 0.0f);
        }
        if (this.mode == DayTimeTexture.Mode.GAME_TIME) {
            double gameTime = level.m_46468_() % (long)this.timeCycleDuration;
            return Float.valueOf((float)(gameTime / (double)this.timeCycleDuration));
        }
        double dayTime = ClientFrameTicker.getDayTime() % (double)this.timeCycleDuration;
        return Float.valueOf((float)(dayTime / (double)this.timeCycleDuration));
    }

    public void close() {
        if (this.interpolationData != null) {
            this.interpolationData.close();
        }
    }

    public static final class InterpolationData
    implements AutoCloseable {
        private final NativeImage[] activeFrame;
        private final SpriteContents spriteContents;

        InterpolationData(SpriteContents spriteContents) {
            this.spriteContents = spriteContents;
            this.activeFrame = new NativeImage[spriteContents.f_243731_.length];
            for (int i = 0; i < this.activeFrame.length; ++i) {
                int j = spriteContents.m_246492_() >> i;
                int k = spriteContents.m_245330_() >> i;
                this.activeFrame[i] = new NativeImage(j, k, false);
            }
        }

        void uploadInterpolatedFrame(int x, int y, SpriteContents.FrameInfo currentFrame, SpriteContents.FrameInfo nextFrame, float frameDelta, SpriteContents.AnimatedTexture animatedTexture) {
            double time = currentFrame.f_244553_;
            double delta = 1.0 - (double)frameDelta / time;
            int currentFrameIndex = currentFrame.f_243751_;
            int nextFrameIndex = nextFrame.f_243751_;
            if (currentFrameIndex != nextFrameIndex) {
                for (int k = 0; k < this.activeFrame.length; ++k) {
                    int l = this.spriteContents.m_246492_() >> k;
                    int m = this.spriteContents.m_245330_() >> k;
                    for (int n = 0; n < m; ++n) {
                        for (int o = 0; o < l; ++o) {
                            int p = this.getPixel(animatedTexture, currentFrameIndex, k, o, n);
                            int q = this.getPixel(animatedTexture, nextFrameIndex, k, o, n);
                            int r = this.mix(delta, p >> 16 & 0xFF, q >> 16 & 0xFF);
                            int s = this.mix(delta, p >> 8 & 0xFF, q >> 8 & 0xFF);
                            int t = this.mix(delta, p & 0xFF, q & 0xFF);
                            this.activeFrame[k].m_84988_(o, n, p & 0xFF000000 | r << 16 | s << 8 | t);
                        }
                    }
                }
                this.spriteContents.m_247381_(x, y, 0, 0, this.activeFrame);
            }
        }

        private int getPixel(SpriteContents.AnimatedTexture animatedTexture, int frameIndex, int mipLevel, int x, int y) {
            return this.spriteContents.f_243731_[mipLevel].m_84985_(x + (animatedTexture.m_245080_(frameIndex) * this.spriteContents.m_246492_() >> mipLevel), y + (animatedTexture.m_246436_(frameIndex) * this.spriteContents.m_245330_() >> mipLevel));
        }

        private int mix(double delta, int color1, int color2) {
            return (int)(delta * (double)color1 + (1.0 - delta) * (double)color2);
        }

        @Override
        public void close() {
            for (NativeImage nativeImage : this.activeFrame) {
                nativeImage.close();
            }
        }
    }
}

