/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.tabs.CreativeTabModifier;
import net.mehvahdjukaar.polytone.tabs.ItemToTabEvent;
import net.mehvahdjukaar.polytone.utils.CsvUtils;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;

public class CreativeTabsModifiersManager
extends PartialReloader<Resources> {
    private final List<ResourceKey<CreativeModeTab>> customTabs = new ArrayList<ResourceKey<CreativeModeTab>>();
    private final Map<ResourceKey<CreativeModeTab>, CreativeTabModifier> modifiers = new HashMap<ResourceKey<CreativeModeTab>, CreativeTabModifier>();
    private final Set<ResourceKey<CreativeModeTab>> needsRefresh = new HashSet<ResourceKey<CreativeModeTab>>();
    private final Map<ResourceKey<CreativeModeTab>, CreativeTabModifier> vanillaTabs = new HashMap<ResourceKey<CreativeModeTab>, CreativeTabModifier>();

    public CreativeTabsModifiersManager() {
        super("creative_tab_modifiers");
    }

    @Override
    public Resources prepare(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        Map<ResourceLocation, List<String>> types = CsvUtils.parseCsv(resourceManager, "creative_tabs");
        return new Resources(jsons, types);
    }

    @Override
    protected void reset() {
        for (ResourceKey<CreativeModeTab> resourceKey : this.customTabs) {
            PlatStuff.unregisterDynamic(BuiltInRegistries.f_279662_, resourceKey.m_135782_());
        }
        this.customTabs.clear();
        for (Map.Entry entry : this.vanillaTabs.entrySet()) {
            ((CreativeTabModifier)entry.getValue()).applyAttributes((ResourceKey<CreativeModeTab>)((ResourceKey)entry.getKey()));
        }
        this.vanillaTabs.clear();
        this.needsRefresh.addAll(this.modifiers.keySet());
        this.modifiers.clear();
        this.customTabs.clear();
    }

    @Override
    protected void process(Resources resources, DynamicOps<JsonElement> ops) {
        ResourceLocation id;
        for (Map.Entry<ResourceLocation, List<String>> e : resources.extraTabs.entrySet()) {
            for (String s : e.getValue()) {
                id = e.getKey().m_247449_(s);
                ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)id);
                if (!this.customTabs.contains(key) && !BuiltInRegistries.f_279662_.m_142003_(key)) {
                    CreativeModeTab tab = PlatStuff.createCreativeTab(id);
                    PlatStuff.registerDynamic(BuiltInRegistries.f_279662_, id, tab);
                    this.customTabs.add((ResourceKey<CreativeModeTab>)key);
                    continue;
                }
                Polytone.LOGGER.error("Creative Tab with id {} already exists! Ignoring.", (Object)id);
            }
        }
        if (!this.customTabs.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Creative Tabs from Resource Packs: {}", (Object)this.customTabs.size(), (Object)(String.valueOf(this.customTabs) + ". Remember to add items to them!"));
        }
        Map<ResourceLocation, JsonElement> jsons = resources.tabsModifiers;
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            id = j.getKey();
            CreativeTabModifier modifier = (CreativeTabModifier)((Pair)CreativeTabModifier.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.error("Could not decode Creative Mode Tab Modifier with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.addModifier(id, modifier);
        }
        if (!this.modifiers.isEmpty()) {
            this.needsRefresh.addAll(this.modifiers.keySet());
        }
    }

    @Override
    protected void apply() {
        if (Minecraft.m_91087_().f_91073_ != null && !this.needsRefresh.isEmpty()) {
            CreativeModeTabs.f_268496_ = null;
            this.needsRefresh.clear();
        }
    }

    private void addModifier(ResourceLocation fileId, CreativeTabModifier mod) {
        for (ResourceLocation id : mod.getTargetsKeys(fileId)) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)id);
            this.modifiers.merge((ResourceKey<CreativeModeTab>)key, mod, CreativeTabModifier::merge);
            PlatStuff.addTabEventForTab((ResourceKey<CreativeModeTab>)key);
        }
    }

    public void modifyTab(ItemToTabEvent event) {
        RegistryAccess access;
        ResourceKey<CreativeModeTab> tab = event.getTab();
        CreativeTabModifier mod = this.modifiers.get(tab);
        if (mod != null && (access = PlatStuff.hackyGetRegistryAccess()) != null) {
            CreativeTabModifier v = mod.applyItemsAndAttributes(event, access);
            if (!this.customTabs.contains(tab)) {
                this.vanillaTabs.put(tab, v);
            }
        }
    }

    public record Resources(Map<ResourceLocation, JsonElement> tabsModifiers, Map<ResourceLocation, List<String>> extraTabs) {
    }
}

