/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.tabs.ExtraItemCodecs;
import net.mehvahdjukaar.polytone.tabs.ItemAddition;
import net.mehvahdjukaar.polytone.tabs.ItemPredicate;
import net.mehvahdjukaar.polytone.tabs.ItemToTabEvent;
import net.mehvahdjukaar.polytone.utils.ITargetProvider;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record CreativeTabModifier(Optional<ItemStack> icon, Optional<Boolean> search, Optional<Integer> searchWidth, Optional<Boolean> canScroll, Optional<Boolean> showTitle, Optional<Component> name, Optional<ResourceLocation> backGroundLocation, Optional<ResourceLocation> tabsImage, Optional<List<ResourceLocation>> beforeTabs, Optional<List<ResourceLocation>> afterTabs, List<ItemPredicate> removals, List<ItemAddition> additions, Set<ResourceLocation> explicitTargets) implements ITargetProvider
{
    public static final Codec<Component> COMPONENT_CODEC = Codec.either((Codec)ExtraCodecs.f_252442_, (Codec)ExtraCodecs.f_276686_).xmap(e -> (Component)e.map(Function.identity(), Function.identity()), Either::left);
    public static final Codec<CreativeTabModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(ExtraItemCodecs.ITEM_OR_STACK, "icon").forGetter(CreativeTabModifier::icon), (App)StrOpt.of(Codec.BOOL, "search_bar").forGetter(CreativeTabModifier::search), (App)StrOpt.of(Codec.INT, "search_bar_width").forGetter(CreativeTabModifier::searchWidth), (App)StrOpt.of(Codec.BOOL, "can_scroll").forGetter(CreativeTabModifier::canScroll), (App)StrOpt.of(Codec.BOOL, "show_title").forGetter(CreativeTabModifier::showTitle), (App)StrOpt.of(COMPONENT_CODEC, "name").forGetter(CreativeTabModifier::name), (App)StrOpt.of(ResourceLocation.f_135803_, "background").forGetter(CreativeTabModifier::backGroundLocation), (App)StrOpt.of(ResourceLocation.f_135803_, "tabs_image").forGetter(CreativeTabModifier::tabsImage), (App)StrOpt.of(ResourceLocation.f_135803_.listOf(), "before_tabs").forGetter(CreativeTabModifier::beforeTabs), (App)StrOpt.of(ResourceLocation.f_135803_.listOf(), "after_tabs").forGetter(CreativeTabModifier::afterTabs), (App)StrOpt.of(ItemPredicate.CODEC.listOf(), "removals", List.of()).forGetter(CreativeTabModifier::removals), (App)StrOpt.of(ItemAddition.CODEC.listOf(), "additions", List.of()).forGetter(CreativeTabModifier::additions), (App)StrOpt.of(TARGET_CODEC, "targets", Set.of()).forGetter(CreativeTabModifier::explicitTargets)).apply((Applicative)i, CreativeTabModifier::new));

    public CreativeTabModifier merge(CreativeTabModifier other) {
        return new CreativeTabModifier(this.icon.isPresent() ? this.icon : other.icon, this.search.isPresent() ? this.search : other.search, this.searchWidth.isPresent() ? this.searchWidth : other.searchWidth, this.canScroll.isPresent() ? this.canScroll : other.canScroll, this.showTitle.isPresent() ? this.showTitle : other.showTitle, this.name.isPresent() ? this.name : other.name, this.backGroundLocation.isPresent() ? this.backGroundLocation : other.backGroundLocation, this.tabsImage.isPresent() ? this.tabsImage : other.tabsImage, this.beforeTabs.isPresent() ? this.beforeTabs : other.beforeTabs, this.afterTabs.isPresent() ? this.afterTabs : other.afterTabs, this.mergeList(this.removals, other.removals), this.mergeList(this.additions, other.additions), this.mergeSet(this.explicitTargets, other.explicitTargets));
    }

    public CreativeTabModifier applyItemsAndAttributes(ItemToTabEvent event, RegistryAccess access) {
        for (ItemPredicate itemPredicate : this.removals) {
            event.removeItems(itemPredicate);
        }
        for (ItemAddition itemAddition : this.additions) {
            List<ItemStack> stacks = itemAddition.items();
            if (stacks == null) continue;
            if (itemAddition.inverse()) {
                ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
                List<Item> not = stacks.stream().map(ItemStack::m_41720_).toList();
                for (Item i : BuiltInRegistries.f_257033_) {
                    if (not.contains(i)) continue;
                    newList.add(i.m_7968_());
                }
                stacks = newList;
            }
            if (itemAddition.before()) {
                event.addBefore((Predicate<ItemStack>)itemAddition.predicate(), (ItemStack[])stacks.toArray(ItemStack[]::new));
                continue;
            }
            event.addAfter((Predicate<ItemStack>)itemAddition.predicate(), (ItemStack[])stacks.toArray(ItemStack[]::new));
        }
        return this.applyAttributes(event.getTab());
    }

    public CreativeTabModifier applyAttributes(ResourceKey<CreativeModeTab> key) {
        CreativeModeTab tab = (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(key);
        if (tab == null) {
            Polytone.LOGGER.error("Could not find creative mode tab with ID {}. What?", key);
        }
        return PlatStuff.modifyTab(this, tab);
    }
}

