/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.sound;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.sound.PolytoneSoundType;
import net.mehvahdjukaar.polytone.utils.CsvUtils;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.Nullable;

public class SoundTypesManager
extends PartialReloader<Resources> {
    private final List<ResourceLocation> customSoundEvents = new ArrayList<ResourceLocation>();
    private final MapRegistry<SoundType> customSoundTypes = new MapRegistry("Custom Sound Types");

    public SoundTypesManager() {
        super("custom_sound_types", "sound_types");
    }

    @Nullable
    public SoundType getCustomSoundType(ResourceLocation resourceLocation) {
        return this.customSoundTypes.getValue(resourceLocation);
    }

    @Override
    protected Resources prepare(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        Map<ResourceLocation, List<String>> types = CsvUtils.parseCsv(resourceManager, "sound_events");
        return new Resources(jsons, types);
    }

    @Override
    public void process(Resources resources, DynamicOps<JsonElement> ops) {
        Map<ResourceLocation, JsonElement> soundJsons = resources.soundTypes;
        Map<ResourceLocation, List<String>> soundEvents = resources.soundEvents;
        for (Map.Entry<ResourceLocation, List<String>> entry : soundEvents.entrySet()) {
            for (String s : entry.getValue()) {
                ResourceLocation id = entry.getKey().m_247449_(s);
                if (!this.customSoundEvents.contains(id) && !BuiltInRegistries.f_256894_.m_7804_(id)) {
                    SoundEvent newSound = PlatStuff.registerDynamic(BuiltInRegistries.f_256894_, id, SoundEvent.m_262824_((ResourceLocation)id));
                    this.customSoundEvents.add(id);
                    continue;
                }
                Polytone.LOGGER.error("Sound Event with id {} already exists! Ignoring.", (Object)id);
            }
        }
        if (!this.customSoundEvents.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Sound Events from Resource Packs: {}", (Object)this.customSoundEvents.size(), (Object)(String.valueOf(this.customSoundEvents) + ". Remember to add them to sounds.json!"));
            Minecraft.m_91087_().m_91106_().m_194526_();
        }
        for (Map.Entry<ResourceLocation, List<String>> entry : soundJsons.entrySet()) {
            JsonElement json = (JsonElement)entry.getValue();
            ResourceLocation id = entry.getKey();
            SoundType soundType = (SoundType)((Pair)PolytoneSoundType.DIRECT_CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Sound Type with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.customSoundTypes.register(id, soundType);
        }
    }

    @Override
    protected void reset() {
        PlatStuff.unregisterAllDynamic(BuiltInRegistries.f_256894_, this.customSoundEvents);
        this.customSoundTypes.clear();
        this.customSoundEvents.clear();
    }

    public record Resources(Map<ResourceLocation, JsonElement> soundTypes, Map<ResourceLocation, List<String>> soundEvents) {
    }
}

