/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.polytone.slotify.GuiModifier;
import net.mehvahdjukaar.polytone.slotify.SimpleSprite;
import net.mehvahdjukaar.polytone.slotify.SpecialOffset;
import net.mehvahdjukaar.polytone.slotify.WidgetModifier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import org.jetbrains.annotations.Nullable;

public record ScreenModifier(int titleX, int titleY, int labelX, int labelY, @Nullable Integer titleColor, @Nullable Integer labelColor, List<SimpleSprite> sprites, List<WidgetModifier> widgetModifiers, Map<String, SpecialOffset> specialOffsets) {
    public ScreenModifier(GuiModifier original) {
        this(original.titleX(), original.titleY(), original.labelX(), original.labelY(), original.titleColor(), original.labelColor(), new ArrayList<SimpleSprite>(original.sprites()), new ArrayList<WidgetModifier>(original.widgetModifiers()), Map.copyOf(original.specialOffsets()));
    }

    public ScreenModifier merge(ScreenModifier other) {
        this.sprites.addAll(other.sprites);
        this.specialOffsets.putAll(other.specialOffsets);
        return this;
    }

    @Nullable
    public SpecialOffset getSpecial(String key) {
        return this.specialOffsets.get(key);
    }

    public void modifyWidgets(AbstractWidget button) {
        for (WidgetModifier m : this.widgetModifiers) {
            m.maybeModify(button);
        }
    }

    public void renderSprites(GuiGraphics poseStack) {
        RenderSystem.enableDepthTest();
        this.sprites.forEach(r -> r.render(poseStack));
    }
}

