/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.slotify.BlitModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class GuiOverlayManager
extends JsonPartialReloader {
    private final Map<ResourceLocation, BlitModifier> blitModifiers = new HashMap<ResourceLocation, BlitModifier>();
    private int index = 0;
    private boolean active = false;

    public GuiOverlayManager() {
        super("overlay_modifiers");
    }

    @Override
    protected void reset() {
        this.blitModifiers.clear();
    }

    @Override
    protected void process(Map<ResourceLocation, JsonElement> obj, DynamicOps<JsonElement> ops) {
        for (Map.Entry<ResourceLocation, JsonElement> j : obj.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            BlitModifier effect = (BlitModifier)((Pair)BlitModifier.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Overlay Modifier with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            ResourceLocation textureId = effect.target();
            if (this.blitModifiers.containsKey(textureId)) {
                Polytone.LOGGER.warn("Overlay Modifier with texture id {} already exists. Overwriting", (Object)textureId);
            }
            this.blitModifiers.put(textureId, effect);
        }
    }

    @Override
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager) {
        return super.prepare(resourceManager);
    }

    public boolean maybeModifyBlit(GuiGraphics gui, TextureAtlasSprite sprite, int x, int y, int offset, int width, int height) {
        if (!this.active || this.blitModifiers.isEmpty()) {
            return false;
        }
        BlitModifier mod = this.blitModifiers.get(sprite.m_245424_().m_246162_());
        if (mod != null) {
            int ind = mod.index();
            if (ind == -1 || ind == this.index) {
                mod.blitModified(gui, sprite, x, x + width, y, y + height, offset);
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public void onStartRenderingOverlay() {
        this.index = 0;
        this.active = true;
    }

    public void onEndRenderingOverlay() {
        this.active = false;
    }
}

