/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.particle.ParticleInitializer;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SemiCustomParticleType
implements CustomParticleFactory {
    private final ParticleType<?> copyType;
    private ParticleProvider<?> copyProvider = null;
    private boolean hasBeenInit = false;
    private ParticleEngine.MutableSpriteSet spriteSet = null;
    @Nullable
    private final ParticleInitializer initializer;
    private final boolean hasPhysics;
    @Nullable
    private final IColorGetter colormap;
    public static final Codec<SemiCustomParticleType> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.f_257034_.m_194605_().fieldOf("copy_from").forGetter(c -> c.copyType), (App)ParticleInitializer.CODEC.optionalFieldOf("initializer").forGetter(c -> Optional.ofNullable(c.initializer)), (App)Codec.BOOL.optionalFieldOf("has_physics", (Object)true).forGetter(c -> c.hasPhysics), (App)Colormap.CODEC.optionalFieldOf("colormap").forGetter(c -> Optional.ofNullable(c.colormap))).apply((Applicative)i, SemiCustomParticleType::new));

    public SemiCustomParticleType(ParticleType<?> type, Optional<ParticleInitializer> initializer, boolean hasPhysics, Optional<IColorGetter> colorGetter) {
        this.copyType = type;
        this.hasPhysics = hasPhysics;
        this.colormap = colorGetter.orElse(null);
        this.initializer = initializer.orElse(null);
    }

    @Override
    public void setSpriteSet(ParticleEngine.MutableSpriteSet mutableSpriteSet) {
        this.spriteSet = mutableSpriteSet;
    }

    @Override
    public Particle createParticle(SimpleParticleType t, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable BlockState state) {
        if (!this.hasBeenInit) {
            this.init();
        }
        if (this.copyProvider != null) {
            Particle particle = this.copyProvider.m_6966_((ParticleOptions)this.copyType, level, x, y, z, xSpeed, ySpeed, zSpeed);
            BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            if (this.initializer != null && particle instanceof SingleQuadParticle) {
                SingleQuadParticle sp = (SingleQuadParticle)particle;
                this.initializer.initialize(sp, level, state, pos);
            }
            if (particle != null) {
                particle.f_107219_ = this.hasPhysics;
                if (this.colormap != null) {
                    float[] unpack = ColorUtils.unpack(this.colormap.m_92566_(state, (BlockAndTintGetter)level, pos, 0));
                    particle.m_107253_(unpack[0], unpack[1], unpack[2]);
                }
                if (this.hasPhysics) {
                    for (VoxelShape voxelShape : level.m_186434_(null, particle.m_107277_())) {
                        if (voxelShape.m_83281_()) continue;
                        return null;
                    }
                }
            }
            return particle;
        }
        return null;
    }

    private void init() {
        this.hasBeenInit = true;
        this.copyProvider = PlatStuff.getParticleProvider(this.copyType);
        if (this.copyProvider != null) {
            try {
                this.copyProvider = SemiCustomParticleType.cloneProvider(this.copyProvider, this.spriteSet);
            }
            catch (Exception e) {
                Polytone.LOGGER.error("Failed to clone particle provider. Not supported. Try using a different particle type", (Throwable)e);
            }
        } else {
            Polytone.LOGGER.error("Failed to find particle provider for particle type {}", this.copyType);
        }
    }

    private static <T> T cloneProvider(T original, Object arg) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> clazz = original.getClass();
        Constructor<?> constructor = null;
        for (Constructor<?> cons : clazz.getDeclaredConstructors()) {
            if (cons.getParameterCount() == 0) {
                constructor = cons;
                break;
            }
            if (cons.getParameterCount() != 1 || !cons.getParameterTypes()[0].isInstance(arg)) continue;
            constructor = cons;
            break;
        }
        if (constructor == null) {
            throw new IllegalArgumentException("No suitable constructor found.");
        }
        constructor.setAccessible(true);
        return (T)(constructor.getParameterCount() == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(arg));
    }
}

