/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.ParticleTickable;
import net.mehvahdjukaar.polytone.utils.LazyHolderSet;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public record ParticleParticleEmitter(SimpleParticleType particleType, ParticleContextExpression chance, ParticleContextExpression count, ParticleContextExpression x, ParticleContextExpression y, ParticleContextExpression z, ParticleContextExpression dx, ParticleContextExpression dy, ParticleContextExpression dz, Optional<LazyHolderSet<Biome>> biomes) implements ParticleTickable
{
    public static final Codec<ParticleParticleEmitter> CODEC = RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.m_264370_((Codec)BuiltInRegistries.f_257034_.m_194605_(), pt -> {
        if (pt instanceof SimpleParticleType) {
            return DataResult.success((Object)pt);
        }
        return DataResult.error(() -> "Unsupported particle type: " + String.valueOf(pt));
    }).xmap(pt -> (SimpleParticleType)pt, pt -> pt).fieldOf("particle").forGetter(ParticleParticleEmitter::particleType), (App)ParticleContextExpression.CODEC.optionalFieldOf("chance", (Object)ParticleContextExpression.ONE).forGetter(ParticleParticleEmitter::chance), (App)ParticleContextExpression.CODEC.optionalFieldOf("count", (Object)ParticleContextExpression.ONE).forGetter(ParticleParticleEmitter::count), (App)ParticleContextExpression.CODEC.optionalFieldOf("x", (Object)ParticleContextExpression.PARTICLE_RAND).forGetter(ParticleParticleEmitter::x), (App)ParticleContextExpression.CODEC.optionalFieldOf("y", (Object)ParticleContextExpression.PARTICLE_RAND).forGetter(ParticleParticleEmitter::y), (App)ParticleContextExpression.CODEC.optionalFieldOf("z", (Object)ParticleContextExpression.PARTICLE_RAND).forGetter(ParticleParticleEmitter::z), (App)ParticleContextExpression.CODEC.optionalFieldOf("dx", (Object)ParticleContextExpression.ZERO).forGetter(ParticleParticleEmitter::dx), (App)ParticleContextExpression.CODEC.optionalFieldOf("dy", (Object)ParticleContextExpression.ZERO).forGetter(ParticleParticleEmitter::dy), (App)ParticleContextExpression.CODEC.optionalFieldOf("dz", (Object)ParticleContextExpression.ZERO).forGetter(ParticleParticleEmitter::dz), (App)LazyHolderSet.codec(Registries.f_256952_).optionalFieldOf("biomes").forGetter(ParticleParticleEmitter::biomes)).apply((Applicative)i, ParticleParticleEmitter::new));

    @Override
    public void tick(Particle particle, Level level) {
        double spawnChance = this.chance.getValue(particle, level);
        if ((double)level.f_46441_.m_188501_() < spawnChance) {
            if (this.biomes.isPresent()) {
                Holder biome = level.m_204166_(BlockPos.m_274561_((double)particle.f_107212_, (double)particle.f_107213_, (double)particle.f_107214_));
                if (!this.biomes.get().m_203333_((Holder<Biome>)biome)) {
                    return;
                }
            }
            int i = 0;
            while ((double)i < this.count.getValue(particle, level)) {
                level.m_7106_((ParticleOptions)this.particleType, particle.f_107212_ + this.x.getValue(particle, level), particle.f_107213_ + this.y.getValue(particle, level), particle.f_107214_ + this.z.getValue(particle, level), this.dx.getValue(particle, level), this.dy.getValue(particle, level), this.dz.getValue(particle, level));
                ++i;
            }
        }
    }
}

