/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ParticleModifiersManager
extends JsonPartialReloader {
    private final Multimap<ParticleType<?>, ParticleModifier> particleModifiers = HashMultimap.create();

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(ParticleOptions options, Level level, Particle particle) {
        Collection mod = this.particleModifiers.get((Object)options.m_6012_());
        for (ParticleModifier modifier : mod) {
            modifier.modify(particle, level, options);
        }
    }

    @Override
    public void process(Map<ResourceLocation, JsonElement> jsons, DynamicOps<JsonElement> ops) {
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            ParticleModifier modifier = (ParticleModifier)((Pair)ParticleModifier.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Particle Modifier with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            this.addModifier(id, modifier);
        }
    }

    private void addModifier(ResourceLocation pathId, ParticleModifier mod) {
        for (ParticleType p : mod.getTargets(pathId, BuiltInRegistries.f_257034_)) {
            this.particleModifiers.put((Object)p, (Object)mod);
        }
    }

    @Override
    protected void reset() {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(ResourceLocation id, String color) {
        Optional opt = BuiltInRegistries.f_257034_.m_6612_(id);
        opt.ifPresent(t -> this.particleModifiers.put(t, (Object)ParticleModifier.ofColor(color)));
    }
}

