/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.particle.SemiCustomParticleType;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class CustomParticlesManager
extends JsonPartialReloader {
    public final MapRegistry<CustomParticleFactory> customParticleFactories = new MapRegistry("Custom Particles");
    public static final Codec<CustomParticleFactory> CUSTOM_OR_SEMI_CUSTOM_CODEC = Codec.either(CustomParticleType.CODEC, SemiCustomParticleType.CODEC).xmap(e -> (CustomParticleFactory)e.map(Function.identity(), Function.identity()), p -> {
        Either either;
        if (p instanceof CustomParticleType) {
            CustomParticleType c = (CustomParticleType)p;
            either = Either.left((Object)c);
        } else {
            either = Either.right((Object)((SemiCustomParticleType)p));
        }
        return either;
    });

    public CustomParticlesManager() {
        super("custom_particles");
    }

    @Override
    protected void reset() {
        for (ResourceLocation id : this.customParticleFactories.orderedKeys()) {
            PlatStuff.unregisterParticleProvider(id);
            PlatStuff.unregisterDynamic(BuiltInRegistries.f_257034_, id);
        }
        this.customParticleFactories.clear();
    }

    public void addSpriteSets(ResourceManager resourceManager) {
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        for (ResourceLocation v : this.customParticleFactories.keySet()) {
            engine.f_107295_.remove(v);
        }
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        for (ResourceLocation v : jsons.keySet()) {
            engine.f_107295_.put(v, new ParticleEngine.MutableSpriteSet());
        }
    }

    @Override
    protected void process(Map<ResourceLocation, JsonElement> obj, DynamicOps<JsonElement> ops) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        for (Map.Entry<ResourceLocation, JsonElement> j : obj.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            CustomParticleFactory factory = (CustomParticleFactory)((Pair)CUSTOM_OR_SEMI_CUSTOM_CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Custom Particle Type with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            factory.setSpriteSet((ParticleEngine.MutableSpriteSet)Minecraft.m_91087_().f_91061_.f_107295_.get(id));
            this.customParticleFactories.register(id, factory);
            SimpleParticleType type = PlatStuff.makeParticleType();
            PlatStuff.registerDynamic(BuiltInRegistries.f_257034_, id, type);
            particleEngine.m_107381_((ParticleType)type, (ParticleProvider)factory);
        }
    }

    public Codec<CustomParticleFactory> byNameCodec() {
        return this.customParticleFactories;
    }
}

