/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.ParticleInitializer;
import net.mehvahdjukaar.polytone.particle.ParticleParticleEmitter;
import net.mehvahdjukaar.polytone.particle.ParticleTickable;
import net.mehvahdjukaar.polytone.sound.ParticleSoundEmitter;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CustomParticleType
implements CustomParticleFactory {
    private static BlockState STATE_HACK = Blocks.f_50016_.m_49966_();
    private final RenderType renderType;
    @Nullable
    private final ParticleInitializer initializer;
    @Nullable
    private final Ticker ticker;
    private final List<ParticleSoundEmitter> sounds;
    private final List<ParticleParticleEmitter> particles;
    private final int lightLevel;
    private final LiquidAffinity liquidAffinity;
    private final boolean hasPhysics;
    @Nullable
    private final IColorGetter colormap;
    private transient SpriteSet spriteSet;
    public static final Codec<CustomParticleType> CODEC = RecordCodecBuilder.create(i -> i.group((App)RenderType.CODEC.optionalFieldOf("render_type", (Object)RenderType.OPAQUE).forGetter(CustomParticleType::getRenderType), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(c -> c.lightLevel), (App)Codec.BOOL.optionalFieldOf("has_physics", (Object)true).forGetter(c -> c.hasPhysics), (App)LiquidAffinity.CODEC.optionalFieldOf("liquid_affinity", (Object)LiquidAffinity.ANY).forGetter(c -> c.liquidAffinity), (App)Colormap.CODEC.optionalFieldOf("colormap").forGetter(c -> Optional.ofNullable(c.colormap)), (App)ParticleInitializer.CODEC.optionalFieldOf("initializer").forGetter(c -> Optional.ofNullable(c.initializer)), (App)Ticker.CODEC.optionalFieldOf("ticker").forGetter(c -> Optional.ofNullable(c.ticker)), (App)ParticleSoundEmitter.CODEC.listOf().optionalFieldOf("sound_emitters", List.of()).forGetter(c -> c.sounds), (App)ParticleParticleEmitter.CODEC.listOf().optionalFieldOf("particle_emitters", List.of()).forGetter(c -> c.particles)).apply((Applicative)i, CustomParticleType::new));

    private CustomParticleType(RenderType renderType, int light, boolean hasPhysics, LiquidAffinity liquidAffinity, @Nullable IColorGetter colormap, @Nullable ParticleInitializer initializer, @Nullable Ticker ticker, List<ParticleSoundEmitter> sounds, List<ParticleParticleEmitter> particles) {
        this.renderType = renderType;
        this.initializer = initializer;
        this.ticker = ticker;
        this.sounds = sounds;
        this.particles = particles;
        this.lightLevel = light;
        this.hasPhysics = hasPhysics;
        this.liquidAffinity = liquidAffinity;
        this.colormap = colormap;
    }

    private CustomParticleType(RenderType renderType, int light, boolean hasPhysics, LiquidAffinity liquidAffinity, Optional<IColorGetter> colormap, Optional<ParticleInitializer> initializer, Optional<Ticker> ticker, List<ParticleSoundEmitter> sounds, List<ParticleParticleEmitter> particles) {
        this(renderType, light, hasPhysics, liquidAffinity, (IColorGetter)colormap.orElse(null), (ParticleInitializer)initializer.orElse(null), (Ticker)ticker.orElse(null), sounds, particles);
    }

    public static void setStateHack(BlockState state) {
        STATE_HACK = state;
    }

    private RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable BlockState state) {
        if (this.spriteSet != null) {
            Instance newParticle = new Instance(world, x, y, z, xSpeed, ySpeed, zSpeed, state, this, BuiltInRegistries.f_257034_.m_7981_((Object)type));
            if (this.hasPhysics) {
                for (VoxelShape voxelShape : world.m_186434_(null, newParticle.m_107277_())) {
                    if (voxelShape.m_83281_()) continue;
                    return null;
                }
            }
            if (this.ticker != null && this.ticker.removeIf != null && this.ticker.removeIf.getValue((Particle)newParticle, (Level)world) > 0.0) {
                return null;
            }
            return newParticle;
        }
        throw new IllegalStateException("Sprite set not set for custom particle type");
    }

    @Override
    public void setSpriteSet(ParticleEngine.MutableSpriteSet mutableSpriteSet) {
        this.spriteSet = mutableSpriteSet;
    }

    private static enum RenderType {
        TERRAIN,
        OPAQUE,
        TRANSLUCENT,
        LIT,
        INVISIBLE;

        public static final Codec<RenderType> CODEC;

        public ParticleRenderType get() {
            return switch (this.ordinal()) {
                case 0 -> ParticleRenderType.f_107429_;
                case 2 -> ParticleRenderType.f_107431_;
                case 3 -> ParticleRenderType.f_107432_;
                case 4 -> ParticleRenderType.f_107434_;
                default -> ParticleRenderType.f_107430_;
            };
        }

        static {
            CODEC = Codec.STRING.xmap(a -> RenderType.valueOf(a.toUpperCase()), e -> e.name().toLowerCase(Locale.ROOT));
        }
    }

    protected record Ticker(@Nullable ParticleContextExpression x, @Nullable ParticleContextExpression y, @Nullable ParticleContextExpression z, @Nullable ParticleContextExpression dx, @Nullable ParticleContextExpression dy, @Nullable ParticleContextExpression dz, @Nullable ParticleContextExpression size, @Nullable ParticleContextExpression red, @Nullable ParticleContextExpression green, @Nullable ParticleContextExpression blue, @Nullable ParticleContextExpression alpha, @Nullable ParticleContextExpression roll, @Nullable ParticleContextExpression custom, @Nullable ParticleContextExpression removeIf) {
        private static final Codec<Ticker> CODEC = RecordCodecBuilder.create(i -> i.group((App)ParticleContextExpression.CODEC.optionalFieldOf("x").forGetter(p -> Optional.ofNullable(p.x)), (App)ParticleContextExpression.CODEC.optionalFieldOf("y").forGetter(p -> Optional.ofNullable(p.y)), (App)ParticleContextExpression.CODEC.optionalFieldOf("z").forGetter(p -> Optional.ofNullable(p.z)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dx").forGetter(p -> Optional.ofNullable(p.dx)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dy").forGetter(p -> Optional.ofNullable(p.dy)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dz").forGetter(p -> Optional.ofNullable(p.dz)), (App)ParticleContextExpression.CODEC.optionalFieldOf("size").forGetter(p -> Optional.ofNullable(p.size)), (App)ParticleContextExpression.CODEC.optionalFieldOf("red").forGetter(p -> Optional.ofNullable(p.red)), (App)ParticleContextExpression.CODEC.optionalFieldOf("green").forGetter(p -> Optional.ofNullable(p.green)), (App)ParticleContextExpression.CODEC.optionalFieldOf("blue").forGetter(p -> Optional.ofNullable(p.blue)), (App)ParticleContextExpression.CODEC.optionalFieldOf("alpha").forGetter(p -> Optional.ofNullable(p.alpha)), (App)ParticleContextExpression.CODEC.optionalFieldOf("roll").forGetter(p -> Optional.ofNullable(p.roll)), (App)ParticleContextExpression.CODEC.optionalFieldOf("custom").forGetter(p -> Optional.ofNullable(p.custom)), (App)ParticleContextExpression.CODEC.optionalFieldOf("remove_condition").forGetter(p -> Optional.ofNullable(p.removeIf))).apply((Applicative)i, Ticker::new));

        private Ticker(Optional<ParticleContextExpression> x, Optional<ParticleContextExpression> y, Optional<ParticleContextExpression> z, Optional<ParticleContextExpression> dx, Optional<ParticleContextExpression> dy, Optional<ParticleContextExpression> dz, Optional<ParticleContextExpression> size, Optional<ParticleContextExpression> red, Optional<ParticleContextExpression> green, Optional<ParticleContextExpression> blue, Optional<ParticleContextExpression> alpha, Optional<ParticleContextExpression> roll, Optional<ParticleContextExpression> custom, Optional<ParticleContextExpression> removeIf) {
            this((ParticleContextExpression)x.orElse(null), (ParticleContextExpression)y.orElse(null), (ParticleContextExpression)z.orElse(null), (ParticleContextExpression)dx.orElse(null), (ParticleContextExpression)dy.orElse(null), (ParticleContextExpression)dz.orElse(null), (ParticleContextExpression)size.orElse(null), (ParticleContextExpression)red.orElse(null), (ParticleContextExpression)green.orElse(null), (ParticleContextExpression)blue.orElse(null), (ParticleContextExpression)alpha.orElse(null), (ParticleContextExpression)roll.orElse(null), (ParticleContextExpression)custom.orElse(null), (ParticleContextExpression)removeIf.orElse(null));
        }

        private void tick(Instance particle, ClientLevel level) {
            if (this.roll != null) {
                particle.f_107204_ = particle.f_107231_;
                particle.f_107231_ = (float)particle.ticker.roll.getValue((Particle)particle, (Level)level);
            }
            if (this.size != null) {
                particle.oQuadSize = particle.f_107663_;
                particle.f_107663_ = (float)this.size.getValue((Particle)particle, (Level)level);
            }
            if (this.red != null) {
                particle.f_107227_ = (float)this.red.getValue((Particle)particle, (Level)level);
            }
            if (this.green != null) {
                particle.f_107228_ = (float)this.green.getValue((Particle)particle, (Level)level);
            }
            if (this.blue != null) {
                particle.f_107229_ = (float)this.blue.getValue((Particle)particle, (Level)level);
            }
            if (this.alpha != null) {
                particle.f_107230_ = (float)this.alpha.getValue((Particle)particle, (Level)level);
            }
            if (this.x != null) {
                particle.f_107212_ = this.x.getValue((Particle)particle, (Level)level);
            }
            if (this.y != null) {
                particle.f_107213_ = this.y.getValue((Particle)particle, (Level)level);
            }
            if (this.z != null) {
                particle.f_107214_ = this.z.getValue((Particle)particle, (Level)level);
            }
            if (this.dx != null) {
                particle.f_107215_ = this.dx.getValue((Particle)particle, (Level)level);
            }
            if (this.dy != null) {
                particle.f_107216_ = this.dy.getValue((Particle)particle, (Level)level);
            }
            if (this.dz != null) {
                particle.f_107217_ = this.dz.getValue((Particle)particle, (Level)level);
            }
            if (this.custom != null) {
                particle.custom = this.custom.getValue((Particle)particle, (Level)level);
            }
            if (this.removeIf != null && this.removeIf.getValue((Particle)particle, (Level)level) > 0.0) {
                particle.m_107274_();
            }
        }
    }

    protected static enum LiquidAffinity implements StringRepresentable
    {
        LIQUIDS,
        NON_LIQUIDS,
        ANY;

        private static final Codec<LiquidAffinity> CODEC;

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(LiquidAffinity::values);
        }
    }

    public static class Instance
    extends TextureSheetParticle {
        protected final ParticleRenderType renderType;
        @Nullable
        protected final Ticker ticker;
        protected final SpriteSet spriteSet;
        protected final LiquidAffinity liquidAffinity;
        @Nullable
        protected final IColorGetter colormap;
        protected final List<ParticleTickable> tickables;
        protected final int light;
        protected float oQuadSize;
        protected double custom;
        private ResourceLocation name;

        protected Instance(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable BlockState state, CustomParticleType customType, ResourceLocation typeId) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed);
            this.m_107250_(0.1f, 0.1f);
            this.name = typeId;
            this.light = customType.lightLevel;
            this.colormap = customType.colormap;
            this.tickables = new ArrayList<ParticleTickable>();
            this.tickables.addAll(customType.sounds);
            this.tickables.addAll(customType.particles);
            if (state == null) {
                state = STATE_HACK;
            }
            this.f_107212_ = x;
            this.f_107213_ = y;
            this.f_107214_ = z;
            this.f_107215_ = xSpeed;
            this.f_107216_ = ySpeed;
            this.f_107217_ = zSpeed;
            this.renderType = customType.renderType.get();
            this.ticker = customType.ticker;
            this.spriteSet = customType.spriteSet;
            ParticleInitializer initializer = customType.initializer;
            BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            if (initializer != null) {
                initializer.initialize((SingleQuadParticle)this, level, state, pos);
            }
            this.oQuadSize = this.f_107663_;
            this.liquidAffinity = customType.liquidAffinity;
            this.f_107219_ = customType.hasPhysics;
            if (this.colormap != null) {
                float[] unpack = ColorUtils.unpack(this.colormap.m_92566_(state, (BlockAndTintGetter)level, pos, 0));
                this.m_107253_(unpack[0], unpack[1], unpack[2]);
            }
            this.m_108339_(this.spriteSet);
        }

        public double getCustom() {
            return this.custom;
        }

        protected int m_6355_(float partialTick) {
            int total = super.m_6355_(partialTick);
            if (this.light > 0) {
                int sky = LightTexture.m_109894_((int)total);
                int block = LightTexture.m_109883_((int)total);
                block = Math.max(block, this.light);
                return LightTexture.m_109885_((int)block, (int)sky);
            }
            return total;
        }

        public void m_5989_() {
            BlockState state;
            this.m_108339_(this.spriteSet);
            super.m_5989_();
            if (this.ticker != null) {
                this.ticker.tick(this, this.f_107208_);
            }
            if (this.colormap != null) {
                BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
                float[] unpack = ColorUtils.unpack(this.colormap.m_92566_(null, (BlockAndTintGetter)this.f_107208_, pos, 0));
                this.m_107253_(unpack[0], unpack[1], unpack[2]);
            }
            if (this.f_107224_ > 1 && this.f_107212_ == this.f_107209_ && this.f_107213_ == this.f_107210_ && this.f_107214_ == this.f_107211_ && this.f_107219_) {
                this.m_107274_();
            }
            if (this.f_107219_ && this.f_107205_) {
                this.m_107274_();
            }
            if (this.liquidAffinity != LiquidAffinity.ANY && this.liquidAffinity == LiquidAffinity.LIQUIDS ^ !(state = this.f_107208_.m_8055_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_))).m_60819_().m_76178_()) {
                this.m_107274_();
            }
            if (!this.f_107220_) {
                for (ParticleTickable tickable : this.tickables) {
                    tickable.tick((Particle)this, (Level)this.f_107208_);
                }
            }
        }

        public float m_5902_(float scaleFactor) {
            return Mth.m_14179_((float)scaleFactor, (float)this.oQuadSize, (float)this.f_107663_);
        }

        public ParticleRenderType m_7556_() {
            return this.renderType;
        }
    }
}

