/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.utils.LazyHolderSet;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record BlockParticleEmitter(ParticleType<?> particleType, BlockContextExpression chance, BlockContextExpression count, BlockContextExpression x, BlockContextExpression y, BlockContextExpression z, BlockContextExpression dx, BlockContextExpression dy, BlockContextExpression dz, Optional<LazyHolderSet<Biome>> biomes, SpawnLocation spawnLocation) implements BlockClientTickable
{
    public static final Codec<BlockParticleEmitter> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.f_257034_.m_194605_().fieldOf("particle").forGetter(BlockParticleEmitter::particleType), (App)StrOpt.of(BlockContextExpression.CODEC, "chance", BlockContextExpression.ONE).forGetter(BlockParticleEmitter::chance), (App)StrOpt.of(BlockContextExpression.CODEC, "count", BlockContextExpression.ONE).forGetter(BlockParticleEmitter::count), (App)StrOpt.of(BlockContextExpression.CODEC, "x", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::x), (App)StrOpt.of(BlockContextExpression.CODEC, "y", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::y), (App)StrOpt.of(BlockContextExpression.CODEC, "z", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::z), (App)StrOpt.of(BlockContextExpression.CODEC, "dx", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dx), (App)StrOpt.of(BlockContextExpression.CODEC, "dy", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dy), (App)StrOpt.of(BlockContextExpression.CODEC, "dz", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dz), (App)StrOpt.of(LazyHolderSet.codec(Registries.f_256952_), "biomes").forGetter(BlockParticleEmitter::biomes), (App)StrOpt.of(SpawnLocation.CODEC, "spawn_location", SpawnLocation.CENTER).forGetter(BlockParticleEmitter::spawnLocation)).apply((Applicative)i, BlockParticleEmitter::new));

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        double spawnChance = this.chance.getValue(level, pos, state);
        if ((double)level.f_46441_.m_188501_() < spawnChance) {
            if (this.biomes.isPresent()) {
                Holder biome = level.m_204166_(pos);
                if (!this.biomes.get().m_203333_((Holder<Biome>)biome)) {
                    return;
                }
            }
            int i = 0;
            while ((double)i < this.count.getValue(level, pos, state)) {
                CustomParticleType.setStateHack(state);
                ParticleOptions po = this.getParticleOptions(state);
                if (po == null) {
                    return;
                }
                level.m_7106_(po, (double)pos.m_123341_() + this.x.getValue(level, pos, state), (double)pos.m_123342_() + this.y.getValue(level, pos, state), (double)pos.m_123343_() + this.z.getValue(level, pos, state), this.dx.getValue(level, pos, state), this.dy.getValue(level, pos, state), this.dz.getValue(level, pos, state));
                ++i;
            }
        }
    }

    @Nullable
    private ParticleOptions getParticleOptions(BlockState state) {
        SimpleParticleType po;
        ParticleType<?> particleType = this.particleType;
        if (particleType instanceof SimpleParticleType) {
            SimpleParticleType st;
            po = st = (SimpleParticleType)particleType;
        } else if (this.particleType == ParticleTypes.f_123794_ || this.particleType == ParticleTypes.f_123814_ || this.particleType == ParticleTypes.f_194652_) {
            po = new BlockParticleOption(this.particleType, state);
        } else if (this.particleType == ParticleTypes.f_123752_) {
            po = new ItemParticleOption(this.particleType, state.m_60734_().m_5456_().m_7968_());
        } else {
            Polytone.LOGGER.error("Unsupported particle type: {}", this.particleType);
            return null;
        }
        return po;
    }

    public static Vec3 getParticleSpawnPosOnFace(RandomSource random, BlockPos pos, Direction direction) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pos);
        int i = direction.m_122429_();
        int j = direction.m_122430_();
        int k = direction.m_122431_();
        double d0 = vec3.f_82479_ + (i == 0 ? Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5) : (double)i * 0.6);
        double d1 = vec3.f_82480_ + (j == 0 ? Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5) : (double)j * 0.6);
        double d2 = vec3.f_82481_ + (k == 0 ? Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5) : (double)k * 0.6);
        return new Vec3(d0, d1, d2);
    }

    public static enum SpawnLocation {
        CENTER,
        LOWER_CORNER,
        BLOCK_FACES;

        public static final Codec<SpawnLocation> CODEC;

        Vec3 getLocation(BlockPos pos, BlockState state, RandomSource rand) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> Vec3.m_82528_((Vec3i)pos);
                case 0 -> Vec3.m_82512_((Vec3i)pos);
                case 2 -> {
                    Direction dir = Direction.values()[rand.m_188503_(Direction.values().length)];
                    yield BlockParticleEmitter.getParticleSpawnPosOnFace(rand, pos, dir);
                }
            };
        }

        static {
            CODEC = Codec.STRING.xmap(s -> SpawnLocation.valueOf(s.toUpperCase(Locale.ROOT)), e -> e.name().toLowerCase(Locale.ROOT));
        }
    }
}

