/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.lightmap;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.lightmap.Lightmap;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;

public class LightmapsManager
extends JsonImgPartialReloader {
    public static final ResourceLocation GUI_LIGHTMAP = Polytone.res("lightmaps/gui.png");
    private final MapRegistry<Lightmap> lightmaps = new MapRegistry("Lightmaps");
    private ResourceKey<Level> lastDimension = null;
    private Lightmap currentLightmap = null;
    private boolean reachedMainMenuHack = false;
    private boolean usingGuiLightmap = false;

    public LightmapsManager() {
        super("lightmaps");
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>();
        Map<ResourceLocation, ArrayImage> ofTextures = ArrayImage.scanDirectory(resourceManager, "optifine/lightmap");
        Map<ResourceLocation, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/lightmap");
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new JsonImgPartialReloader.Resources(jsons, textures);
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources, DynamicOps<JsonElement> ops) {
        Map<ResourceLocation, ArrayImage> images = resources.textures();
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        this.lastDimension = null;
        this.currentLightmap = null;
        HashMap<ResourceLocation, Map> grouped = new HashMap<ResourceLocation, Map>();
        for (Map.Entry<ResourceLocation, ArrayImage> entry : images.entrySet()) {
            ArrayImage value = entry.getValue();
            int height = value.height();
            ResourceLocation location = entry.getKey();
            if (height != 16 && height != 32 && height != 64) {
                throw new IllegalStateException("Lightmap must be either 16, 32 or 64 pixels tall. Provided one at " + String.valueOf(location) + " was " + height + " pixels");
            }
            String path = location.m_135815_();
            if (path.endsWith("_thunder")) {
                grouped.computeIfAbsent(location.m_247449_(path.replace("_thunder", "")), g -> new HashMap()).put("thunder", value);
                continue;
            }
            if (path.endsWith("_rain")) {
                grouped.computeIfAbsent(location.m_247449_(path.replace("_rain", "")), g -> new HashMap()).put("rain", value);
                continue;
            }
            grouped.computeIfAbsent(location, g -> new HashMap()).put("normal", value);
        }
        for (Map.Entry<Object, ArrayImage> entry : grouped.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            JsonElement j = jsons.remove(location);
            Lightmap lightmap = j != null ? (Lightmap)((Pair)Lightmap.DIRECT_CODEC.decode(ops, (Object)j).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Lightmap with json id {} - error: {}", (Object)location, errorMsg))).getFirst() : new Lightmap();
            Map map = (Map)((Object)entry.getValue());
            lightmap.acceptImages((ArrayImage)map.get("normal"), (ArrayImage)map.get("rain"), (ArrayImage)map.get("thunder"));
            this.lightmaps.register(location, lightmap);
        }
        if (!jsons.isEmpty()) {
            throw new IllegalStateException("Found some lightmaps .jsons with no associated textures at" + String.valueOf(jsons));
        }
    }

    @Override
    protected void reset() {
        this.lightmaps.clear();
    }

    public boolean maybeModifyLightTexture(LightTexture instance, NativeImage lightPixels, DynamicTexture lightTexture, Minecraft minecraft, ClientLevel level, float flicker, float partialTicks) {
        if (this.lastDimension != level.m_46472_()) {
            this.reachedMainMenuHack = true;
            this.lastDimension = level.m_46472_();
            this.currentLightmap = this.lightmaps.getValue(this.lastDimension.m_135782_());
        }
        if (this.usingGuiLightmap) {
            boolean bl = true;
        }
        if (this.currentLightmap != null) {
            this.currentLightmap.applyToLightTexture(instance, lightPixels, lightTexture, minecraft, level, flicker, partialTicks);
            return true;
        }
        return false;
    }

    public void setupForGUI(boolean gui) {
        this.usingGuiLightmap = gui;
    }

    public boolean isGui() {
        if (!this.reachedMainMenuHack && !PlatStuff.isModStateValid()) {
            return false;
        }
        return this.usingGuiLightmap;
    }

    public Codec<Lightmap> byNameCodec() {
        return this.lightmaps;
    }
}

