/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.lightmap;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.lightmap.ILightmapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Lightmap {
    protected static final double DEFAULT_SKY_LERP = 0.1;
    protected static final double DEFAULT_TORCH_LERP = 0.0;
    protected static final float DEFAULT_BASE_LIGHT = 0.04f;
    public static final Codec<Lightmap> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(ILightmapNumberProvider.CODEC, "sky_getter", ILightmapNumberProvider.DEFAULT).forGetter(l -> l.skyGetter), (App)StrOpt.of(ILightmapNumberProvider.CODEC, "torch_getter", ILightmapNumberProvider.DEFAULT).forGetter(l -> l.torchGetter), (App)StrOpt.of(Codec.BOOL, "lightning_strike_columns", true).forGetter(l -> l.hasLightningColumn), (App)StrOpt.of(Codec.doubleRange((double)0.0, (double)1.0), "sky_lerp_factor", 0.1).forGetter(l -> l.skyLerp), (App)StrOpt.of(Codec.doubleRange((double)0.0, (double)1.0), "torch_lerp_factor", 0.0).forGetter(l -> l.torchLerp), (App)StrOpt.of(Codec.FLOAT, "base_light", Float.valueOf(0.04f)).forGetter(l -> Float.valueOf(l.baseLight))).apply((Applicative)instance, Lightmap::new));
    public static final Codec<Lightmap> CODEC = new ReferenceOrDirectCodec<Lightmap>(Polytone.LIGHTMAPS.byNameCodec(), DIRECT_CODEC);
    private final ILightmapNumberProvider skyGetter;
    private final ILightmapNumberProvider torchGetter;
    private final boolean hasLightningColumn;
    private final float baseLight;
    private final double skyLerp;
    private final double torchLerp;
    private final ArrayImage[] textures = new ArrayImage[3];
    private final float[][] lastSkyLine = new float[16][3];
    private final float[][] lastTorchLine = new float[16][3];
    private long lastTime = 0L;

    public Lightmap(ILightmapNumberProvider skyGetter, ILightmapNumberProvider torchGetter, boolean lightningColumn, double skyLerp, double torchLerp, float baseLight) {
        this.skyGetter = skyGetter;
        this.torchGetter = torchGetter;
        this.hasLightningColumn = lightningColumn;
        this.skyLerp = skyLerp;
        this.torchLerp = torchLerp;
        this.baseLight = baseLight;
    }

    public Lightmap() {
        this(ILightmapNumberProvider.DEFAULT, ILightmapNumberProvider.RANDOM, true, 0.1, 0.0, 0.04f);
    }

    public void acceptImages(ArrayImage normal, ArrayImage rain, ArrayImage thunder) {
        this.textures[0] = normal;
        this.textures[1] = rain;
        this.textures[2] = thunder;
        for (ArrayImage v : this.textures) {
            if (v == null || v.width() > 2) continue;
            throw new IllegalStateException("Lightmap cannot have more with is too small! Was " + v.width());
        }
    }

    public void applyToLightTexture(LightTexture instance, NativeImage lightPixels, DynamicTexture lightTexture, Minecraft minecraft, ClientLevel level, float flicker, float partialTicks) {
        float lerpDelta;
        int[] oldTexture = lightPixels.m_266370_();
        boolean needsUpload = false;
        float skyDarken = level.m_104805_(partialTicks);
        float rainLevel = level.m_46722_(partialTicks);
        float thunderLevel = level.m_46661_(partialTicks);
        float time = level.m_46942_(partialTicks);
        long currentTime = System.currentTimeMillis();
        long deltaMillis = currentTime - this.lastTime;
        float deltaTime = (float)deltaMillis / 1000.0f;
        this.lastTime = currentTime;
        LocalPlayer player = minecraft.f_91074_;
        Options options = minecraft.f_91066_;
        boolean skyFlashTime = level.m_104819_() > 0;
        float skyLightIntensity = skyFlashTime ? 1.0f : skyDarken * 0.95f + 0.05f;
        float darknessEffect = ((Double)options.m_231926_().m_231551_()).floatValue();
        float darknessGamma = instance.m_234319_(partialTicks) * darknessEffect;
        float darknessSubtract = instance.m_234312_((LivingEntity)player, darknessGamma, partialTicks) * darknessEffect;
        float gamma = ((Double)options.m_231927_().m_231551_()).floatValue();
        gamma = PlatStuff.compatACModifyGamma(partialTicks, gamma);
        float gammaAmount = Math.max(0.0f, gamma - darknessGamma);
        float waterVision = player.m_108639_();
        float nightVisionScale = player.m_21023_(MobEffects.f_19611_) ? GameRenderer.m_109108_((LivingEntity)player, (float)partialTicks) : (waterVision > 0.0f && player.m_21023_(MobEffects.f_19592_) ? waterVision : 0.0f);
        Vector3f skyColor = new Vector3f(skyDarken, skyDarken, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
        float blockLightFlicker = flicker + 1.5f;
        DimensionType dimensionType = level.m_6042_();
        float darkenWorldAmount = minecraft.f_91063_.m_109131_(partialTicks);
        Vector3f lightGray = new Vector3f(0.75f, 0.75f, 0.75f);
        float lightGrayAmount = this.baseLight;
        ArrayImage image = this.selectImage(rainLevel, thunderLevel);
        float[][] torchLine = this.selectTorch(image, nightVisionScale, time, rainLevel, thunderLevel);
        float[][] skyLine = this.selectSky(image, nightVisionScale, time, rainLevel, thunderLevel, skyFlashTime);
        if (torchLine.length != 0 && this.lastTorchLine.length != 0 && this.torchLerp != 0.0) {
            lerpDelta = 1.0f - (float)Math.pow(this.torchLerp, deltaTime);
            Lightmap.lerpInplace(this.lastTorchLine, torchLine, lerpDelta);
        }
        if (skyLine.length != 0 && this.lastSkyLine.length != 0 && this.skyLerp != 0.0) {
            lerpDelta = 1.0f - (float)Math.pow(this.skyLerp, deltaTime);
            Lightmap.lerpInplace(this.lastSkyLine, skyLine, lerpDelta);
        }
        for (int skyY = 0; skyY < 16; ++skyY) {
            Vector3f skyBuffer = new Vector3f();
            if (skyLine.length != 0) {
                skyBuffer.add((Vector3fc)new Vector3f(skyLine[skyY]));
            } else {
                float skyBrightness = LightTexture.m_234316_((DimensionType)dimensionType, (int)skyY) * skyLightIntensity;
                skyBuffer.add((Vector3fc)skyColor).mul(skyBrightness);
                skyBuffer.mul(1.0f - lightGrayAmount);
            }
            for (int torchX = 0; torchX < 16; ++torchX) {
                float maxVal;
                Vector3f addition = new Vector3f();
                Vector3f torchBuffer = new Vector3f();
                if (torchLine.length != 0) {
                    torchBuffer.add((Vector3fc)new Vector3f(torchLine[torchX]));
                } else {
                    float torchR = LightTexture.m_234316_((DimensionType)dimensionType, (int)torchX) * blockLightFlicker;
                    float torchG = torchR * ((torchR * 0.6f + 0.4f) * 0.6f + 0.4f);
                    float torchB = torchR * (torchR * torchR * 0.6f + 0.4f);
                    torchBuffer.set(torchR, torchG, torchB);
                    addition.add((Vector3fc)new Vector3f((Vector3fc)lightGray).mul(lightGrayAmount));
                    torchBuffer.mul(1.0f - lightGrayAmount);
                }
                Vector3f combined = new Vector3f();
                combined.add((Vector3fc)torchBuffer).add((Vector3fc)skyBuffer).add((Vector3fc)addition);
                if (darkenWorldAmount > 0.0f) {
                    Vector3f discolored = new Vector3f((Vector3fc)combined).mul(0.7f, 0.6f, 0.6f);
                    combined.lerp((Vector3fc)discolored, darkenWorldAmount);
                }
                PlatStuff.adjustLightmapColors(level, partialTicks, skyDarken, skyLightIntensity, flicker, torchX, skyY, combined);
                if (nightVisionScale > 0.0f && (image == null || image.height() < 32) && (maxVal = Math.max(combined.x(), Math.max(combined.y(), combined.z()))) < 1.0f) {
                    float percentage = 1.0f / maxVal;
                    Vector3f discolored = new Vector3f((Vector3fc)combined).mul(percentage);
                    combined.lerp((Vector3fc)discolored, nightVisionScale);
                }
                if (darknessSubtract > 0.0f) {
                    combined.add(-darknessSubtract, -darknessSubtract, -darknessSubtract);
                }
                Lightmap.clampColor(combined);
                Vector3f notGamma = new Vector3f(instance.m_109892_(combined.x), instance.m_109892_(combined.y), instance.m_109892_(combined.z));
                combined.lerp((Vector3fc)notGamma, gammaAmount);
                combined.lerp((Vector3fc)lightGray, lightGrayAmount);
                Lightmap.clampColor(combined);
                combined.mul(255.0f);
                int x = (int)combined.x();
                int y = (int)combined.y();
                int z = (int)combined.z();
                int newColor = 0xFF000000 | z << 16 | y << 8 | x;
                lightPixels.m_84988_(torchX, skyY, newColor);
                if (newColor == oldTexture[skyY * 16 + torchX]) continue;
                needsUpload = true;
            }
        }
        if (needsUpload) {
            lightTexture.m_117985_();
        }
    }

    private float[][] selectSky(ArrayImage image, float nightVision, float time, float rain, float thunder, boolean isThunderFlash) {
        if (image == null) {
            return new float[0][];
        }
        float xVal = this.skyGetter.getValue(time, rain, thunder);
        float[][] skyLine = new float[16][];
        int usableSkyWidth = image.width() - 1 - (this.hasLightningColumn ? 1 : 0);
        int w = !isThunderFlash || !this.hasLightningColumn ? (isThunderFlash ? usableSkyWidth : Math.round(xVal * (float)usableSkyWidth)) : usableSkyWidth + 1;
        int h = nightVision != 0.0f && image.height() == 64 ? 32 : 0;
        for (int i = 0; i < 16; ++i) {
            skyLine[i] = ColorUtils.unpack(image.pixels()[h + i][w]);
        }
        return skyLine;
    }

    private float[][] selectTorch(ArrayImage image, float nightVision, float time, float rain, float thunder) {
        if (image == null || image.height() < 32) {
            return new float[0][];
        }
        float xVal = this.torchGetter.getValue(time, rain, thunder);
        float[][] torchLine = new float[16][];
        int h = 16 + (nightVision != 0.0f && image.height() == 64 ? 32 : 0);
        for (int i = 0; i < 16; ++i) {
            torchLine[i] = ColorUtils.unpack(image.pixels()[h + i][(int)(xVal * (float)(image.width() - 1))]);
        }
        return torchLine;
    }

    @Nullable
    private ArrayImage selectImage(float rain, float thunder) {
        ArrayImage image;
        if (thunder != 0.0f) {
            image = this.textures[2];
            if (image == null) {
                image = this.textures[0];
            }
        } else if (rain != 0.0f) {
            image = this.textures[1];
            if (image == null) {
                image = this.textures[0];
            }
        } else {
            image = this.textures[0];
        }
        return image;
    }

    private static void clampColor(Vector3f color) {
        color.set(Mth.m_14036_((float)color.x, (float)0.0f, (float)1.0f), Mth.m_14036_((float)color.y, (float)0.0f, (float)1.0f), Mth.m_14036_((float)color.z, (float)0.0f, (float)1.0f));
    }

    public static void lerpInplace(float[][] oldColors, float[][] newColors, float delta) {
        int i;
        if (oldColors.length != newColors.length || oldColors[0].length != newColors[0].length) {
            throw new IllegalArgumentException("Input arrays must have the same dimensions.");
        }
        int numRows = oldColors.length;
        int numCols = oldColors[0].length;
        for (i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                newColors[i][j] = Mth.m_14179_((float)delta, (float)oldColors[i][j], (float)newColors[i][j]);
            }
        }
        for (i = 0; i < numRows; ++i) {
            System.arraycopy(newColors[i], 0, oldColors[i], 0, numCols);
        }
    }
}

