/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.item.IPolytoneItem;
import net.mehvahdjukaar.polytone.item.ItemModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemModifiersManager
extends JsonImgPartialReloader {
    private final Map<Item, ItemModifier> modifiers = new HashMap<Item, ItemModifier>();
    private final Map<Item, ItemModifier> vanillaProperties = new HashMap<Item, ItemModifier>();

    public ItemModifiersManager() {
        super("item_modifiers", "item_properties");
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources, DynamicOps<JsonElement> ops) {
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        Map<ResourceLocation, ArrayImage> textures = resources.textures();
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        HashMap<ResourceLocation, ItemModifier> parsedModifiers = new HashMap<ResourceLocation, ItemModifier>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id = entry.getKey();
            ItemModifier modifier = (ItemModifier)((Pair)ItemModifier.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Item Modifier with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            parsedModifiers.put(id, modifier);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            ResourceLocation tintId = (ResourceLocation)entry.getKey();
            ItemModifier modifier = (ItemModifier)entry.getValue();
            if (!modifier.hasTint() && textures.containsKey(tintId)) {
                modifier = modifier.merge(ItemModifier.ofItemColor(Colormap.createDefTriangle()));
            }
            ResourceLocation barId = tintId.m_266382_("_bar");
            if (!modifier.hasBarColor() && textures.containsKey(barId)) {
                modifier = modifier.merge(ItemModifier.ofBarColor(Colormap.createDamage()));
            }
            ColormapsManager.tryAcceptingTexture(textures, tintId, modifier.getTint(), usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, barId, modifier.getBarColor(), usedTextures, true);
            this.addModifier(tintId, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            Colormap defaultColormap;
            ResourceLocation id = (ResourceLocation)entry.getKey();
            if (id.m_135815_().endsWith("_bar")) {
                defaultColormap = Colormap.createDamage();
                ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
                this.addModifier(id, ItemModifier.ofBarColor(defaultColormap));
                continue;
            }
            defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ItemModifier.ofItemColor(defaultColormap));
        }
    }

    private void addModifier(ResourceLocation id, ItemModifier mod) {
        for (Item item : mod.getTargets(id, BuiltInRegistries.f_257033_)) {
            this.modifiers.merge(item, mod, ItemModifier::merge);
        }
    }

    @Override
    protected void reset() {
        for (Map.Entry<Item, ItemModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
            ((IPolytoneItem)e.getKey()).polytone$setModifier(null);
        }
        this.modifiers.clear();
    }

    @Override
    protected void apply() {
        for (Map.Entry<Item, ItemModifier> e : this.modifiers.entrySet()) {
            Item target = e.getKey();
            ItemModifier value = e.getValue();
            this.vanillaProperties.put(target, value.apply(target));
            if (!value.shouldAttachToItem()) continue;
            ((IPolytoneItem)e.getKey()).polytone$setModifier(value);
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Item Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }
}

