/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.utils.ITargetProvider;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record ItemModifier(Optional<? extends ItemColor> tintGetter, Optional<IColorGetter> barColor, Optional<Rarity> rarity, List<Component> tooltips, List<Pattern> removedTooltips, Set<ResourceLocation> explicitTargets) implements ITargetProvider
{
    public static final Codec<ItemModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(IndexCompoundColorGetter.SINGLE_OR_MULTIPLE, "colormap").forGetter(b -> b.tintGetter), (App)StrOpt.of(Colormap.CODEC, "bar_color").forGetter(ItemModifier::barColor), (App)StrOpt.of(StringRepresentable.m_216439_(Rarity::values), "rarity").forGetter(ItemModifier::rarity), (App)StrOpt.of(ExtraCodecs.f_252442_.listOf(), "tooltips", List.of()).forGetter(ItemModifier::tooltips), (App)StrOpt.of(ExtraCodecs.f_216158_.listOf(), "removed_tooltips", List.of()).forGetter(ItemModifier::removedTooltips), (App)StrOpt.of(TARGET_CODEC, "targets", Set.of()).forGetter(ItemModifier::explicitTargets)).apply((Applicative)instance, ItemModifier::new));

    public static ItemModifier ofItemColor(Colormap colormap) {
        return new ItemModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), List.of(), List.of(), Set.of());
    }

    public static ItemModifier ofBarColor(Colormap colormap) {
        return new ItemModifier(Optional.empty(), Optional.of(colormap), Optional.empty(), List.of(), List.of(), Set.of());
    }

    public ItemModifier merge(ItemModifier other) {
        return new ItemModifier(this.tintGetter.isPresent() ? this.tintGetter : other.tintGetter, this.barColor.isPresent() ? this.barColor : other.barColor, this.rarity.isPresent() ? this.rarity : other.rarity, this.mergeList(this.tooltips, other.tooltips), this.mergeList(this.removedTooltips, other.removedTooltips), this.mergeSet(this.explicitTargets, other.explicitTargets));
    }

    public ItemModifier apply(Item item) {
        net.minecraft.world.item.Rarity oldRarity = null;
        if (this.rarity.isPresent()) {
            oldRarity = item.m_41460_(item.m_7968_());
            item.f_41369_ = this.rarity.get().toVanilla();
        }
        ItemColor oldColor = null;
        if (this.tintGetter.isPresent()) {
            ItemColors itemColors = Minecraft.m_91087_().f_91041_;
            oldColor = PlatStuff.getItemColor(itemColors, item);
            itemColors.m_92689_(this.tintGetter.get(), new ItemLike[]{item});
        }
        return new ItemModifier(Optional.ofNullable(oldColor), Optional.empty(), Optional.ofNullable(Rarity.fromVanilla(oldRarity)), List.of(), List.of(), Set.of());
    }

    @Nullable
    public Integer getBarColor(ItemStack itemStack) {
        return this.barColor.map(c -> c.m_92671_(itemStack, 0)).orElse(null);
    }

    public boolean hasTint() {
        return this.tintGetter.isPresent();
    }

    public ItemColor getTint() {
        return this.tintGetter.orElse(null);
    }

    public ItemColor getBarColor() {
        return this.barColor.orElse(null);
    }

    public boolean hasBarColor() {
        return this.barColor.isPresent();
    }

    public void modifyTooltips(List<Component> tooltips) {
        tooltips.removeIf(t -> this.removedTooltips.stream().anyMatch(p -> p.matcher(t.getString()).matches()));
        tooltips.addAll(this.tooltips);
    }

    public boolean shouldAttachToItem() {
        return !this.tooltips.isEmpty() || !this.removedTooltips.isEmpty() || this.barColor.isPresent();
    }

    public static enum Rarity implements StringRepresentable
    {
        COMMON,
        UNCOMMON,
        RARE,
        EPIC;


        public static Rarity fromVanilla(net.minecraft.world.item.Rarity oldRarity) {
            if (oldRarity == null) {
                return null;
            }
            return switch (oldRarity) {
                default -> throw new IncompatibleClassChangeError();
                case net.minecraft.world.item.Rarity.COMMON -> COMMON;
                case net.minecraft.world.item.Rarity.UNCOMMON -> UNCOMMON;
                case net.minecraft.world.item.Rarity.RARE -> RARE;
                case net.minecraft.world.item.Rarity.EPIC -> EPIC;
            };
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public net.minecraft.world.item.Rarity toVanilla() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> net.minecraft.world.item.Rarity.COMMON;
                case 1 -> net.minecraft.world.item.Rarity.UNCOMMON;
                case 2 -> net.minecraft.world.item.Rarity.RARE;
                case 3 -> net.minecraft.world.item.Rarity.EPIC;
            };
        }
    }
}

