/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.forge;

import com.mojang.blaze3d.systems.RenderSystem;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.forge.AlexsCavesCompat;
import net.mehvahdjukaar.polytone.mixins.forge.CreativeTabAccessor;
import net.mehvahdjukaar.polytone.mixins.forge.ModifiableBiomeAccessor;
import net.mehvahdjukaar.polytone.mixins.forge.ModifiableBiomeInfoBiomeInfoAccessor;
import net.mehvahdjukaar.polytone.mixins.forge.ParticleEngineAccessor;
import net.mehvahdjukaar.polytone.tabs.CreativeTabModifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Contract;
import org.joml.Vector3f;

public class PlatStuffImpl {
    private static final Field blockColorsField;
    private static final Field itemColorsField;
    private static final boolean AC;

    public static boolean isModStateValid() {
        return ModLoader.isLoadingStateValid();
    }

    public static void addClientReloadListener(Supplier<PreparableReloadListener> listener, ResourceLocation location) {
        Consumer<RegisterClientReloadListenersEvent> eventConsumer = event -> event.registerReloadListener((PreparableReloadListener)listener.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(eventConsumer);
    }

    public static void unregisterParticleProvider(ResourceLocation id) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        ((ParticleEngineAccessor)particleEngine).getProviders().remove(id);
    }

    public static SimpleParticleType makeParticleType() {
        return new SimpleParticleType(false);
    }

    public static BlockColor getBlockColor(BlockColors colors, Block block) {
        try {
            return (BlockColor)((Map)blockColorsField.get(colors)).get(ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ItemColor getItemColor(ItemColors colors, Item block) {
        try {
            return (ItemColor)((Map)itemColorsField.get(colors)).get(ForgeRegistries.ITEMS.getDelegateOrThrow((Object)block));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SoundEvent registerSoundEvent(ResourceLocation id) {
        SoundEvent variableRangeEvent = SoundEvent.m_262824_((ResourceLocation)id);
        ForgeRegistry reg = (ForgeRegistry)ForgeRegistries.SOUND_EVENTS;
        boolean wasLocked = reg.isLocked();
        if (wasLocked) {
            reg.unfreeze();
        }
        ForgeRegistries.SOUND_EVENTS.register(id, (Object)variableRangeEvent);
        if (wasLocked) {
            reg.freeze();
        }
        return variableRangeEvent;
    }

    public static String maybeRemapName(String s) {
        return ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.CLASS, (String)s);
    }

    @Contract
    public static boolean isModLoaded(String namespace) {
        return ModList.get().isLoaded(namespace);
    }

    public static DimensionSpecialEffects getDimensionEffects(ResourceLocation id) {
        return DimensionSpecialEffectsManager.getForType((ResourceLocation)id);
    }

    public static void applyBiomeSurgery(Biome biome, BiomeSpecialEffects newEffects) {
        ModifiableBiomeInfo modifiable = biome.modifiableBiomeInfo();
        ModifiableBiomeInfo.BiomeInfo modifiedInfo = modifiable.getModifiedBiomeInfo();
        if (modifiedInfo == null) {
            modifiedInfo = ModifiableBiomeInfo.BiomeInfo.Builder.copyOf((ModifiableBiomeInfo.BiomeInfo)modifiable.getOriginalBiomeInfo()).build();
            ((ModifiableBiomeAccessor)modifiable).setModifiedBiomeInfo(modifiedInfo);
        }
        ((ModifiableBiomeInfoBiomeInfoAccessor)modifiedInfo).setEffects(newEffects);
    }

    public static void addTabEventForTab(ResourceKey<CreativeModeTab> key) {
    }

    public static void sortTabs() {
        CreativeModeTabRegistry.sortTabs();
    }

    public static RegistryAccess hackyGetRegistryAccess() {
        ClientLevel level;
        if (FMLEnvironment.dist == Dist.CLIENT && RenderSystem.isOnRenderThread() && (level = Minecraft.m_91087_().f_91073_) != null) {
            return level.m_9598_();
        }
        return null;
    }

    public static CreativeModeTab createCreativeTab(ResourceLocation id) {
        return CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)id.toString())).m_257652_();
    }

    public static CreativeTabModifier modifyTab(CreativeTabModifier mod, CreativeModeTab tab) {
        CreativeTabAccessor acc = (CreativeTabAccessor)tab;
        Component oldName = null;
        if (mod.name().isPresent()) {
            oldName = tab.m_40786_();
            acc.setDisplayName(mod.name().get());
        }
        ItemStack oldIcon = null;
        if (mod.icon().isPresent()) {
            oldIcon = tab.m_40787_();
            acc.setIcon(mod.icon().get());
        }
        Boolean oldSearch = null;
        Integer oldSearchWidth = null;
        if (mod.search().isPresent()) {
            oldSearch = tab.hasSearchBar();
            acc.setHasSearchBar(mod.search().get());
        }
        if (mod.searchWidth().isPresent()) {
            oldSearchWidth = tab.getSearchBarWidth();
            acc.setSearchBarWidth(mod.searchWidth().get());
        }
        Boolean oldCanScroll = null;
        if (mod.canScroll().isPresent()) {
            oldCanScroll = tab.m_40791_();
            acc.setCanScroll(mod.canScroll().get());
        }
        Boolean oldShowTitle = null;
        if (mod.showTitle().isPresent()) {
            oldShowTitle = tab.m_40789_();
            acc.setShowTitle(mod.showTitle().get());
        }
        ResourceLocation oldTabsImage = null;
        if (mod.tabsImage().isPresent()) {
            oldTabsImage = tab.getTabsImage();
            acc.setTabsImage(mod.tabsImage().get());
        }
        ResourceLocation oldBackgroundLocation = null;
        if (mod.backGroundLocation().isPresent()) {
            oldBackgroundLocation = tab.getBackgroundLocation();
            acc.setBackgroundLocation(mod.backGroundLocation().get());
        }
        List oldBeforeTabs = null;
        if (mod.beforeTabs().isPresent()) {
            oldBeforeTabs = tab.tabsBefore;
            acc.setBeforeTabs(mod.beforeTabs().get());
        }
        List oldAfterTabs = null;
        if (mod.afterTabs().isPresent()) {
            oldAfterTabs = tab.tabsAfter;
            acc.setAfterTabs(mod.afterTabs().get());
        }
        return new CreativeTabModifier(Optional.ofNullable(oldIcon), Optional.ofNullable(oldSearch), Optional.ofNullable(oldSearchWidth), Optional.ofNullable(oldCanScroll), Optional.ofNullable(oldShowTitle), Optional.ofNullable(oldName), Optional.ofNullable(oldBackgroundLocation), Optional.ofNullable(oldTabsImage), Optional.ofNullable(oldBeforeTabs), Optional.ofNullable(oldAfterTabs), List.of(), List.of(), Set.of());
    }

    public static RenderType getRenderType(Block block) {
        return null;
    }

    public static void setRenderType(Block block, RenderType renderType) {
    }

    public static void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float flicker, int torchX, int skyY, Vector3f combined) {
        if (AC) {
            AlexsCavesCompat.applyACLightingColors(level, combined);
        }
        level.m_104583_().adjustLightmapColors(level, partialTicks, skyDarken, skyLight, flicker, torchX, skyY, combined);
    }

    public static float compatACModifyGamma(float partialTicks, float gamma) {
        return AC ? AlexsCavesCompat.modifyGamma(partialTicks, gamma) : gamma;
    }

    public static ParticleProvider<?> getParticleProvider(ParticleType<?> type) {
        return ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).getProviders().get(BuiltInRegistries.f_257034_.m_7981_(type));
    }

    public static RegistryAccess getServerRegistryAccess() {
        return ServerLifecycleHooks.getCurrentServer().m_206579_();
    }

    static {
        try {
            blockColorsField = BlockColors.class.getDeclaredField("f_92571_");
            blockColorsField.setAccessible(true);
            itemColorsField = ItemColors.class.getDeclaredField("f_92674_");
            itemColorsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        AC = ModList.get().isLoaded("alexscaves");
    }
}

