/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.fluid;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.fluid.forge.FluidPropertiesManagerImpl;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.material.Fluid;

public class FluidPropertiesManager
extends JsonImgPartialReloader {
    private final Map<Fluid, FluidPropertyModifier> modifiers = new HashMap<Fluid, FluidPropertyModifier>();
    private Map<ResourceLocation, FluidPropertyModifier> extraModifiers;
    private Map<ResourceLocation, ArrayImage> extraImages;

    public FluidPropertiesManager() {
        super("fluid_modifiers", "fluid_properties");
    }

    public void addConvertedBlockProperties(Map<ResourceLocation, FluidPropertyModifier> modifiers, Map<ResourceLocation, ArrayImage> textures) {
        this.extraImages = textures;
        this.extraModifiers = modifiers;
    }

    @Override
    protected JsonImgPartialReloader.Resources prepare(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>();
        Map<ResourceLocation, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/colormap");
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new JsonImgPartialReloader.Resources(jsons, textures);
    }

    @Override
    public void process(JsonImgPartialReloader.Resources resources, DynamicOps<JsonElement> ops) {
        ResourceLocation id;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        Map<ResourceLocation, ArrayImage> textures = resources.textures();
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        HashMap<ResourceLocation, FluidPropertyModifier> parsedModifiers = new HashMap<ResourceLocation, FluidPropertyModifier>(this.extraModifiers);
        textures.putAll(this.extraImages);
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id2 = entry.getKey();
            FluidPropertyModifier modifier = (FluidPropertyModifier)((Pair)FluidPropertyModifier.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Fluid Modifier with json id {} - error: {}", (Object)id2, errorMsg))).getFirst();
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate fluid modifier with id {}. This is likely a non .json converted legacy oneOverriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, modifier);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            FluidPropertyModifier modifier = (FluidPropertyModifier)entry.getValue();
            if (!modifier.hasColormap() && textures.containsKey(id)) {
                modifier = modifier.merge(FluidPropertyModifier.ofBlockColor(Colormap.createDefTriangle()));
            }
            BlockColor tint = modifier.getTint();
            ColormapsManager.tryAcceptingTexture(textures, id, tint, usedTextures, true);
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, new FluidPropertyModifier(Optional.of(defaultColormap), Optional.empty(), Set.of()));
        }
    }

    @Override
    protected void reset() {
        this.modifiers.clear();
        FluidPropertiesManager.clearSpecial();
    }

    private void addModifier(ResourceLocation pathId, FluidPropertyModifier mod) {
        for (Fluid fluid : mod.getTargets(pathId, BuiltInRegistries.f_257020_)) {
            this.modifiers.merge(fluid, mod, FluidPropertyModifier::merge);
            FluidPropertiesManager.tryAddSpecial(fluid, mod);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void tryAddSpecial(Fluid fluid, FluidPropertyModifier colormap) {
        void var1_1;
        FluidPropertiesManagerImpl.tryAddSpecial(fluid, (FluidPropertyModifier)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void clearSpecial() {
        FluidPropertiesManagerImpl.clearSpecial();
    }

    public FluidPropertyModifier getModifier(Fluid water) {
        return this.modifiers.get(water);
    }
}

