/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.lightmap.Lightmap;
import net.mehvahdjukaar.polytone.utils.ITargetProvider;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;

public record DimensionEffectsModifier(Optional<Either<Float, BlockContextExpression>> cloudLevel, Optional<Boolean> hasGround, Optional<DimensionSpecialEffects.SkyType> skyType, Optional<Boolean> forceBrightLightmap, Optional<Boolean> constantAmbientLight, Optional<IColorGetter> fogColor, Optional<IColorGetter> skyColor, boolean noWeatherFogDarken, boolean noWeatherSkyDarken, Optional<Lightmap> lightmap, Set<ResourceLocation> explicitTargets) implements ITargetProvider
{
    public static final Codec<DimensionSpecialEffects.SkyType> SKY_TYPE_CODEC = Codec.STRING.xmap(DimensionSpecialEffects.SkyType::valueOf, Enum::name);
    public static final Decoder<DimensionEffectsModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(Codec.either((Codec)Codec.FLOAT, BlockContextExpression.CODEC), "cloud_level").forGetter(DimensionEffectsModifier::cloudLevel), (App)StrOpt.of(Codec.BOOL, "has_ground").forGetter(DimensionEffectsModifier::hasGround), (App)StrOpt.of(SKY_TYPE_CODEC, "sky_type").forGetter(DimensionEffectsModifier::skyType), (App)StrOpt.of(Codec.BOOL, "force_bright_lightmap").forGetter(DimensionEffectsModifier::forceBrightLightmap), (App)StrOpt.of(Codec.BOOL, "constant_ambient_light").forGetter(DimensionEffectsModifier::constantAmbientLight), (App)StrOpt.of(Colormap.CODEC, "fog_colormap").forGetter(DimensionEffectsModifier::fogColor), (App)StrOpt.of(Colormap.CODEC, "sky_colormap").forGetter(DimensionEffectsModifier::skyColor), (App)StrOpt.of(Codec.BOOL, "no_weather_fog_darken", false).forGetter(DimensionEffectsModifier::noWeatherFogDarken), (App)StrOpt.of(Codec.BOOL, "no_weather_sky_darken", false).forGetter(DimensionEffectsModifier::noWeatherSkyDarken), (App)StrOpt.of(Polytone.LIGHTMAPS.byNameCodec(), "lightmap").forGetter(DimensionEffectsModifier::lightmap), (App)StrOpt.of(TARGET_CODEC, "targets", Set.of()).forGetter(DimensionEffectsModifier::explicitTargets)).apply((Applicative)instance, DimensionEffectsModifier::new));

    public static DimensionEffectsModifier ofFogColor(Colormap colormap) {
        return new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(colormap), Optional.empty(), false, false, Optional.empty(), Set.of());
    }

    public static DimensionEffectsModifier ofSkyColor(Colormap colormap) {
        return new DimensionEffectsModifier(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(colormap), false, false, Optional.empty(), Set.of());
    }

    public DimensionEffectsModifier merge(DimensionEffectsModifier other) {
        return new DimensionEffectsModifier(other.cloudLevel.isPresent() ? other.cloudLevel : this.cloudLevel, other.hasGround.isPresent() ? other.hasGround : this.hasGround, other.skyType.isPresent() ? other.skyType : this.skyType, other.forceBrightLightmap.isPresent() ? other.forceBrightLightmap : this.forceBrightLightmap, other.constantAmbientLight.isPresent() ? other.constantAmbientLight : this.constantAmbientLight, other.fogColor.isPresent() ? other.fogColor : this.fogColor, other.skyColor.isPresent() ? other.skyColor : this.skyColor, other.noWeatherFogDarken | this.noWeatherFogDarken, other.noWeatherSkyDarken | this.noWeatherSkyDarken, other.lightmap.isPresent() ? other.lightmap : this.lightmap, this.mergeSet(other.explicitTargets, this.explicitTargets));
    }

    public BlockColor getFogColormap() {
        return this.fogColor.orElse(null);
    }

    public BlockColor getSkyColormap() {
        return this.skyColor.orElse(null);
    }

    public DimensionEffectsModifier applyInplace(ResourceLocation dimensionId) {
        DimensionSpecialEffects effects = PlatStuff.getDimensionEffects(dimensionId);
        Optional<Either<Float, BlockContextExpression>> oldCloud = Optional.empty();
        if (this.cloudLevel.isPresent() && this.cloudLevel.get().left().isPresent()) {
            oldCloud = Optional.of(Either.left((Object)Float.valueOf(effects.f_108859_)));
            effects.f_108859_ = ((Float)this.cloudLevel.get().left().get()).floatValue();
        }
        Optional<Boolean> oldGround = Optional.empty();
        if (this.hasGround.isPresent()) {
            oldGround = Optional.of(effects.f_108860_);
            effects.f_108860_ = this.hasGround.get();
        }
        Optional<DimensionSpecialEffects.SkyType> oldSky = Optional.empty();
        if (this.skyType.isPresent()) {
            oldSky = Optional.of(effects.f_108861_);
            effects.f_108861_ = this.skyType.get();
        }
        Optional<Boolean> oldBright = Optional.empty();
        if (this.forceBrightLightmap.isPresent()) {
            oldBright = Optional.of(effects.f_108862_);
            effects.f_108862_ = this.forceBrightLightmap.get();
        }
        Optional<Boolean> oldAmbient = Optional.empty();
        if (this.constantAmbientLight.isPresent()) {
            oldAmbient = Optional.of(effects.f_108863_);
            effects.f_108863_ = this.constantAmbientLight.get();
        }
        return new DimensionEffectsModifier(oldCloud, oldGround, oldSky, oldBright, oldAmbient, Optional.empty(), Optional.empty(), false, false, Optional.empty(), Set.of());
    }
}

