/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.dimension;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.dimension.DimensionEffectsModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DimensionEffectsManager
extends JsonImgPartialReloader {
    private final Map<ResourceLocation, DimensionEffectsModifier> effectsToApply = new HashMap<ResourceLocation, DimensionEffectsModifier>();
    private final Map<ResourceLocation, DimensionEffectsModifier> vanillaEffects = new HashMap<ResourceLocation, DimensionEffectsModifier>();
    private final Object2ObjectMap<DimensionType, Colormap> fogColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<DimensionType, Colormap> skyColormaps = new Object2ObjectArrayMap();
    private final Object2BooleanArrayMap<DimensionType> cancelFogWeatherDarken = new Object2BooleanArrayMap();
    private final Object2BooleanArrayMap<DimensionType> cancelSkyWeatherDarken = new Object2BooleanArrayMap();
    private boolean needsDynamicApplication = true;
    private final Map<ResourceLocation, DimensionEffectsModifier> extraMods = new HashMap<ResourceLocation, DimensionEffectsModifier>();

    public DimensionEffectsManager() {
        super("dimension_modifiers", "dimension_effects");
    }

    @Override
    public void reset() {
        this.needsDynamicApplication = true;
        this.effectsToApply.clear();
        this.fogColormaps.clear();
        this.skyColormaps.clear();
        this.cancelFogWeatherDarken.clear();
        this.cancelSkyWeatherDarken.clear();
        this.extraMods.clear();
    }

    @Override
    protected void process(JsonImgPartialReloader.Resources resources, DynamicOps<JsonElement> ops) {
        ResourceLocation id;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        Map<ResourceLocation, ArrayImage> textures = resources.textures();
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        HashMap<ResourceLocation, DimensionEffectsModifier> parsedModifiers = new HashMap<ResourceLocation, DimensionEffectsModifier>(this.extraMods);
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id2 = entry.getKey();
            DimensionEffectsModifier modifier = (DimensionEffectsModifier)((Pair)DimensionEffectsModifier.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Dimension Effects with json id {} - error: {}", (Object)id2, errorMsg))).getFirst();
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate Dimension Effects file with id {}.Overriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, modifier);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            ResourceLocation fogId;
            ResourceLocation skyId;
            id = (ResourceLocation)entry.getKey();
            DimensionEffectsModifier modifier = (DimensionEffectsModifier)entry.getValue();
            BlockColor fog = modifier.getFogColormap();
            BlockColor sky = modifier.getSkyColormap();
            if (textures.containsKey(id) && fog == null && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (textures.containsKey(skyId = id.m_266382_("_sky")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofSkyColor(Colormap.createDefTriangle()));
                sky = modifier.getSkyColormap();
            }
            if (textures.containsKey(fogId = id.m_266382_("_fog")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (fog != null ^ sky != null) {
                ColormapsManager.tryAcceptingTexture(textures, id, fog, usedTextures, false);
                ColormapsManager.tryAcceptingTexture(textures, id, sky, usedTextures, false);
            }
            ColormapsManager.tryAcceptingTexture(textures, fogId, fog, usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, skyId, sky, usedTextures, true);
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, DimensionEffectsModifier.ofFogColor(defaultColormap));
        }
    }

    private void addModifier(ResourceLocation fileId, DimensionEffectsModifier mod) {
        for (ResourceLocation id : mod.getTargetsKeys(fileId)) {
            this.effectsToApply.merge(id, mod, DimensionEffectsModifier::merge);
        }
    }

    @Override
    public void apply() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            this.doApply(level.m_9598_(), false);
        }
    }

    public void doApply(RegistryAccess registryAccess, boolean firstLogin) {
        if (!firstLogin && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        for (Map.Entry<ResourceLocation, DimensionEffectsModifier> v : this.vanillaEffects.entrySet()) {
            v.getValue().applyInplace(v.getKey());
        }
        Registry dimReg = registryAccess.m_175515_(Registries.f_256787_);
        for (Map.Entry<ResourceLocation, DimensionEffectsModifier> v : this.effectsToApply.entrySet()) {
            Colormap c;
            ResourceLocation dimensionId = v.getKey();
            DimensionEffectsModifier modifier = v.getValue();
            DimensionEffectsModifier old = modifier.applyInplace(dimensionId);
            this.vanillaEffects.put(dimensionId, old);
            BlockColor blockColor = modifier.getFogColormap();
            if (blockColor instanceof Colormap) {
                c = (Colormap)blockColor;
                this.fogColormaps.put((Object)((DimensionType)dimReg.m_7745_(dimensionId)), (Object)c);
            }
            if ((blockColor = modifier.getSkyColormap()) instanceof Colormap) {
                c = (Colormap)blockColor;
                this.skyColormaps.put((Object)((DimensionType)dimReg.m_7745_(dimensionId)), (Object)c);
            }
            if (modifier.noWeatherFogDarken()) {
                this.cancelFogWeatherDarken.put((Object)((DimensionType)dimReg.m_7745_(dimensionId)), true);
            }
            if (!modifier.noWeatherSkyDarken()) continue;
            this.cancelSkyWeatherDarken.put((Object)((DimensionType)dimReg.m_7745_(dimensionId)), true);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Dimension Effects Properties", (Object)this.vanillaEffects.size());
        }
    }

    @Nullable
    public Vec3 modifyFogColor(Vec3 center, ClientLevel level, float brightness) {
        Colormap colormap = (Colormap)this.fogColormaps.get((Object)level.m_6042_());
        if (colormap == null) {
            return null;
        }
        BiomeManager biomeManager = level.m_7062_();
        return level.m_104583_().m_5927_(CubicSampler.m_130038_((Vec3)center, (qx, qy, qz) -> {
            Biome biome = (Biome)biomeManager.m_204210_(qx, qy, qz).m_203334_();
            int fogColor1 = colormap.sampleColor(null, BlockPos.m_274561_((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return Vec3.m_82501_((int)fogColor1);
        }), brightness);
    }

    public void modifyFogMagicNumber(float renderDistanceChunks, LocalFloatRef distance) {
        float c = 0.25f;
        float b = c + (1.0f - c) * renderDistanceChunks / 32.0f;
        b = 1.0f - (float)Math.pow(b, 0.25);
        float a = 1.0f * renderDistanceChunks / 32.0f;
        a = 1.0f - (float)Math.pow(a, 0.25);
        distance.set(b);
    }

    @Nullable
    public Vec3 modifySkyColor(Vec3 center, ClientLevel level) {
        Colormap colormap = (Colormap)this.skyColormaps.get((Object)level.m_6042_());
        if (colormap == null) {
            return null;
        }
        BiomeManager biomeManager = level.m_7062_();
        return CubicSampler.m_130038_((Vec3)center, (qx, qy, qz) -> {
            Biome biome = (Biome)biomeManager.m_204210_(qx, qy, qz).m_203334_();
            int skyColor1 = colormap.sampleColor(null, BlockPos.m_274561_((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return Vec3.m_82501_((int)skyColor1);
        });
    }

    public boolean shouldCancelFogWeatherDarken(Level level) {
        return this.cancelFogWeatherDarken.getOrDefault((Object)level.m_6042_(), false);
    }

    public boolean shouldCancelSkyWeatherDarken(Level level) {
        return this.cancelSkyWeatherDarken.getOrDefault((Object)level.m_6042_(), false);
    }

    public void addConvertedBlockProperties(Map<ResourceLocation, DimensionEffectsModifier> converted) {
        this.extraMods.clear();
        this.extraMods.putAll(converted);
    }
}

