/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;
import org.jetbrains.annotations.Nullable;

public final class ColormapExpressionProvider
implements IColormapNumberProvider {
    private static final String TEMPERATURE = "TEMPERATURE";
    private static final String DOWNFALL = "DOWNFALL";
    private static final String POS_X = "POS_X";
    private static final String POS_Y = "POS_Y";
    private static final String POS_Z = "POS_Z";
    private static final String BIOME_VALUE = "BIOME_VALUE";
    private static final String DAMAGE = "DAMAGE";
    private static final String TIME = "TIME";
    private static final String DAY_TIME = "DAY_TIME";
    private static final String RAIN = "RAIN";
    private static final String STATE_FUNC = "state_prop";
    private static final Function STATE_PROP = new Function("state_prop", 1){

        public double apply(double ... args) {
            BlockState blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.m_61147_());
            int index = (int)args[0];
            Property p = (Property)properties.get(Mth.m_14045_((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.m_6908_());
            return (float)values.indexOf(blockState.m_61143_(p)) / ((float)properties.size() - 1.0f);
        }
    };
    private static final Function STATE_PROP_INT = new Function("state_prop_i", 1){

        public double apply(double ... args) {
            BlockState blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.m_61147_());
            int index = (int)args[0];
            Property p = (Property)properties.get(Mth.m_14045_((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.m_6908_());
            return values.indexOf(blockState.m_61143_(p));
        }
    };
    private static final ThreadLocal<BlockState> STATE_HACK = new ThreadLocal();
    public static final Codec<ColormapExpressionProvider> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            Expression compiled = ColormapExpressionProvider.createExpression(s);
            return DataResult.success((Object)new ColormapExpressionProvider(compiled, (String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.unparsed));
    private final String unparsed;
    private final Expression expression;
    private final AtomicBoolean nonBlockingLock = new AtomicBoolean();
    private final boolean hasTemperature;
    private final boolean hasDownfall;
    private final boolean hasRain;
    private final boolean hasTime;
    private final boolean hasDayTime;

    private static Expression createExpression(String s) {
        return new ExpressionBuilder(s).functions(ExpressionUtils.defFunc(STATE_PROP, STATE_PROP_INT)).variables(new String[]{TEMPERATURE, DOWNFALL, POS_X, POS_Y, POS_Z, BIOME_VALUE, TIME, RAIN, DAY_TIME}).operator(ExpressionUtils.defOp(new Operator[0])).build();
    }

    private ColormapExpressionProvider(Expression expression, String unparsed) {
        this.expression = expression;
        this.unparsed = unparsed;
        this.hasTemperature = unparsed.contains(TEMPERATURE);
        this.hasDownfall = unparsed.contains(DOWNFALL);
        this.hasRain = unparsed.contains(RAIN);
        this.hasTime = unparsed.contains(TIME);
        this.hasDayTime = unparsed.contains(DAY_TIME);
    }

    public static ColormapExpressionProvider make(String s) {
        return new ColormapExpressionProvider(ColormapExpressionProvider.createExpression(s), s);
    }

    @Override
    public boolean usesBiome() {
        return this.unparsed.contains(TEMPERATURE) || this.unparsed.contains(DOWNFALL) || this.unparsed.contains(BIOME_VALUE);
    }

    @Override
    public boolean usesPos() {
        return this.unparsed.contains(POS_X) || this.unparsed.contains(POS_Y) || this.unparsed.contains(POS_Z);
    }

    @Override
    public boolean usesState() {
        return this.unparsed.contains(STATE_FUNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getValue(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
        float result = 0.0f;
        boolean needsToUnlock = false;
        try {
            Expression exp = new Expression(this.expression);
            if (this.hasTemperature) {
                exp.setVariable(TEMPERATURE, biome != null ? (double)ColorUtils.getClimateSettings((Biome)biome).f_47681_ : 0.0);
            }
            if (this.hasDownfall) {
                exp.setVariable(DOWNFALL, biome != null ? (double)ColorUtils.getClimateSettings((Biome)biome).f_47683_ : 0.0);
            }
            exp.setVariable(POS_X, pos != null ? (double)pos.m_123341_() : 0.0);
            exp.setVariable(POS_Y, pos != null ? (double)pos.m_123342_() : 0.0);
            exp.setVariable(POS_Z, pos != null ? (double)pos.m_123343_() : 0.0);
            if (this.hasRain) {
                exp.setVariable(RAIN, (double)ClientFrameTicker.getRainAndThunder());
            }
            if (this.hasTime) {
                exp.setVariable(TIME, ClientFrameTicker.getGameTime());
            }
            if (this.hasDayTime) {
                exp.setVariable(DAY_TIME, ClientFrameTicker.getDayTime());
            }
            if (stack != null) {
                float damage = 1.0f - (float)stack.m_41773_() / (float)stack.m_41776_();
                exp.setVariable(DAMAGE, (double)damage);
            } else {
                exp.setVariable(DAMAGE, 0.0);
            }
            STATE_HACK.set(state);
            if (pos != null) {
                ExpressionUtils.seedRandom((long)pos.hashCode() * pos.m_121878_());
            } else {
                ExpressionUtils.randomizeRandom();
            }
            result = (float)exp.evaluate();
            STATE_HACK.remove();
        }
        catch (Exception e) {
            Polytone.LOGGER.error("Failed to evaluate expression with value: {}", (Object)this.unparsed, (Object)e);
        }
        finally {
            if (needsToUnlock) {
                this.nonBlockingLock.set(false);
            }
        }
        return result;
    }
}

