/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockSetTypeProvider;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.particle.BlockParticleEmitter;
import net.mehvahdjukaar.polytone.sound.BlockSoundEmitter;
import net.mehvahdjukaar.polytone.sound.PolytoneSoundType;
import net.mehvahdjukaar.polytone.utils.ITargetProvider;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockPropertyModifier(Optional<? extends BlockColor> tintGetter, Optional<SoundType> soundType, Optional<Function<BlockState, MapColor>> mapColor, Optional<Boolean> canOcclude, Optional<Boolean> spawnParticlesOnBreak, Optional<RenderType> renderType, Optional<ToIntFunction<BlockState>> clientLight, Optional<List<BlockParticleEmitter>> particleEmitters, Optional<List<BlockSoundEmitter>> soundEmitters, Optional<BlockBehaviour.OffsetFunction> offsetType, Optional<BlockSetTypeProvider> blockSetType, @NotNull Set<ResourceLocation> explicitTargets, boolean tintHack) implements ITargetProvider
{
    public static final Decoder<BlockPropertyModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(IndexCompoundColorGetter.SINGLE_OR_MULTIPLE, "colormap").forGetter(b -> b.tintGetter.flatMap(t -> {
        IndexCompoundColorGetter c;
        return Optional.ofNullable(t instanceof IndexCompoundColorGetter ? (c = (IndexCompoundColorGetter)t) : null);
    })), (App)StrOpt.of(PolytoneSoundType.CODEC, "sound_type").forGetter(BlockPropertyModifier::soundType), (App)StrOpt.of(MapColorHelper.CODEC.xmap(c -> a -> c, f -> MapColor.f_283808_), "map_color").forGetter(BlockPropertyModifier::mapColor), (App)StrOpt.of(Codec.BOOL, "can_occlude").forGetter(BlockPropertyModifier::canOcclude), (App)StrOpt.of(Codec.BOOL, "spawn_particles_on_break").forGetter(BlockPropertyModifier::spawnParticlesOnBreak), (App)StringRepresentable.m_216439_(RenderType::values).optionalFieldOf("render_type").forGetter(BlockPropertyModifier::renderType), (App)Codec.intRange((int)0, (int)15).xmap(integer -> s -> integer, toIntFunction -> 0).optionalFieldOf("client_light").forGetter(BlockPropertyModifier::clientLight), (App)BlockParticleEmitter.CODEC.listOf().optionalFieldOf("particle_emitters").forGetter(BlockPropertyModifier::particleEmitters), (App)BlockSoundEmitter.CODEC.listOf().optionalFieldOf("sound_emitters").forGetter(BlockPropertyModifier::soundEmitters), (App)StringRepresentable.m_216439_(OffsetTypeR::values).xmap(OffsetTypeR::getFunction, offsetFunction -> OffsetTypeR.NONE).optionalFieldOf("offset_type").forGetter(BlockPropertyModifier::offsetType), (App)BlockSetTypeProvider.CODEC.optionalFieldOf("block_set_type").forGetter(BlockPropertyModifier::blockSetType), (App)TARGET_CODEC.optionalFieldOf("targets", Set.of()).forGetter(BlockPropertyModifier::explicitTargets), (App)StrOpt.of(Codec.BOOL, "force_tint_hack", false).forGetter(BlockPropertyModifier::tintHack)).apply((Applicative)instance, BlockPropertyModifier::new));

    public BlockPropertyModifier merge(BlockPropertyModifier other) {
        return new BlockPropertyModifier(other.tintGetter.isPresent() ? other.tintGetter() : this.tintGetter(), other.soundType().isPresent() ? other.soundType() : this.soundType(), other.mapColor.isPresent() ? other.mapColor() : this.mapColor(), other.canOcclude().isPresent() ? other.canOcclude() : this.canOcclude(), other.spawnParticlesOnBreak().isPresent() ? other.spawnParticlesOnBreak() : this.spawnParticlesOnBreak(), other.renderType().isPresent() ? other.renderType() : this.renderType(), other.clientLight.isPresent() ? other.clientLight : this.clientLight, other.particleEmitters.isPresent() ? other.particleEmitters : this.particleEmitters, other.soundEmitters.isPresent() ? other.soundEmitters : this.soundEmitters, other.offsetType().isPresent() ? other.offsetType() : this.offsetType(), other.blockSetType().isPresent() ? other.blockSetType() : this.blockSetType(), this.mergeSet(other.explicitTargets, this.explicitTargets), other.tintHack || this.tintHack);
    }

    public static BlockPropertyModifier ofBlockColor(BlockColor colormap) {
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Set.of(), false);
    }

    public static BlockPropertyModifier coloringBlocks(BlockColor colormap, Block ... blocks) {
        return BlockPropertyModifier.coloringBlocks(colormap, Set.of((ResourceLocation[])Arrays.stream(blocks).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7981_(arg_0)).toArray(ResourceLocation[]::new)));
    }

    public static BlockPropertyModifier coloringBlocks(BlockColor colormap, List<Block> blocks) {
        return BlockPropertyModifier.coloringBlocks(colormap, blocks.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256975_).m_7981_(arg_0)).collect(Collectors.toSet()));
    }

    public static BlockPropertyModifier coloringBlocks(BlockColor colormap, Set<ResourceLocation> blocks) {
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), blocks, false);
    }

    public BlockPropertyModifier apply(Block block) {
        SoundType oldSound = null;
        if (this.soundType.isPresent()) {
            oldSound = block.f_60446_;
            block.f_60446_ = this.soundType.get();
        }
        Optional oldOffsetType = Optional.empty();
        boolean hasOffset = false;
        if (this.offsetType.isPresent()) {
            oldOffsetType = block.m_49966_().f_271099_;
            for (BlockState s : block.m_49965_().m_61056_()) {
                s.f_271099_ = this.offsetType;
                hasOffset = true;
            }
        }
        if (hasOffset) {
            block.f_60438_ = true;
        }
        Function oldMapColor = null;
        if (this.mapColor.isPresent()) {
            oldMapColor = block.f_60439_.f_283880_;
            block.f_60439_.f_283880_ = this.mapColor.get();
            for (BlockState s : block.m_49965_().m_61056_()) {
                s.f_283893_ = (MapColor)block.f_60439_.f_283880_.apply(s);
            }
        }
        Boolean oldCanOcclude = null;
        if (this.canOcclude.isPresent()) {
            oldCanOcclude = block.f_60439_.f_60895_;
            block.f_60439_.f_60895_ = this.canOcclude.get();
            for (UnmodifiableIterator s : block.m_49965_().m_61056_()) {
                s.f_60601_ = this.canOcclude.get();
            }
        }
        Boolean oldSpawnParticlesOnBreak = null;
        if (this.spawnParticlesOnBreak.isPresent()) {
            oldSpawnParticlesOnBreak = block.f_60439_.f_243850_;
            block.f_60439_.f_243850_ = this.spawnParticlesOnBreak.get();
            for (UnmodifiableIterator s : block.m_49965_().m_61056_()) {
                s.f_244264_ = block.f_60439_.f_243850_;
            }
        }
        ToIntFunction oldClientLight = null;
        if (this.clientLight.isPresent()) {
            oldClientLight = block.f_60439_.f_60886_;
            block.f_60439_.f_60886_ = this.clientLight.get();
            for (BlockState s : block.m_49965_().m_61056_()) {
                s.f_60594_ = block.f_60439_.f_60886_.applyAsInt(s);
            }
        }
        BlockColor oldColor = null;
        if (this.tintGetter.isPresent()) {
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            oldColor = PlatStuff.getBlockColor(blockColors, block);
            blockColors.m_92589_(this.tintGetter.get(), new Block[]{block});
        }
        BlockSetTypeProvider.Vanilla oldType = null;
        if (this.blockSetType.isPresent()) {
            if (block instanceof DoorBlock) {
                DoorBlock db = (DoorBlock)block;
                oldType = new BlockSetTypeProvider.Vanilla(db.f_271255_);
                db.f_271255_ = this.blockSetType.get().getOrCreate(db.m_278711_(), this.soundType);
            } else if (block instanceof TrapDoorBlock) {
                TrapDoorBlock tb = (TrapDoorBlock)block;
                oldType = new BlockSetTypeProvider.Vanilla(tb.f_271458_);
                tb.f_271458_ = this.blockSetType.get().getOrCreate(tb.f_271458_, this.soundType);
            } else if (block instanceof ButtonBlock) {
                ButtonBlock bb = (ButtonBlock)block;
                oldType = new BlockSetTypeProvider.Vanilla(bb.f_271519_);
                bb.f_271519_ = this.blockSetType.get().getOrCreate(bb.f_271519_, this.soundType);
            } else if (block instanceof PressurePlateBlock) {
                PressurePlateBlock ppb = (PressurePlateBlock)block;
                oldType = new BlockSetTypeProvider.Vanilla(ppb.f_271167_);
                ppb.f_271167_ = this.blockSetType.get().getOrCreate(ppb.f_271167_, this.soundType);
            }
        }
        if (this.tintHack) {
            Polytone.VARIANT_TEXTURES.addTintOverrideHack(block);
        }
        RenderType oldRenderType = null;
        if (this.renderType.isPresent() && !Polytone.isForge) {
            oldRenderType = this.renderType.get().fromVanilla(PlatStuff.getRenderType(block));
            PlatStuff.setRenderType(block, this.renderType.get().toVanilla());
        }
        return new BlockPropertyModifier(Optional.ofNullable(oldColor), Optional.ofNullable(oldSound), Optional.ofNullable(oldMapColor), Optional.ofNullable(oldCanOcclude), Optional.ofNullable(oldSpawnParticlesOnBreak), Optional.ofNullable(oldRenderType), Optional.ofNullable(oldClientLight), Optional.empty(), Optional.empty(), oldOffsetType, Optional.ofNullable(oldType), Set.of(), false);
    }

    public boolean hasColormap() {
        return this.tintGetter.isPresent();
    }

    @Nullable
    public IColorGetter getColormap() {
        return this.tintGetter.orElse(null);
    }

    private static enum RenderType implements StringRepresentable
    {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRIPWIRE,
        TRANSLUCENT;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        net.minecraft.client.renderer.RenderType toVanilla() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> net.minecraft.client.renderer.RenderType.m_110451_();
                case 2 -> net.minecraft.client.renderer.RenderType.m_110457_();
                case 3 -> net.minecraft.client.renderer.RenderType.m_110503_();
                case 1 -> net.minecraft.client.renderer.RenderType.m_110463_();
                case 4 -> net.minecraft.client.renderer.RenderType.m_110466_();
            };
        }

        RenderType fromVanilla(net.minecraft.client.renderer.RenderType type) {
            if (net.minecraft.client.renderer.RenderType.m_110451_() == type) {
                return SOLID;
            }
            if (net.minecraft.client.renderer.RenderType.m_110463_() == type) {
                return CUTOUT;
            }
            if (net.minecraft.client.renderer.RenderType.m_110457_() == type) {
                return CUTOUT_MIPPED;
            }
            if (net.minecraft.client.renderer.RenderType.m_110503_() == type) {
                return TRIPWIRE;
            }
            if (net.minecraft.client.renderer.RenderType.m_110466_() == type) {
                return TRANSLUCENT;
            }
            throw new IllegalStateException("Unknown render type value: " + String.valueOf(type));
        }
    }

    public static enum OffsetTypeR implements StringRepresentable
    {
        NONE(BlockBehaviour.OffsetType.NONE),
        XZ(BlockBehaviour.OffsetType.XZ),
        XYZ(BlockBehaviour.OffsetType.XYZ);

        private final BlockBehaviour.OffsetType original;

        private OffsetTypeR(BlockBehaviour.OffsetType offsetType) {
            this.original = offsetType;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public BlockBehaviour.OffsetFunction getFunction() {
            BlockBehaviour.Properties p = BlockBehaviour.Properties.m_284310_().m_222979_(this.original);
            return p.f_271289_.orElse((blockState, blockGetter, blockPos) -> Vec3.f_82478_);
        }
    }
}

