/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.particle.BlockParticleEmitter;
import net.mehvahdjukaar.polytone.sound.BlockSoundEmitter;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.LegacyHelper;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.PropertiesUtils;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockPropertiesManager
extends PartialReloader<Resources> {
    private final Map<Block, BlockPropertyModifier> vanillaProperties = new HashMap<Block, BlockPropertyModifier>();
    private final Map<Block, BlockPropertyModifier> modifiers = new HashMap<Block, BlockPropertyModifier>();
    private final Map<Block, List<BlockClientTickable>> particleAndSoundEmitters = new Object2ObjectOpenHashMap();
    private final Map<ResourceLocation, String> optifineColormapsToBlocks = new HashMap<ResourceLocation, String>();

    public BlockPropertiesManager() {
        super("block_modifiers", "block_properties");
    }

    @Override
    protected Resources prepare(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>();
        Map<ResourceLocation, ArrayImage> ofTextures = ArrayImage.scanDirectory(resourceManager, "optifine/colormap");
        Map<ResourceLocation, ArrayImage> cmTextures = ArrayImage.scanDirectory(resourceManager, "colormatic/colormap");
        Map<ResourceLocation, Properties> ofProperties = PropertiesUtils.gatherProperties(resourceManager, "optifine/colormap");
        HashMap<ResourceLocation, JsonElement> ofJsons = new HashMap<ResourceLocation, JsonElement>();
        SimpleJsonResourceReloadListener.m_278771_((ResourceManager)resourceManager, (String)"optifine/colormap", (Gson)GSON, ofJsons);
        this.checkConditions(ofJsons);
        ofJsons.forEach((k, v) -> ofProperties.put((ResourceLocation)k, PropertiesUtils.jsonToProperties(v)));
        textures.putAll(LegacyHelper.convertPaths(ofTextures));
        textures.putAll(LegacyHelper.convertPaths(cmTextures));
        textures.putAll(this.getImagesInDirectories(resourceManager));
        return new Resources(jsons, textures, LegacyHelper.convertPaths(ofProperties));
    }

    @Override
    public void process(Resources resources, DynamicOps<JsonElement> ops) {
        ResourceLocation id;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        Map<ResourceLocation, ArrayImage.Group> textures = ArrayImage.groupTextures(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        HashMap<ResourceLocation, BlockPropertyModifier> parsedModifiers = new HashMap<ResourceLocation, BlockPropertyModifier>();
        parsedModifiers.putAll(LegacyHelper.convertBlockProperties(resources.ofProperties, resources.textures));
        parsedModifiers.putAll(LegacyHelper.convertInlinedPalettes(this.optifineColormapsToBlocks));
        LegacyHelper.convertOfBlockToFluidProp(parsedModifiers, resources.textures);
        LegacyHelper.convertOfBlockToDimensionProperties(parsedModifiers, resources.textures);
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id2 = entry.getKey();
            BlockPropertyModifier prop = (BlockPropertyModifier)((Pair)BlockPropertyModifier.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.error("Could not decode Client Block Property with json id {} - error: {}", (Object)id2, errorMsg))).getFirst();
            if (parsedModifiers.containsKey(id2)) {
                Polytone.LOGGER.warn("Found duplicate block modifier with id {}. This is likely a non .json converted legacy oneOverriding previous one", (Object)id2);
            }
            parsedModifiers.put(id2, prop);
        }
        for (Map.Entry<Object, Object> entry : parsedModifiers.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            BlockPropertyModifier modifier = (BlockPropertyModifier)entry.getValue();
            if (!modifier.hasColormap() && textures.containsKey(id)) {
                ArrayImage.Group text = textures.get(id);
                IndexCompoundColorGetter defaultSampler = IndexCompoundColorGetter.createDefault((Set<Integer>)text.keySet(), true);
                modifier = modifier.merge(BlockPropertyModifier.ofBlockColor(defaultSampler));
            }
            IColorGetter tint = modifier.getColormap();
            ColormapsManager.tryAcceptingTextureGroup(textures, id, tint, usedTextures, true);
            this.addModifier(id, modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<Object, Object> entry : textures.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            ArrayImage.Group image = (ArrayImage.Group)((Object)entry.getValue());
            IndexCompoundColorGetter tintMap = IndexCompoundColorGetter.createDefault((Set<Integer>)image.keySet(), true);
            ColormapsManager.tryAcceptingTextureGroup(textures, id, (BlockColor)tintMap, usedTextures, true);
            BlockPropertyModifier modifier = BlockPropertyModifier.ofBlockColor(tintMap);
            this.addModifier(id, modifier);
        }
    }

    private void addModifier(ResourceLocation fileId, BlockPropertyModifier mod) {
        for (Block block : mod.getTargets(fileId, BuiltInRegistries.f_256975_)) {
            this.modifiers.merge(block, mod, BlockPropertyModifier::merge);
        }
    }

    @Override
    public void reset() {
        for (Map.Entry<Block, BlockPropertyModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
        }
        this.vanillaProperties.clear();
        this.modifiers.clear();
        this.optifineColormapsToBlocks.clear();
        this.particleAndSoundEmitters.clear();
    }

    @Override
    public void apply() {
        for (Map.Entry<Block, BlockPropertyModifier> e : this.modifiers.entrySet()) {
            Block target = e.getKey();
            BlockPropertyModifier value = e.getValue();
            this.vanillaProperties.put(target, value.apply(target));
            Optional<List<BlockParticleEmitter>> particle = value.particleEmitters();
            particle.ifPresent(emitters -> this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ArrayList()).addAll(emitters));
            Optional<List<BlockSoundEmitter>> sound = value.soundEmitters();
            sound.ifPresent(emitters -> this.particleAndSoundEmitters.computeIfAbsent(target, t -> new ArrayList()).addAll(emitters));
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Block Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }

    public void addSimpleColormap(ResourceLocation path, String str) {
        this.optifineColormapsToBlocks.put(path, str);
    }

    public void maybeEmitParticle(Block block, BlockState state, Level level, BlockPos pos) {
        List<BlockClientTickable> m = this.particleAndSoundEmitters.get(block);
        if (m != null) {
            for (BlockClientTickable p : m) {
                p.tick(level, pos, state);
            }
        }
    }

    public record Resources(Map<ResourceLocation, JsonElement> jsons, Map<ResourceLocation, ArrayImage> textures, Map<ResourceLocation, Properties> ofProperties) {
    }
}

