/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public class BlockContextExpression {
    private final Expression expression;
    private final String unparsed;
    private final boolean hasTime;
    private final boolean hasRain;
    private final boolean hasX;
    private final boolean hasY;
    private final boolean hasZ;
    private final boolean hasState;
    private final boolean hasDayTime;
    private final boolean hasSkyLight;
    private final boolean hasBlockLight;
    private static final String POS_X = "POS_X";
    private static final String POS_Y = "POS_Y";
    private static final String POS_Z = "POS_Z";
    private static final String RAIN = "RAIN";
    private static final String TIME = "TIME";
    private static final String DAY_TIME = "DAY_TIME";
    private static final String BLOCK_LIGHT = "BLOCK_LIGHT";
    private static final String SKY_LIGHT = "SKY_LIGHT";
    private static final String STATE_FUNC = "state_prop";
    private static final Function STATE_PROP = new Function("state_prop", 1){

        public double apply(double ... args) {
            BlockState blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.m_61147_());
            int index = (int)args[0];
            Property p = (Property)properties.get(Mth.m_14045_((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.m_6908_());
            return (float)values.indexOf(blockState.m_61143_(p)) / ((float)properties.size() - 1.0f);
        }
    };
    private static final Function STATE_PROP_INT = new Function("state_prop_i", 1){

        public double apply(double ... args) {
            BlockState blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.m_61147_());
            int index = (int)args[0];
            Property p = (Property)properties.get(Mth.m_14045_((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.m_6908_());
            return values.indexOf(blockState.m_61143_(p));
        }
    };
    private static final ThreadLocal<BlockState> STATE_HACK = new ThreadLocal();
    public static final Codec<BlockContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new BlockContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.unparsed));
    public static final BlockContextExpression ZERO = new BlockContextExpression("0");
    public static final BlockContextExpression ONE = new BlockContextExpression("1");
    public static final BlockContextExpression PARTICLE_RAND = new BlockContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    private static Expression createExpression(String s) {
        return new ExpressionBuilder(s).functions(ExpressionUtils.defFunc(STATE_PROP, STATE_PROP_INT)).variables(new String[]{POS_X, POS_Y, POS_Z, RAIN, DAY_TIME, TIME, BLOCK_LIGHT, SKY_LIGHT}).operator(ExpressionUtils.defOp(new Operator[0])).build();
    }

    public BlockContextExpression(String expression) {
        this(BlockContextExpression.createExpression(expression), expression);
    }

    public BlockContextExpression(Expression expression, String unparsed) {
        this.expression = expression;
        this.unparsed = unparsed;
        this.hasTime = unparsed.contains(TIME);
        this.hasX = unparsed.contains(POS_X);
        this.hasY = unparsed.contains(POS_Y);
        this.hasZ = unparsed.contains(POS_Z);
        this.hasState = unparsed.contains(STATE_FUNC);
        this.hasRain = unparsed.contains(RAIN);
        this.hasDayTime = unparsed.contains(DAY_TIME);
        this.hasSkyLight = unparsed.contains(SKY_LIGHT);
        this.hasBlockLight = unparsed.contains(BLOCK_LIGHT);
    }

    public double getValue(Vec3 pos, float entityTime) {
        ExpressionUtils.randomizeRandom();
        if (this.hasX) {
            this.expression.setVariable(POS_X, pos.f_82479_);
        }
        if (this.hasY) {
            this.expression.setVariable(POS_Y, pos.f_82480_);
        }
        if (this.hasZ) {
            this.expression.setVariable(POS_Z, pos.f_82481_);
        }
        if (this.hasTime) {
            this.expression.setVariable(TIME, (double)entityTime);
        }
        if (this.hasRain) {
            this.expression.setVariable(RAIN, (double)ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasDayTime) {
            this.expression.setVariable(DAY_TIME, ClientFrameTicker.getDayTime());
        }
        return this.expression.evaluate();
    }

    public double getValue(Level level, BlockPos pos, BlockState state) {
        ExpressionUtils.seedRandom((long)pos.hashCode() * pos.m_121878_());
        if (this.hasX) {
            this.expression.setVariable(POS_X, (double)pos.m_123341_());
        }
        if (this.hasY) {
            this.expression.setVariable(POS_Y, (double)pos.m_123342_());
        }
        if (this.hasZ) {
            this.expression.setVariable(POS_Z, (double)pos.m_123343_());
        }
        if (this.hasTime) {
            this.expression.setVariable(TIME, ClientFrameTicker.getGameTime());
        }
        if (this.hasRain) {
            this.expression.setVariable(RAIN, (double)ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasDayTime) {
            this.expression.setVariable(DAY_TIME, ClientFrameTicker.getDayTime());
        }
        if (this.hasSkyLight) {
            this.expression.setVariable(SKY_LIGHT, (double)level.m_45517_(LightLayer.SKY, pos));
        }
        if (this.hasBlockLight) {
            this.expression.setVariable(BLOCK_LIGHT, (double)level.m_45517_(LightLayer.BLOCK, pos));
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        return this.expression.evaluate();
    }
}

