/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.utils.ITargetProvider;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.mehvahdjukaar.polytone.utils.Weather;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.phys.Vec2;

public record BiomeEffectModifier(Optional<Integer> fogColor, Optional<Integer> waterColor, Optional<Integer> waterFogColor, Optional<Integer> skyColor, Optional<Integer> foliageColorOverride, Optional<Integer> grassColorOverride, Optional<BiomeSpecialEffects.GrassColorModifier> grassColorModifier, Optional<AmbientParticleSettings> ambientParticleSettings, Optional<Holder<SoundEvent>> ambientLoopSoundEvent, Optional<AmbientMoodSettings> ambientMoodSettings, Optional<AmbientAdditionsSettings> ambientAdditionsSettings, Optional<Music> backgroundMusic, Optional<FogParam> fogStart, Optional<FogParam> fogEnd, Set<ResourceLocation> explicitTargets) implements ITargetProvider
{
    public static final Codec<BiomeEffectModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(Codec.INT, "fog_color").forGetter(BiomeEffectModifier::fogColor), (App)StrOpt.of(Codec.INT, "water_color").forGetter(BiomeEffectModifier::waterColor), (App)StrOpt.of(Codec.INT, "water_fog_color").forGetter(BiomeEffectModifier::waterFogColor), (App)StrOpt.of(Codec.INT, "sky_color").forGetter(BiomeEffectModifier::skyColor), (App)StrOpt.of(Codec.INT, "foliage_color").forGetter(BiomeEffectModifier::foliageColorOverride), (App)StrOpt.of(Codec.INT, "grass_color").forGetter(BiomeEffectModifier::grassColorOverride), (App)StrOpt.of(BiomeSpecialEffects.GrassColorModifier.f_48050_, "grass_color_modifier").forGetter(BiomeEffectModifier::grassColorModifier), (App)StrOpt.of(AmbientParticleSettings.f_47412_, "particle").forGetter(BiomeEffectModifier::ambientParticleSettings), (App)StrOpt.of(SoundEvent.f_263130_, "ambient_sound").forGetter(BiomeEffectModifier::ambientLoopSoundEvent), (App)StrOpt.of(AmbientMoodSettings.f_47386_, "mood_sound").forGetter(BiomeEffectModifier::ambientMoodSettings), (App)StrOpt.of(AmbientAdditionsSettings.f_47371_, "additions_sound").forGetter(BiomeEffectModifier::ambientAdditionsSettings), (App)StrOpt.of(Music.f_11620_, "music").forGetter(BiomeEffectModifier::backgroundMusic), (App)StrOpt.of(FogParam.CODEC, "fog_start").forGetter(BiomeEffectModifier::fogStart), (App)StrOpt.of(FogParam.CODEC, "fog_end").forGetter(BiomeEffectModifier::fogEnd), (App)StrOpt.of(TARGET_CODEC, "targets", Set.of()).forGetter(BiomeEffectModifier::explicitTargets)).apply((Applicative)instance, BiomeEffectModifier::new));
    private static final FogParam ONE = () -> 1.0f;

    public static BiomeEffectModifier ofWaterColor(int waterColor) {
        return new BiomeEffectModifier(Optional.empty(), Optional.of(waterColor), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Set.of());
    }

    public BiomeEffectModifier merge(BiomeEffectModifier other) {
        return new BiomeEffectModifier(other.fogColor.isPresent() ? other.fogColor() : this.fogColor(), other.waterColor().isPresent() ? other.waterColor() : this.waterColor(), other.waterFogColor().isPresent() ? other.waterFogColor() : this.waterFogColor(), other.skyColor().isPresent() ? other.skyColor() : this.skyColor(), other.foliageColorOverride().isPresent() ? other.waterColor() : this.foliageColorOverride(), other.grassColorOverride().isPresent() ? other.grassColorOverride() : this.grassColorOverride(), other.grassColorModifier().isPresent() ? other.grassColorModifier() : this.grassColorModifier(), other.ambientParticleSettings().isPresent() ? other.ambientParticleSettings() : this.ambientParticleSettings(), other.ambientLoopSoundEvent().isPresent() ? other.ambientLoopSoundEvent() : this.ambientLoopSoundEvent(), other.ambientMoodSettings().isPresent() ? other.ambientMoodSettings() : this.ambientMoodSettings(), other.ambientAdditionsSettings().isPresent() ? other.ambientAdditionsSettings() : this.ambientAdditionsSettings(), other.backgroundMusic().isPresent() ? other.backgroundMusic() : this.backgroundMusic(), other.fogStart().isPresent() ? other.fogStart() : this.fogStart(), other.fogEnd().isPresent() ? other.fogEnd() : this.fogEnd(), this.mergeSet(this.explicitTargets, other.explicitTargets));
    }

    public BiomeSpecialEffects apply(Biome biome) {
        BiomeSpecialEffects effects = biome.m_47557_();
        BiomeSpecialEffects.Builder builder = this.getBuilder(effects);
        Optional<Integer> newFoliageColorOverride = effects.m_47981_();
        if (this.foliageColorOverride.isPresent()) {
            newFoliageColorOverride = this.foliageColorOverride;
        }
        newFoliageColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48043_(arg_0));
        Optional<Integer> newGrassColorOverride = effects.m_47984_();
        if (this.grassColorOverride.isPresent()) {
            newGrassColorOverride = this.grassColorOverride;
        }
        newGrassColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48045_(arg_0));
        BiomeSpecialEffects.GrassColorModifier newGrassColorModifier = effects.m_47987_();
        if (this.grassColorModifier.isPresent()) {
            newGrassColorModifier = this.grassColorModifier.get();
        }
        builder.m_48031_(newGrassColorModifier);
        Optional<AmbientParticleSettings> newParticle = effects.m_47990_();
        if (this.ambientParticleSettings.isPresent()) {
            newParticle = this.ambientParticleSettings;
        }
        newParticle.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48029_(arg_0));
        Optional<Holder<SoundEvent>> newAmbientSound = effects.m_47993_();
        if (this.ambientLoopSoundEvent.isPresent()) {
            newAmbientSound = this.ambientLoopSoundEvent;
        }
        newAmbientSound.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48023_(arg_0));
        Optional<AmbientMoodSettings> newMood = effects.m_47996_();
        if (this.ambientMoodSettings.isPresent()) {
            newMood = this.ambientMoodSettings;
        }
        newMood.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48027_(arg_0));
        Optional<AmbientAdditionsSettings> newAdditions = effects.m_47999_();
        if (this.ambientAdditionsSettings.isPresent()) {
            newAdditions = this.ambientAdditionsSettings;
        }
        newAdditions.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48025_(arg_0));
        Optional<Music> newMusic = effects.m_48002_();
        if (this.backgroundMusic.isPresent()) {
            newMusic = this.backgroundMusic;
        }
        newMusic.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48021_(arg_0));
        BiomeSpecialEffects copy = this.copy(effects);
        BiomeEffectModifier.applyEffects(biome, builder.m_48018_());
        return copy;
    }

    private BiomeSpecialEffects.Builder getBuilder(BiomeSpecialEffects effects) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder();
        int newFog = effects.m_47967_();
        if (this.fogColor.isPresent()) {
            newFog = this.fogColor.get();
        }
        builder.m_48019_(newFog);
        int newWaterColor = effects.m_47972_();
        if (this.waterColor.isPresent()) {
            newWaterColor = this.waterColor.get();
        }
        builder.m_48034_(newWaterColor);
        int newWaterFogColor = effects.m_47975_();
        if (this.waterFogColor.isPresent()) {
            newWaterFogColor = this.waterFogColor.get();
        }
        builder.m_48037_(newWaterFogColor);
        int newSkyColor = effects.m_47978_();
        if (this.skyColor.isPresent()) {
            newSkyColor = this.skyColor.get();
        }
        builder.m_48040_(newSkyColor);
        return builder;
    }

    private BiomeSpecialEffects copy(BiomeSpecialEffects effects) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder();
        builder.m_48019_(effects.m_47967_());
        builder.m_48034_(effects.m_47972_());
        builder.m_48037_(effects.m_47975_());
        builder.m_48040_(effects.m_47978_());
        effects.m_47981_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48043_(arg_0));
        effects.m_47984_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48045_(arg_0));
        builder.m_48031_(effects.m_47987_());
        effects.m_47990_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48029_(arg_0));
        effects.m_47993_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48023_(arg_0));
        effects.m_47996_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48027_(arg_0));
        effects.m_47999_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48025_(arg_0));
        effects.m_48002_().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).m_48021_(arg_0));
        return builder.m_48018_();
    }

    public static void applyEffects(Biome biome, BiomeSpecialEffects newEffects) {
        PlatStuff.applyBiomeSurgery(biome, newEffects);
    }

    private static void applyInplace(Biome biome, BiomeSpecialEffects newEffects) {
        BiomeSpecialEffects oldEffects = biome.m_47557_();
        oldEffects.f_47927_ = -1;
        oldEffects.f_47928_ = newEffects.m_47972_();
        oldEffects.f_47929_ = newEffects.m_47975_();
        oldEffects.f_47930_ = -1;
        oldEffects.f_47931_ = newEffects.m_47981_();
        oldEffects.f_47932_ = Optional.of(-1);
        oldEffects.f_47933_ = newEffects.m_47987_();
        oldEffects.f_47934_ = newEffects.m_47990_();
        oldEffects.f_47935_ = newEffects.m_47993_();
        oldEffects.f_47936_ = newEffects.m_47996_();
        oldEffects.f_47937_ = newEffects.m_47999_();
        oldEffects.f_47938_ = newEffects.m_48002_();
    }

    public boolean modifyFogParameter() {
        return this.fogStart.isPresent() || this.fogEnd.isPresent();
    }

    public Vec2 modifyFogParameters() {
        return new Vec2(this.fogStart.map(FogParam::get).orElse(Float.valueOf(1.0f)).floatValue(), this.fogEnd.map(FogParam::get).orElse(Float.valueOf(1.0f)).floatValue());
    }

    public static interface FogParam {
        public static final Codec<FogParam> SIMPLE_CODEC = Codec.FLOAT.xmap(f -> () -> f.floatValue(), FogParam::get);
        public static final Codec<FogParam> CODEC = Codec.either(SIMPLE_CODEC, (Codec)Codec.simpleMap(Weather.CODEC, SIMPLE_CODEC, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])Weather.values())).xmap(FogMap::new, FogMap::map).codec()).xmap(e -> (FogParam)e.map(fogParam -> fogParam, fogMap -> fogMap), Either::left);

        public float get();
    }

    public record FogMap(Map<Weather, FogParam> map) implements FogParam
    {
        @Override
        public float get() {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            Weather w = Weather.get(level);
            return this.map.getOrDefault((Object)w, ONE).get();
        }
    }
}

