/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import traben.tconfig.TConfig;
import traben.tconfig.TConfigHandler;
import traben.tconfig.gui.TConfigEntryListWidget;
import traben.tconfig.gui.TConfigScreen;
import traben.tconfig.gui.entries.TConfigEntry;
import traben.tconfig.gui.entries.TConfigEntryCategory;

public abstract class TConfigScreenMain
extends TConfigScreen {
    protected final TConfigEntryCategory entries;
    protected final List<ResourceLocation> modIcons;
    protected final Set<TConfigHandler<?>> configHandlers;
    boolean haveInitConfigs = false;

    public TConfigScreenMain(String title, Screen parent, Set<TConfigHandler<?>> inputHandlers, List<TConfigEntry> defaultEntries) {
        super(title, parent, true);
        this.entries = new TConfigEntryCategory.Empty().addAll(defaultEntries);
        this.modIcons = new ArrayList<ResourceLocation>();
        this.configHandlers = inputHandlers;
        this.resetDefaultValuesRunnable = this.entries::setValuesToDefault;
        this.undoChangesRunnable = this.entries::resetValuesToInitial;
    }

    @Override
    protected Component getBackButtonText() {
        return CommonComponents.f_130655_;
    }

    private void initConfigs() {
        if (this.haveInitConfigs) {
            return;
        }
        this.haveInitConfigs = true;
        this.configHandlers.stream().filter(TConfigHandler::doesGUI).forEach(configHandler -> {
            Object config = configHandler.getConfig();
            this.entries.addAll((Collection<TConfigEntry>)((TConfig)config).getGUIOptions().getOptions().values());
            ResourceLocation icon = ((TConfig)config).getModIcon();
            if (icon != null) {
                this.modIcons.add(icon);
            }
        });
    }

    @Override
    public void m_7379_() {
        if (this.entries.saveValuesToConfig()) {
            this.configHandlers.forEach(TConfigHandler::saveToFile);
            Minecraft.m_91087_().m_91391_();
        }
        super.m_7379_();
    }

    @Override
    protected void m_7856_() {
        this.initConfigs();
        super.m_7856_();
        TConfigEntryListWidget child = new TConfigEntryListWidget((int)((double)this.f_96543_ * 0.3), (int)((double)this.f_96544_ * 0.7), (int)((double)this.f_96544_ * 0.15), (int)((double)this.f_96543_ * 0.6), 24, (TConfigEntry[])this.entries.getOptions().values().toArray((Object[])new TConfigEntry[0]));
        this.m_142416_((GuiEventListener)child);
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        if (!this.modIcons.isEmpty()) {
            int ix = this.f_96543_ - this.modIcons.size() * 34;
            for (ResourceLocation modIcon : this.modIcons) {
                context.m_280163_(modIcon, ix, 2, 0.0f, 0.0f, 32, 32, 32, 32);
                ix += 34;
            }
        }
    }
}

