/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.item.group.manager;

import com.conquestreforged.core.item.group.ConquestItemGroup;
import com.conquestreforged.core.item.group.manager.DelegateGroup;
import com.conquestreforged.core.item.group.manager.GroupType;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemGroupManager {
    private static final ItemGroupManager instance = new ItemGroupManager();
    public static final List<CreativeModeTab> fixed = Lists.newArrayList((Object[])new CreativeModeTab[]{CreativeModeTabs.m_258007_(), (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_257039_), (CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_256917_)});
    private final Map<Class<?>, Set<CreativeModeTab>> conquestGroups = new HashMap();
    private final Map<GroupType, Set<CreativeModeTab>> groups = new EnumMap<GroupType, Set<CreativeModeTab>>(GroupType.class);

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void init(FMLClientSetupEvent event) {
        instance.storeVanillaGroups();
        instance.storeModGroups();
    }

    private ItemGroupManager() {
        for (GroupType type : GroupType.values()) {
            this.groups.put(type, new HashSet());
        }
    }

    public void register(ConquestItemGroup group) {
        this.conquestGroups.computeIfAbsent(((Object)((Object)group)).getClass(), k -> new HashSet()).add(group);
        this.groups.put(GroupType.CONQUEST, this.conquestGroups.get(((Object)((Object)group)).getClass()));
    }

    public void setConquestType(Class<? extends ConquestItemGroup> type) {
        Set groupList = this.conquestGroups.getOrDefault(type, Collections.emptySet());
        this.groups.put(GroupType.CONQUEST, groupList);
    }

    public void setVisibleItemGroups(GroupType ... types) {
    }

    private void storeVanillaGroups() {
        Set<CreativeModeTab> groups = this.groups.get((Object)GroupType.VANILLA);
        for (CreativeModeTab group : CreativeModeTabs.m_257478_()) {
            if (fixed.contains(group) || group instanceof ConquestItemGroup || group instanceof DelegateGroup) continue;
            groups.add(group);
        }
    }

    private void storeModGroups() {
        Set<CreativeModeTab> vanilla = this.groups.get((Object)GroupType.VANILLA);
        Set<CreativeModeTab> other = this.groups.get((Object)GroupType.OTHER);
        for (CreativeModeTab group : CreativeModeTabs.m_257478_()) {
            if (vanilla.contains(group) || group instanceof ConquestItemGroup || group instanceof DelegateGroup) continue;
            other.add(group);
        }
    }

    public static ItemGroupManager getInstance() {
        return instance;
    }

    static {
        fixed.sort(Comparator.comparing(arg_0 -> ((Registry)BuiltInRegistries.f_279662_).m_7447_(arg_0)));
    }
}

