/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.item.family;

import com.conquestreforged.core.item.family.Family;
import com.conquestreforged.core.item.family.FamilyRegistry;
import com.conquestreforged.core.util.OptimizedList;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DeferredFamily<T extends ItemLike>
extends Family<T> {
    private final T empty;
    private final ResourceLocation name;
    private final FamilyRegistry<T> registry;

    DeferredFamily(ResourceLocation name, T empty, FamilyRegistry<T> registry) {
        super(CreativeModeTabs.m_258007_(), new OptimizedList());
        this.name = name;
        this.empty = empty;
        this.registry = registry;
    }

    @Override
    protected T emptyValue() {
        return this.empty;
    }

    @Override
    protected void addItem(CreativeModeTab group, NonNullList<ItemStack> list, T item) {
    }

    @Override
    public boolean isAbsent() {
        return true;
    }

    public void register() {
        if (this.name != null) {
            Family<ItemLike> family = this.registry.getFamily(this.name);
            for (ItemLike block : this.getMembers()) {
                family.add(block);
                this.registry.register(block, family);
            }
        }
    }
}

