/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.data;

import com.conquestreforged.content.blocks.block.Cube;
import com.conquestreforged.content.blocks.block.trees.BranchLarge;
import com.conquestreforged.core.block.data.BlockDataRegistry;
import com.conquestreforged.core.util.RenderLayer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WorldPainterGenerator {
    public static void run() {
        try (Writer blocks = WorldPainterGenerator.newWriter("conquest_wp.csv");){
            blocks.append("name,discriminator,properties,opacity,receivesLight,insubstantial,resource,tileEntity,tileEntityId,treeRelated,vegetation,blockLight,natural,watery,colour\n");
            BlockDataRegistry.getInstance().getData("conquest").forEach(blockData -> {
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockData.getRegistryName());
                try {
                    ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
                    WorldPainterGenerator.appendBlock(block, blocks);
                    blocks.append(',');
                    blocks.append(',');
                    WorldPainterGenerator.appendState(block.m_49966_(), blocks);
                    blocks.append(',');
                    int opacity = block.m_49966_().m_60815_() ? 15 : 0;
                    blocks.append(opacity + ",");
                    boolean receivesLight = blockData.getProps().getRenderLayer() == RenderLayer.SOLID && !(block instanceof Cube);
                    blocks.append(receivesLight + ",");
                    boolean isVegetation = !(block instanceof BranchLarge) && (block.m_49966_().m_247087_() || blockId.m_135815_().contains("rocks") || blockId.m_135815_().contains("leaves") || block.m_49966_().m_60827_() == SoundType.f_56740_ && blockId.m_135815_().contains("leaf") || blockId.m_135815_().contains("needles") || blockId.m_135815_().contains("blossoms") || blockId.m_135815_().contains("lilac") || blockId.m_135815_().contains("mistletoe") || blockId.m_135815_().contains("tree") || blockId.m_135815_().contains("cypress") || blockId.m_135815_().contains("branch"));
                    blocks.append(isVegetation + ",");
                    blocks.append("false,");
                    blocks.append("false,");
                    blocks.append("false,");
                    boolean isTreeRelated = blockId.m_135815_().contains("log") || blockId.m_135815_().contains("branch") || blockId.m_135815_().contains("tree") || blockId.m_135815_().contains("sapling") || block.m_49966_().m_60827_() == SoundType.f_56740_ && (blockId.m_135815_().contains("leaves") || blockId.m_135815_().contains("leaf") || blockId.m_135815_().contains("needles") || blockId.m_135815_().contains("blossoms") || blockId.m_135815_().contains("lilac") || blockId.m_135815_().contains("mistletoe") || blockId.m_135815_().contains("tree") || blockId.m_135815_().contains("cypress"));
                    blocks.append(isTreeRelated + ",");
                    blocks.append((isTreeRelated || isVegetation) + ",");
                    blocks.append(block.m_49966_().m_60791_() + ",");
                    blocks.append("true,");
                    blocks.append("false,");
                    block.m_284356_();
                    int colorId = block.m_284356_().f_283871_;
                    blocks.append("" + colorId);
                    blocks.append('\n');
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Writer newWriter(String name) throws IOException {
        return new BufferedWriter(new FileWriter(name));
    }

    private static void appendBlock(Block block, Writer writer) throws IOException {
        if (BuiltInRegistries.f_256975_.m_7981_((Object)block) != null) {
            writer.append(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
        }
    }

    private static void appendState(BlockState state, Writer writer) throws IOException {
        if (!state.m_61147_().isEmpty()) {
            writer.append('\"');
            boolean first = true;
            for (Property e : state.m_61147_()) {
                if (!first) {
                    writer.append(',');
                }
                if (e.m_61709_() == Boolean.class) {
                    writer.append(e.m_61708_()).append(":b");
                } else if (e.m_61709_() == Integer.class) {
                    int min = (Integer)Collections.min(e.m_6908_());
                    int max = (Integer)Collections.max(e.m_6908_());
                    writer.append(e.m_61708_()).append(":i[" + min + "-" + max + "]");
                } else {
                    writer.append(e.m_61708_()).append(":e" + e.m_6908_().toString().replace(", ", ";"));
                }
                first = false;
            }
            writer.append('\"');
        }
    }
}

