/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class Config {
    private final ModConfig.Type type;
    private final CommentedFileConfig root;

    public Config(ModConfig.Type type, ForgeConfigSpec spec) {
        String filename = Config.defaultConfigName(type, "conquest");
        this.type = type;
        this.root = (CommentedFileConfig)CommentedFileConfig.builder((Path)Paths.get("config", filename)).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        this.root.load();
        spec.setConfig((CommentedConfig)this.root);
    }

    public ModConfig.Type getType() {
        return this.type;
    }

    public CommentedConfig getRoot() {
        return this.root;
    }

    public void save() {
        this.root.save();
    }

    private static String defaultConfigName(ModConfig.Type type, String modId) {
        return String.format("%s-%s.toml", modId, type.extension());
    }
}

