/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.block.factory;

import com.conquestreforged.core.block.builder.Props;
import com.conquestreforged.core.block.factory.BlockType;
import com.conquestreforged.core.block.factory.InitializationException;
import com.conquestreforged.core.block.factory.constructor.BaseConstructor;
import com.conquestreforged.core.block.factory.constructor.BlockConstructor;
import com.conquestreforged.core.block.factory.constructor.DoorConstructor;
import com.conquestreforged.core.block.factory.constructor.DyeConstructor;
import com.conquestreforged.core.block.factory.constructor.PropsConstructor;
import com.conquestreforged.core.block.factory.constructor.StateConstructor;
import com.conquestreforged.core.block.factory.constructor.WoodTypeConstructor;
import com.conquestreforged.core.util.cache.Cache;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;

public class BlockTypeCache
extends Cache<Class<? extends Block>, BlockType> {
    private static final BlockTypeCache instance = new BlockTypeCache();
    private final List<Entry> entries = new LinkedList<Entry>();

    private BlockTypeCache() {
        this.register(PropsConstructor::new, Props.class);
        this.register(BaseConstructor::new, BlockBehaviour.Properties.class);
        this.register(DyeConstructor::new, DyeColor.class, BlockBehaviour.Properties.class);
        this.register(BlockConstructor::new, Block.class, BlockBehaviour.Properties.class);
        this.register(StateConstructor::new, BlockState.class, BlockBehaviour.Properties.class);
        this.register(DoorConstructor::new, BlockBehaviour.Properties.class, BlockSetType.class);
        this.register(WoodTypeConstructor::new, BlockBehaviour.Properties.class, WoodType.class);
    }

    @Override
    public BlockType compute(Class<? extends Block> type) {
        for (Entry factory : this.entries) {
            try {
                Constructor<? extends Block> constructor = type.getConstructor(factory.argTypes);
                constructor.setAccessible(true);
                return factory.factory.create(constructor);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        throw new InitializationException("constructor not found for type " + String.valueOf(type));
    }

    public void register(BlockType.Factory factory, Class<?> ... argTypes) {
        this.entries.add(new Entry(factory, argTypes));
    }

    public static BlockTypeCache getInstance() {
        return instance;
    }

    private static class Entry {
        private final Class<?>[] argTypes;
        private final BlockType.Factory factory;

        private Entry(BlockType.Factory factory, Class<?>[] argTypes) {
            this.argTypes = argTypes;
            this.factory = factory;
        }
    }
}

