/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.asset.template;

import com.conquestreforged.core.asset.template.JsonOverride;
import com.conquestreforged.core.util.ByteStream;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class JsonTemplate {
    private static final JsonParser parser = new JsonParser();
    private static final Object lock = new Object();
    private final String path;
    private final ResourceLocation location;
    private JsonObject cached;

    JsonTemplate(String location) {
        String root = "";
        if (location.startsWith("assets/")) {
            root = "assets/";
            location = location.substring("assets/".length());
        } else if (location.startsWith("data/")) {
            root = "data/";
            location = location.substring("data/".length());
        }
        int i = location.indexOf(47);
        String domain = location.substring(0, i);
        String path = location.substring(i + 1);
        this.location = new ResourceLocation(domain, path);
        this.path = root + domain + "/" + path;
    }

    public String toString() {
        return "JsonTemplate{location=" + String.valueOf(this.location) + "}";
    }

    public JsonElement getJson(ResourceManager resourceManager, JsonOverride overrides) throws IOException {
        JsonTreeWriter writer = new JsonTreeWriter();
        this.apply(resourceManager, (JsonWriter)writer, overrides);
        return writer.get();
    }

    public void apply(ResourceManager resourceManager, JsonWriter writer, JsonOverride overrides) throws IOException {
        JsonObject object = this.getJson(resourceManager);
        this.write(writer, overrides, (JsonElement)object);
    }

    public InputStream getInputStream(ResourceManager resourceManager, JsonOverride overrides) throws IOException {
        try (ByteStream.Output out = new ByteStream.Output();){
            try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(out));){
                this.apply(resourceManager, writer, overrides);
            }
            InputStream inputStream = out.toInputStream();
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject getJson(ResourceManager resourceManager) throws IOException {
        Object object = lock;
        synchronized (object) {
            block18: {
                if (this.cached == null) {
                    try {
                        Resource resource = (Resource)resourceManager.m_213713_(this.location).get();
                        try (InputStream in = resource.m_215507_();
                             InputStreamReader reader = new InputStreamReader(in);){
                            JsonElement element = parser.parse((Reader)reader);
                            if (element.isJsonObject()) {
                                this.cached = element.getAsJsonObject();
                                break block18;
                            }
                            throw new IOException("resource is not a template object");
                        }
                    }
                    catch (Throwable t) {
                        throw new IOException(this.path, t);
                    }
                }
            }
        }
        return this.cached;
    }

    private void write(JsonWriter writer, JsonOverride overrides, JsonElement element) throws IOException {
        if (element.isJsonArray()) {
            writer.beginArray();
            for (JsonElement entry : element.getAsJsonArray()) {
                this.write(writer, overrides, entry);
            }
            writer.endArray();
            return;
        }
        if (element.isJsonObject()) {
            writer.beginObject();
            for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                writer.name(key);
                boolean overwritten = overrides.appliesTo(key, value) && overrides.apply(value, writer);
                if (overwritten) continue;
                this.write(writer, overrides, value);
            }
            writer.endObject();
            return;
        }
        Streams.write((JsonElement)element, (JsonWriter)writer);
    }
}

