/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.asset.pack;

import com.conquestreforged.core.asset.VirtualResource;
import com.conquestreforged.core.asset.meta.VirtualMeta;
import com.conquestreforged.core.asset.pack.PackFinder;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class VirtualResourcepack
extends AbstractPackResources
implements Supplier<PackResources> {
    private final ResourceManager resourceManager;
    private final Map<String, VirtualResource> resources;

    private VirtualResourcepack(PackType type, ResourceManager resourceManager, String name, Map<String, VirtualResource> resources) {
        super(name, true);
        this.resources = resources;
        this.resourceManager = resourceManager;
        PackFinder.getInstance(type).register(this);
    }

    public int size() {
        return this.resources.size();
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType resourceType, ResourceLocation identifier) {
        return null;
    }

    public void m_8031_(PackType resourceType, String string, String string2, PackResources.ResourceOutput resultConsumer) {
    }

    public Set<String> m_5698_(PackType type) {
        return this.resources.values().stream().filter(r -> r.getType() == type).map(VirtualResource::getNamespace).collect(Collectors.toSet());
    }

    public void close() {
    }

    public void forEach(BiConsumer<String, VirtualResource> visitor) {
        this.resources.forEach(visitor);
    }

    public List<Future<?>> export(Path dir, Gson gson) {
        ArrayList tasks = new ArrayList(this.resources.size());
        for (Map.Entry<String, VirtualResource> entry : this.resources.entrySet()) {
            Path path = dir.resolve(entry.getKey());
            VirtualResource resource = entry.getValue();
            tasks.add(ForkJoinPool.commonPool().submit(() -> {
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        gson.toJson(resource.getJson(this.resourceManager), (Appendable)writer);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }));
        }
        return tasks;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Override
    public PackResources get() {
        return null;
    }

    public static class Builder {
        private final String namespace;
        private final List<VirtualResource> resources = new LinkedList<VirtualResource>();
        private PackType type = PackType.CLIENT_RESOURCES;

        private Builder(String namespace) {
            this.namespace = namespace;
        }

        public Builder type(PackType type) {
            this.type = type;
            return this;
        }

        public Builder add(VirtualResource resource) {
            this.resources.add(resource);
            return this;
        }

        public VirtualResourcepack build(ResourceManager resourceManager) {
            HashMap<String, VirtualResource> map = new HashMap<String, VirtualResource>();
            map.put("pack.mcmeta", new VirtualMeta(this.namespace, this.namespace));
            this.resources.forEach(r -> map.put(r.getPath(), (VirtualResource)r));
            String suffix = this.type == PackType.CLIENT_RESOURCES ? "_resources" : "_data";
            return new VirtualResourcepack(this.type, resourceManager, this.namespace + suffix, map);
        }
    }
}

