/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.asset.meta;

import com.conquestreforged.core.asset.VirtualResource;
import com.conquestreforged.core.util.ByteStream;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.ResourceManager;

public class VirtualMeta
implements VirtualResource {
    public static final int PACK_FORMAT = 5;
    private final String description;
    private final String namespace;

    public VirtualMeta(String namespace, String description) {
        this.description = description;
        this.namespace = namespace;
    }

    public PackMetadataSection toMetadata() {
        return (PackMetadataSection)PackMetadataSection.f_243696_.m_6322_(this.toJson());
    }

    @Override
    public String getPath() {
        return "pack.mcmeta";
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public PackType getType() {
        return PackType.CLIENT_RESOURCES;
    }

    @Override
    public JsonElement getJson(ResourceManager resourceManager) throws IOException {
        return this.toJson();
    }

    @Override
    public InputStream getInputStream(ResourceManager resourceManager) throws IOException {
        ByteStream.Output out = new ByteStream.Output();
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(out));){
            Streams.write((JsonElement)this.toJson(), (JsonWriter)writer);
        }
        return out.toInputStream();
    }

    private JsonObject toJson() {
        JsonObject pack = new JsonObject();
        pack.addProperty("description", this.description);
        pack.addProperty("pack_format", (Number)5);
        JsonObject meta = new JsonObject();
        meta.add("pack", (JsonElement)pack);
        meta.add("language", (JsonElement)new JsonObject());
        return pack;
    }
}

