/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.asset.lang;

import com.conquestreforged.core.asset.VirtualResource;
import com.conquestreforged.core.asset.lang.Translations;
import com.conquestreforged.core.util.ByteStream;
import com.google.gson.JsonElement;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;

public class VirtualLang
implements VirtualResource {
    private final String path;
    private final String namespace;

    public VirtualLang(String namespace) {
        this.namespace = namespace;
        this.path = "assets/" + namespace + "/lang/en_us.json";
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public PackType getType() {
        return PackType.CLIENT_RESOURCES;
    }

    @Override
    public JsonElement getJson(ResourceManager resourceManager) throws IOException {
        JsonTreeWriter writer = new JsonTreeWriter();
        this.write((JsonWriter)writer);
        return writer.get();
    }

    @Override
    public InputStream getInputStream(ResourceManager resourceManager) throws IOException {
        ByteStream.Output output = new ByteStream.Output();
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(output));
        this.write(writer);
        writer.flush();
        return output.toInputStream();
    }

    private void write(JsonWriter writer) throws IOException {
        writer.setIndent("  ");
        writer.beginObject();
        HashSet<String> visited = new HashSet<String>();
        Translations.getInstance().forEach((key, value) -> this.writeSafe((String)key, (String)value, writer, (Set<String>)visited));
        this.writeTranslations(BuiltInRegistries.f_256975_, "block", writer, visited);
        this.writeTranslations(BuiltInRegistries.f_257033_, "item", writer, visited);
        this.writeTranslations(BuiltInRegistries.f_256780_, "entity", writer, visited);
        writer.endObject();
    }

    private void writeSafe(String key, String value, JsonWriter writer, Set<String> visited) {
        if (visited.add(key)) {
            try {
                writer.name(key).value(value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeTranslations(DefaultedRegistry<?> registry, String type, JsonWriter writer, Set<String> visited) throws IOException {
        for (ResourceLocation entry : registry.m_6566_()) {
            String key;
            ResourceLocation name = entry;
            if (name == null || !name.m_135827_().equals(this.getNamespace()) || !visited.add(key = Translations.getKey(type, name))) continue;
            String value = Translations.translate(name.m_135815_());
            writer.name(key);
            writer.value(value);
        }
    }
}

