/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.items.item;

import com.conquestrefabricated.api.painting.Painting;
import com.conquestrefabricated.api.painting.PaintingHolder;
import com.conquestrefabricated.api.painting.art.Art;
import com.conquestreforged.content.entities.painting.ModPainting;
import com.conquestreforged.content.entities.painting.PaintingFactory;
import com.conquestreforged.content.entities.painting.art.ArtType;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class PaintingItem
extends Item
implements PaintingHolder {
    private final String name;
    private final Function<String, Art<?>> art;
    private final Function<String, Painting> type;
    private final PaintingFactory<? extends HangingEntity> factory;

    public PaintingItem(String name, Function<String, Painting> type, Function<String, Art<?>> art, PaintingFactory<? extends HangingEntity> factory) {
        super(new Item.Properties());
        this.name = name;
        this.art = art;
        this.type = type;
        this.factory = factory;
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag painting = stack.m_41783_();
        if (painting == null) {
            return super.m_7626_(stack);
        }
        CompoundTag data = painting.m_128469_("Painting");
        String typeName = data.m_128461_("TypeID");
        String artName = data.m_128461_("ArtID");
        ModPainting type = ModPainting.fromId(typeName);
        Object displayName = "";
        if (type.isPresent()) {
            displayName = type.getDisplayName();
            ArtType art = ArtType.fromName(artName);
            if (art != null) {
                displayName = (String)displayName + " " + art.getDisplayName(type.getTranslationKey());
            }
        } else if (!artName.isEmpty()) {
            displayName = artName;
        }
        return Component.m_237113_((String)displayName);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return super.m_7203_(world, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        InteractionHand hand = context.m_43724_();
        Direction side = context.m_43719_();
        if (player.m_20089_() == Pose.CROUCHING) {
            this.m_7203_(world, player, hand);
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        CompoundTag data = stack.m_41783_();
        if (data == null) {
            return InteractionResult.FAIL;
        }
        CompoundTag paint = data.m_128469_("Painting");
        String paintType = paint.m_128461_("TypeID");
        String paintArt = paint.m_128461_("ArtID");
        if (paintType.isEmpty() || paintArt.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (side != Direction.DOWN && side != Direction.UP) {
            BlockPos pos = context.m_8083_().m_121945_(side);
            HangingEntity painting = this.factory.create(world, pos, side, paintType, paintArt);
            if (painting == null) {
                return InteractionResult.FAIL;
            }
            if (!world.f_46443_) {
                world.m_7967_((Entity)painting);
                painting.m_7084_();
            }
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public Art<?> getArt(ItemStack stack) {
        if (stack.m_41783_() != null) {
            String artName = stack.m_41783_().m_128469_("Painting").m_128461_("ArtID");
            return this.art.apply(artName);
        }
        return null;
    }

    @Override
    public Painting getType(ItemStack stack) {
        if (stack.m_41783_() != null) {
            String typeName = stack.m_41783_().m_128469_("Painting").m_128461_("TypeID");
            return this.type.apply(typeName);
        }
        return null;
    }
}

