/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.entities.painting;

import com.conquestreforged.content.entities.EntityTypes;
import com.conquestreforged.content.entities.painting.ModPainting;
import com.conquestreforged.content.entities.painting.art.ArtType;
import com.conquestreforged.content.entities.painting.art.ModArt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class EntityPainting
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private ModPainting type;
    private ArtType art = ArtType.A1x1_0;

    public EntityPainting(EntityType<EntityPainting> type, Level world) {
        super(type, world);
    }

    public EntityPainting(Level world, BlockPos pos, Direction facing, ModPainting type, ArtType art) {
        super(EntityTypes.PAINTING, world, pos);
        this.f_31699_ = facing;
        this.type = type;
        this.art = art;
        this.m_6022_(facing);
    }

    public ModPainting getPaintingType() {
        return this.type;
    }

    public ArtType getArt() {
        return this.art;
    }

    public void setType(ModPainting type) {
        this.type = type;
    }

    public void setArt(ArtType art) {
        this.art = art;
        if (this.f_31699_ != null) {
            this.m_6022_(this.f_31699_);
        }
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.type.createStack(ModArt.of(this.art));
    }

    public void m_5553_(@Nullable Entity brokenEntity) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack drop;
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (brokenEntity instanceof Player) {
                Player entityplayer = (Player)brokenEntity;
                if (entityplayer.m_150110_().f_35937_) {
                    return;
                }
            }
            if ((drop = this.type.createStack(ModArt.of(this.art))) != ItemStack.f_41583_) {
                this.m_5552_(drop, 0.0f);
            }
        }
    }

    public boolean m_7088_() {
        return true;
    }

    public int m_7076_() {
        return this.art.sizeX;
    }

    public int m_7068_() {
        return this.art.sizeY;
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128344_("Facing", (byte)this.f_31699_.m_122416_());
        super.m_7380_(compound);
        compound.m_128359_("TypeID", this.type.getName());
        compound.m_128405_("ArtID", this.art.index());
    }

    public void m_7378_(CompoundTag compound) {
        String type = compound.m_128461_("TypeID");
        int id = compound.m_128451_("ArtID");
        this.type = ModPainting.fromId(type);
        this.art = ArtType.fromId(id);
        this.f_31699_ = Direction.m_122407_((int)compound.m_128445_("Facing"));
        super.m_7378_(compound);
        this.m_6022_(this.f_31699_);
    }

    public void m_7678_(double x, double y, double z, float yaw, float pitch) {
        this.m_6034_(x, y, z);
    }

    public void m_6453_(double x, double y, double z, float a, float b, int c, boolean bl) {
        BlockPos pos = this.f_31698_;
        this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.f_31698_.m_123341_());
        buffer.writeInt(this.f_31698_.m_123342_());
        buffer.writeInt(this.f_31698_.m_123343_());
        buffer.writeInt(this.f_31699_.m_122416_());
        buffer.m_130070_(this.getPaintingType().getName());
        buffer.m_130070_(this.getArt().shapeId);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int x = additionalData.readInt();
        int y = additionalData.readInt();
        int z = additionalData.readInt();
        int index = additionalData.readInt();
        String type = additionalData.m_130277_();
        String art = additionalData.m_130277_();
        this.type = ModPainting.fromId(type);
        this.art = ArtType.fromName(art);
        this.f_31699_ = Direction.m_122407_((int)index);
        this.m_6022_(Direction.m_122407_((int)index));
        this.m_6034_(x, y, z);
    }
}

