/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.tileentity.campfire;

import com.conquestreforged.content.blocks.tileentity.TileEntityTypes;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ModdedCampfireTileEntity
extends BlockEntity
implements Clearable {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<ItemStack> itemsBeingCooked = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];
    private final RecipeManager.CachedCheck<Container, CampfireCookingRecipe> matchGetter = RecipeManager.m_220267_((RecipeType)RecipeType.f_44111_);

    public ModdedCampfireTileEntity(BlockPos pos, BlockState state) {
        super(TileEntityTypes.CAMPFIRE, pos, state);
    }

    public static void litServerTick(Level world, BlockPos pos, BlockState state, ModdedCampfireTileEntity campfire) {
        boolean bl = false;
        for (int i = 0; i < campfire.itemsBeingCooked.size(); ++i) {
            SimpleContainer inventory;
            ItemStack itemStack2;
            ItemStack itemStack = (ItemStack)campfire.itemsBeingCooked.get(i);
            if (itemStack.m_41619_()) continue;
            bl = true;
            int n = i;
            campfire.cookingTimes[n] = campfire.cookingTimes[n] + 1;
            if (campfire.cookingTimes[i] < campfire.cookingTotalTimes[i] || !(itemStack2 = campfire.matchGetter.m_213657_((Container)(inventory = new SimpleContainer(new ItemStack[]{itemStack})), world).map(arg_0 -> ModdedCampfireTileEntity.lambda$litServerTick$0((Container)inventory, world, arg_0)).orElse(itemStack)).m_246617_(world.m_246046_())) continue;
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack2);
            campfire.itemsBeingCooked.set(i, (Object)ItemStack.f_41583_);
            world.m_7260_(pos, state, state, 3);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
        }
        if (bl) {
            ModdedCampfireTileEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void unlitServerTick(Level world, BlockPos pos, BlockState state, ModdedCampfireTileEntity campfire) {
        boolean bl = false;
        for (int i = 0; i < campfire.itemsBeingCooked.size(); ++i) {
            if (campfire.cookingTimes[i] <= 0) continue;
            bl = true;
            campfire.cookingTimes[i] = Mth.m_14045_((int)(campfire.cookingTimes[i] - 2), (int)0, (int)campfire.cookingTotalTimes[i]);
        }
        if (bl) {
            ModdedCampfireTileEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, ModdedCampfireTileEntity campfire) {
        int i;
        RandomSource random = world.f_46441_;
        if (random.m_188501_() < 0.11f) {
            for (i = 0; i < random.m_188503_(2) + 2; ++i) {
                CampfireBlock.m_51251_((Level)world, (BlockPos)pos, (boolean)((Boolean)state.m_61143_((Property)CampfireBlock.f_51228_)), (boolean)false);
            }
        }
        i = ((Direction)state.m_61143_((Property)CampfireBlock.f_51230_)).m_122416_();
        for (int j = 0; j < campfire.itemsBeingCooked.size(); ++j) {
            if (((ItemStack)campfire.itemsBeingCooked.get(j)).m_41619_() || !(random.m_188501_() < 0.2f)) continue;
            Direction direction = Direction.m_122407_((int)Math.floorMod(j + i, 4));
            float f = 0.3125f;
            double d = (double)pos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * 0.3125f) + (double)((float)direction.m_122427_().m_122429_() * 0.3125f);
            double e = (double)pos.m_123342_() + 0.5;
            double g = (double)pos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * 0.3125f) + (double)((float)direction.m_122427_().m_122431_() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e, g, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItemsBeingCooked() {
        return this.itemsBeingCooked;
    }

    public void m_142466_(CompoundTag nbt) {
        int[] is;
        super.m_142466_(nbt);
        this.itemsBeingCooked.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.itemsBeingCooked);
        if (nbt.m_128425_("CookingTimes", 11)) {
            is = nbt.m_128465_("CookingTimes");
            System.arraycopy(is, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
        if (nbt.m_128425_("CookingTotalTimes", 11)) {
            is = nbt.m_128465_("CookingTotalTimes");
            System.arraycopy(is, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18976_((CompoundTag)nbt, this.itemsBeingCooked, (boolean)true);
        nbt.m_128385_("CookingTimes", this.cookingTimes);
        nbt.m_128385_("CookingTotalTimes", this.cookingTotalTimes);
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbtCompound = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)nbtCompound, this.itemsBeingCooked, (boolean)true);
        return nbtCompound;
    }

    public Optional<CampfireCookingRecipe> getRecipeFor(ItemStack stack) {
        return this.itemsBeingCooked.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.matchGetter.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_);
    }

    public boolean addItem(@Nullable Entity user, ItemStack stack, int cookTime) {
        for (int i = 0; i < this.itemsBeingCooked.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.itemsBeingCooked.get(i);
            if (!itemStack.m_41619_()) continue;
            this.cookingTotalTimes[i] = cookTime;
            this.cookingTimes[i] = 0;
            this.itemsBeingCooked.set(i, (Object)stack.m_41620_(1));
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)user, (BlockState)this.m_58900_()));
            this.updateListeners();
            return true;
        }
        return false;
    }

    private void updateListeners() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_6211_() {
        this.itemsBeingCooked.clear();
    }

    public void spawnItemsBeingCooked() {
        if (this.f_58857_ != null) {
            this.updateListeners();
        }
    }

    private static /* synthetic */ ItemStack lambda$litServerTick$0(Container inventory, Level world, CampfireCookingRecipe recipe) {
        return recipe.m_5874_(inventory, world.m_9598_());
    }
}

