/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.init.blocks;

import com.conquestreforged.content.blocks.block.plants.LilyPad;
import com.conquestreforged.content.blocks.block.plants.LilyPadToggle2;
import com.conquestreforged.content.items.item.LilypadItem;
import com.conquestreforged.core.init.Context;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.ForgeRegistries;

public class LiliesInit {
    public static final Block WHITE_WATER_LILIES = LiliesInit.createBlock("white_water_lilies", SoundType.f_56740_, false);
    public static final Block BIG_WATER_LILIES = LiliesInit.createBlock("big_water_lilies", SoundType.f_56740_, false);
    public static final Block DUCKWEED = LiliesInit.createLilyToggle2Block("duckweed", SoundType.f_56740_, false);
    public static final Block FLOATING_ICE = LiliesInit.createBlock("floating_ice", SoundType.f_56744_, false);

    public static void registerBlocks() {
        ForgeRegistries.BLOCKS.register(Context.getInstance().getNamespace() + ":white_water_lilies", (Object)WHITE_WATER_LILIES);
        ForgeRegistries.BLOCKS.register(Context.getInstance().getNamespace() + ":big_water_lilies", (Object)BIG_WATER_LILIES);
        ForgeRegistries.BLOCKS.register(Context.getInstance().getNamespace() + ":duckweed", (Object)DUCKWEED);
        ForgeRegistries.BLOCKS.register(Context.getInstance().getNamespace() + ":floating_ice", (Object)FLOATING_ICE);
    }

    public static void registerItems() {
        ForgeRegistries.ITEMS.register(Context.getInstance().getNamespace() + ":white_water_lilies", (Object)LiliesInit.createItem(WHITE_WATER_LILIES));
        ForgeRegistries.ITEMS.register(Context.getInstance().getNamespace() + ":big_water_lilies", (Object)LiliesInit.createItem(BIG_WATER_LILIES));
        ForgeRegistries.ITEMS.register(Context.getInstance().getNamespace() + ":duckweed", (Object)LiliesInit.createItem(DUCKWEED));
        ForgeRegistries.ITEMS.register(Context.getInstance().getNamespace() + ":floating_ice", (Object)LiliesInit.createItem(FLOATING_ICE));
    }

    private static LilyPadToggle2 createLilyToggle2Block(String name, SoundType soundType, boolean hasCollision) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(soundType);
        if (!hasCollision) {
            props = props.m_60910_();
        }
        LilyPadToggle2 block = new LilyPadToggle2(props);
        return block;
    }

    private static LilyPad createBlock(String name, SoundType soundType, boolean hasCollision) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(soundType);
        if (!hasCollision) {
            props = props.m_60910_();
        }
        LilyPad block = new LilyPad(props);
        return block;
    }

    private static Item createItem(Block block) {
        LilypadItem item = new LilypadItem(block, new Item.Properties());
        return item;
    }
}

