/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block.food;

import com.conquestreforged.content.blocks.block.BoardsHorizontal;
import com.conquestreforged.content.blocks.block.Layer;
import com.conquestreforged.content.blocks.block.Slab;
import com.conquestreforged.content.blocks.block.SlabLessLayers;
import com.conquestreforged.content.blocks.block.VerticalSlab;
import com.conquestreforged.core.asset.annotation.Render;
import com.conquestreforged.core.asset.annotation.SpecialOffset;
import com.conquestreforged.core.block.builder.SpecialOffsetType;
import com.conquestreforged.core.block.properties.PropertyVariant;
import com.conquestreforged.core.util.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Render(value=RenderLayer.CUTOUT)
@SpecialOffset(offsetType=SpecialOffsetType.XYZ)
public class Plate
extends CakeBlock
implements PropertyVariant {
    public static final BooleanProperty OFFSET_TOGGLE = BooleanProperty.m_61465_((String)"offset_toggle");
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public Plate(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_51180_, (Comparable)Integer.valueOf(6))).m_61124_((Property)OFFSET_TOGGLE, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    @Override
    public Property<?> getVariantProperty() {
        return CakeBlock.f_51180_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_51180_, OFFSET_TOGGLE});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (this.eatActionResult(level, blockPos, state, itemstack, player) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.eatActionResult(level, blockPos, state, itemstack, player);
    }

    private InteractionResult eatActionResult(Level world, BlockPos pos, BlockState state, ItemStack itemStack, Player playerEntity) {
        if (!playerEntity.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        playerEntity.m_36220_(Stats.f_12942_);
        playerEntity.m_36324_().m_38707_(2, 0.1f);
        int i = (Integer)state.m_61143_((Property)f_51180_);
        if (itemStack.m_41720_().m_41472_() && (Integer)state.m_61143_((Property)f_51180_) != 0) {
            if (!playerEntity.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51180_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)f_51180_) - 1)), 3);
            return InteractionResult.SUCCESS;
        }
        if (i < 6) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51180_, (Comparable)Integer.valueOf(i + 1)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_().m_122424_();
        Level blockreader = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
        Block block = state.m_60734_();
        boolean isSlab = false;
        if (facing == Direction.DOWN) {
            isSlab = block instanceof Slab || block instanceof SlabBlock || block instanceof Layer || block instanceof SnowLayerBlock || block instanceof SlabLessLayers || block instanceof BoardsHorizontal;
        } else if (facing != Direction.UP) {
            isSlab = block instanceof VerticalSlab && state.m_61143_((Property)VerticalSlab.DIRECTION) == context.m_43719_();
        }
        return (BlockState)super.m_5573_(context).m_61124_((Property)OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OFFSET_TOGGLE)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, worldIn, pos, context);
    }
}

