/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block.directional;

import com.conquestreforged.content.blocks.block.BoardsHorizontal;
import com.conquestreforged.content.blocks.block.Layer;
import com.conquestreforged.content.blocks.block.Slab;
import com.conquestreforged.content.blocks.block.SlabLessLayers;
import com.conquestreforged.content.blocks.block.VerticalSlab;
import com.conquestreforged.core.asset.annotation.SpecialOffset;
import com.conquestreforged.core.block.base.HorizontalDirectionalShape;
import com.conquestreforged.core.block.builder.Props;
import com.conquestreforged.core.block.builder.SpecialOffsetType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@SpecialOffset(offsetType=SpecialOffsetType.XZ)
public class HorizontalDirectionalOffsetXZ
extends HorizontalDirectionalShape {
    public static final BooleanProperty OFFSET_TOGGLE = BooleanProperty.m_61465_((String)"offset_toggle");
    private final List<VoxelShape> hitBox;

    public HorizontalDirectionalOffsetXZ(Props props) {
        super(props.toSettings());
        this.hitBox = props.get("hitBox", List.class);
    }

    @Override
    public VoxelShape getShape(BlockState state) {
        boolean hasFourShapes = this.hitBox.size() == 4;
        switch ((Direction)state.m_61143_((Property)DIRECTION)) {
            default: {
                return this.hitBox.get(0);
            }
            case EAST: {
                return this.hitBox.get(hasFourShapes ? 1 : 0);
            }
            case SOUTH: {
                return this.hitBox.get(hasFourShapes ? 2 : 0);
            }
            case WEST: 
        }
        return this.hitBox.get(hasFourShapes ? 3 : 0);
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_().m_122424_();
        Level blockreader = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
        Block block = state.m_60734_();
        boolean isSlab = false;
        if (facing == Direction.DOWN) {
            isSlab = block instanceof Slab || block instanceof SlabBlock || block instanceof Layer || block instanceof SnowLayerBlock || block instanceof SlabLessLayers || block instanceof BoardsHorizontal;
        } else if (facing != Direction.UP) {
            isSlab = block instanceof VerticalSlab && state.m_61143_((Property)VerticalSlab.DIRECTION) == context.m_43719_();
        }
        return (BlockState)super.m_5573_(context).m_61124_((Property)OFFSET_TOGGLE, (Comparable)Boolean.valueOf(isSlab));
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OFFSET_TOGGLE)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, worldIn, pos, context);
    }

    @Override
    protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OFFSET_TOGGLE});
    }
}

