/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block;

import com.conquestrefabricated.core.block.properties.ModdedWallShape;
import com.conquestreforged.core.asset.annotation.Assets;
import com.conquestreforged.core.asset.annotation.Model;
import com.conquestreforged.core.asset.annotation.State;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@Assets(state=@State(name="%s_wall", template="parent_wall"), item=@Model(name="item/%s_wall", parent="block/%s_wall_inventory", template="item/cobblestone_wall"), block={@Model(name="block/%s_wall_post", template="block/parent_wall_post"), @Model(name="block/%s_wall_side", template="block/parent_wall_side"), @Model(name="block/%s_wall_side_tall", template="block/parent_wall_side_tall"), @Model(name="block/%s_wall_inventory", template="block/parent_wall_inventory")})
public class WallNew
extends Block {
    public static final VoxelShape TALL_POST_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    public static final VoxelShape TALL_NORTH_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    public static final VoxelShape TALL_SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    public static final VoxelShape TALL_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    public static final VoxelShape TALL_EAST_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<BlockState, VoxelShape> shapeMap;
    private final Map<BlockState, VoxelShape> collisionShapeMap;
    public static final EnumProperty<ModdedWallShape> EAST_SHAPE_CUSTOM = EnumProperty.m_61587_((String)"east", ModdedWallShape.class);
    public static final EnumProperty<ModdedWallShape> NORTH_SHAPE_CUSTOM = EnumProperty.m_61587_((String)"north", ModdedWallShape.class);
    public static final EnumProperty<ModdedWallShape> SOUTH_SHAPE_CUSTOM = EnumProperty.m_61587_((String)"south", ModdedWallShape.class);
    public static final EnumProperty<ModdedWallShape> WEST_SHAPE_CUSTOM = EnumProperty.m_61587_((String)"west", ModdedWallShape.class);

    public WallNew(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_(NORTH_SHAPE_CUSTOM, (Comparable)((Object)ModdedWallShape.NONE))).m_61124_(EAST_SHAPE_CUSTOM, (Comparable)((Object)ModdedWallShape.NONE))).m_61124_(SOUTH_SHAPE_CUSTOM, (Comparable)((Object)ModdedWallShape.NONE))).m_61124_(WEST_SHAPE_CUSTOM, (Comparable)((Object)ModdedWallShape.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeMap = this.getShapeMap(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeMap = this.getShapeMap(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape getVoxelShape(VoxelShape base, ModdedWallShape wallShape, VoxelShape tall, VoxelShape low) {
        if (wallShape == ModdedWallShape.TALL) {
            return Shapes.m_83110_((VoxelShape)base, (VoxelShape)low);
        }
        return wallShape == ModdedWallShape.LOW ? Shapes.m_83110_((VoxelShape)base, (VoxelShape)tall) : base;
    }

    private Map<BlockState, VoxelShape> getShapeMap(float f, float g, float h, float i, float j, float k) {
        float l = 8.0f - f;
        float m = 8.0f + f;
        float n = 8.0f - g;
        float o = 8.0f + g;
        VoxelShape voxelShape = Block.m_49796_((double)l, (double)0.0, (double)l, (double)m, (double)h, (double)m);
        VoxelShape voxelShape2 = Block.m_49796_((double)n, (double)i, (double)0.0, (double)o, (double)j, (double)o);
        VoxelShape voxelShape3 = Block.m_49796_((double)n, (double)i, (double)n, (double)o, (double)j, (double)16.0);
        VoxelShape voxelShape4 = Block.m_49796_((double)0.0, (double)i, (double)n, (double)o, (double)j, (double)o);
        VoxelShape voxelShape5 = Block.m_49796_((double)n, (double)i, (double)n, (double)16.0, (double)j, (double)o);
        VoxelShape voxelShape6 = Block.m_49796_((double)n, (double)i, (double)0.0, (double)o, (double)k, (double)o);
        VoxelShape voxelShape7 = Block.m_49796_((double)n, (double)i, (double)n, (double)o, (double)k, (double)16.0);
        VoxelShape voxelShape8 = Block.m_49796_((double)0.0, (double)i, (double)n, (double)o, (double)k, (double)o);
        VoxelShape voxelShape9 = Block.m_49796_((double)n, (double)i, (double)n, (double)16.0, (double)k, (double)o);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean boolean_ : UP.m_6908_()) {
            for (ModdedWallShape wallShape : EAST_SHAPE_CUSTOM.m_6908_()) {
                for (ModdedWallShape wallShape2 : NORTH_SHAPE_CUSTOM.m_6908_()) {
                    for (ModdedWallShape wallShape3 : WEST_SHAPE_CUSTOM.m_6908_()) {
                        for (ModdedWallShape wallShape4 : SOUTH_SHAPE_CUSTOM.m_6908_()) {
                            VoxelShape voxelShape10 = Shapes.m_83040_();
                            voxelShape10 = WallNew.getVoxelShape(voxelShape10, wallShape, voxelShape5, voxelShape9);
                            voxelShape10 = WallNew.getVoxelShape(voxelShape10, wallShape3, voxelShape4, voxelShape8);
                            voxelShape10 = WallNew.getVoxelShape(voxelShape10, wallShape2, voxelShape2, voxelShape6);
                            voxelShape10 = WallNew.getVoxelShape(voxelShape10, wallShape4, voxelShape3, voxelShape7);
                            if (boolean_.booleanValue()) {
                                voxelShape10 = Shapes.m_83110_((VoxelShape)voxelShape10, (VoxelShape)voxelShape);
                            }
                            BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)boolean_)).m_61124_(EAST_SHAPE_CUSTOM, (Comparable)((Object)wallShape))).m_61124_(WEST_SHAPE_CUSTOM, (Comparable)((Object)wallShape3))).m_61124_(NORTH_SHAPE_CUSTOM, (Comparable)((Object)wallShape2))).m_61124_(SOUTH_SHAPE_CUSTOM, (Comparable)((Object)wallShape4));
                            builder.put((Object)((BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)voxelShape10);
                            builder.put((Object)((BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)voxelShape10);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapeMap.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.collisionShapeMap.get(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    private boolean shouldConnectTo(BlockState state, boolean faceFullSquare, Direction side) {
        Block block = state.m_60734_();
        boolean bl = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)side);
        return state.m_204336_(BlockTags.f_13032_) || !WallNew.m_152463_((BlockState)state) && faceFullSquare || block instanceof IronBarsBlock || bl;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        BlockPos blockPos2 = blockPos.m_122012_();
        BlockPos blockPos3 = blockPos.m_122029_();
        BlockPos blockPos4 = blockPos.m_122019_();
        BlockPos blockPos5 = blockPos.m_122024_();
        BlockPos blockPos6 = blockPos.m_7494_();
        BlockState blockState = worldView.m_8055_(blockPos2);
        BlockState blockState2 = worldView.m_8055_(blockPos3);
        BlockState blockState3 = worldView.m_8055_(blockPos4);
        BlockState blockState4 = worldView.m_8055_(blockPos5);
        BlockState blockState5 = worldView.m_8055_(blockPos6);
        boolean bl = this.shouldConnectTo(blockState, blockState.m_60783_((BlockGetter)worldView, blockPos2, Direction.SOUTH), Direction.SOUTH);
        boolean bl2 = this.shouldConnectTo(blockState2, blockState2.m_60783_((BlockGetter)worldView, blockPos3, Direction.WEST), Direction.WEST);
        boolean bl3 = this.shouldConnectTo(blockState3, blockState3.m_60783_((BlockGetter)worldView, blockPos4, Direction.NORTH), Direction.NORTH);
        boolean bl4 = this.shouldConnectTo(blockState4, blockState4.m_60783_((BlockGetter)worldView, blockPos5, Direction.EAST), Direction.EAST);
        BlockState blockState6 = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return this.getStateWith((LevelReader)worldView, blockState6, blockPos6, blockState5, bl, bl2, bl3, bl4);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (direction == Direction.DOWN) {
            return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
        }
        return direction == Direction.UP ? this.getStateAt((LevelReader)world, state, neighborPos, neighborState) : this.getStateWithNeighbor((LevelReader)world, pos, state, neighborPos, neighborState, direction);
    }

    private static boolean isConnected(BlockState state, Property<ModdedWallShape> property) {
        return state.m_61143_(property) != ModdedWallShape.NONE;
    }

    private static boolean shouldUseTallShape(VoxelShape aboveShape, VoxelShape tallShape) {
        return !Shapes.m_83157_((VoxelShape)tallShape, (VoxelShape)aboveShape, (BooleanOp)BooleanOp.f_82685_);
    }

    private BlockState getStateAt(LevelReader world, BlockState state, BlockPos pos, BlockState aboveState) {
        boolean bl = WallNew.isConnected(state, NORTH_SHAPE_CUSTOM);
        boolean bl2 = WallNew.isConnected(state, EAST_SHAPE_CUSTOM);
        boolean bl3 = WallNew.isConnected(state, SOUTH_SHAPE_CUSTOM);
        boolean bl4 = WallNew.isConnected(state, WEST_SHAPE_CUSTOM);
        return this.getStateWith(world, state, pos, aboveState, bl, bl2, bl3, bl4);
    }

    private BlockState getStateWithNeighbor(LevelReader world, BlockPos pos, BlockState state, BlockPos neighborPos, BlockState neighborState, Direction direction) {
        Direction direction2 = direction.m_122424_();
        boolean bl = direction == Direction.NORTH ? this.shouldConnectTo(neighborState, neighborState.m_60783_((BlockGetter)world, neighborPos, direction2), direction2) : WallNew.isConnected(state, NORTH_SHAPE_CUSTOM);
        boolean bl2 = direction == Direction.EAST ? this.shouldConnectTo(neighborState, neighborState.m_60783_((BlockGetter)world, neighborPos, direction2), direction2) : WallNew.isConnected(state, EAST_SHAPE_CUSTOM);
        boolean bl3 = direction == Direction.SOUTH ? this.shouldConnectTo(neighborState, neighborState.m_60783_((BlockGetter)world, neighborPos, direction2), direction2) : WallNew.isConnected(state, SOUTH_SHAPE_CUSTOM);
        boolean bl4 = direction == Direction.WEST ? this.shouldConnectTo(neighborState, neighborState.m_60783_((BlockGetter)world, neighborPos, direction2), direction2) : WallNew.isConnected(state, WEST_SHAPE_CUSTOM);
        BlockPos blockPos = pos.m_7494_();
        BlockState blockState = world.m_8055_(blockPos);
        return this.getStateWith(world, state, blockPos, blockState, bl, bl2, bl3, bl4);
    }

    private BlockState getStateWith(LevelReader world, BlockState state, BlockPos pos, BlockState aboveState, boolean north, boolean east, boolean south, boolean west) {
        VoxelShape voxelShape = aboveState.m_60812_((BlockGetter)world, pos).m_83263_(Direction.DOWN);
        BlockState blockState = this.getStateWith(state, north, east, south, west, voxelShape);
        return (BlockState)blockState.m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.shouldHavePost(blockState, aboveState, voxelShape)));
    }

    private boolean shouldHavePost(BlockState state, BlockState aboveState, VoxelShape aboveShape) {
        boolean bl7;
        boolean bl6;
        boolean bl;
        boolean bl2 = bl = aboveState.m_60734_() instanceof WallBlock && (Boolean)aboveState.m_61143_((Property)UP) != false;
        if (bl) {
            return true;
        }
        ModdedWallShape wallShape = (ModdedWallShape)((Object)state.m_61143_(NORTH_SHAPE_CUSTOM));
        ModdedWallShape wallShape2 = (ModdedWallShape)((Object)state.m_61143_(SOUTH_SHAPE_CUSTOM));
        ModdedWallShape wallShape3 = (ModdedWallShape)((Object)state.m_61143_(EAST_SHAPE_CUSTOM));
        ModdedWallShape wallShape4 = (ModdedWallShape)((Object)state.m_61143_(WEST_SHAPE_CUSTOM));
        boolean bl22 = wallShape2 == ModdedWallShape.NONE;
        boolean bl3 = wallShape4 == ModdedWallShape.NONE;
        boolean bl4 = wallShape3 == ModdedWallShape.NONE;
        boolean bl5 = wallShape == ModdedWallShape.NONE;
        boolean bl8 = bl6 = bl5 && bl22 && bl3 && bl4 || bl5 != bl22 || bl3 != bl4;
        if (bl6) {
            return true;
        }
        boolean bl9 = bl7 = wallShape == ModdedWallShape.TALL && wallShape2 == ModdedWallShape.TALL || wallShape3 == ModdedWallShape.TALL && wallShape4 == ModdedWallShape.TALL;
        if (bl7) {
            return false;
        }
        return aboveState.m_204336_(BlockTags.f_13081_) || WallNew.shouldUseTallShape(aboveShape, TALL_POST_SHAPE);
    }

    private BlockState getStateWith(BlockState state, boolean north, boolean east, boolean south, boolean west, VoxelShape aboveShape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_SHAPE_CUSTOM, (Comparable)((Object)this.getModdedWallShape(north, aboveShape, TALL_NORTH_SHAPE)))).m_61124_(EAST_SHAPE_CUSTOM, (Comparable)((Object)this.getModdedWallShape(east, aboveShape, TALL_EAST_SHAPE)))).m_61124_(SOUTH_SHAPE_CUSTOM, (Comparable)((Object)this.getModdedWallShape(south, aboveShape, TALL_SOUTH_SHAPE)))).m_61124_(WEST_SHAPE_CUSTOM, (Comparable)((Object)this.getModdedWallShape(west, aboveShape, TALL_WEST_SHAPE)));
    }

    private ModdedWallShape getModdedWallShape(boolean connected, VoxelShape aboveShape, VoxelShape tallShape) {
        if (connected) {
            return WallNew.shouldUseTallShape(aboveShape, tallShape) ? ModdedWallShape.TALL : ModdedWallShape.LOW;
        }
        return ModdedWallShape.NONE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, NORTH_SHAPE_CUSTOM, EAST_SHAPE_CUSTOM, WEST_SHAPE_CUSTOM, SOUTH_SHAPE_CUSTOM, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(SOUTH_SHAPE_CUSTOM)))))).m_61124_(EAST_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(WEST_SHAPE_CUSTOM)))))).m_61124_(SOUTH_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(NORTH_SHAPE_CUSTOM)))))).m_61124_(WEST_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(EAST_SHAPE_CUSTOM)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(EAST_SHAPE_CUSTOM)))))).m_61124_(EAST_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(SOUTH_SHAPE_CUSTOM)))))).m_61124_(SOUTH_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(WEST_SHAPE_CUSTOM)))))).m_61124_(WEST_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(NORTH_SHAPE_CUSTOM)))));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(WEST_SHAPE_CUSTOM)))))).m_61124_(EAST_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(NORTH_SHAPE_CUSTOM)))))).m_61124_(SOUTH_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(EAST_SHAPE_CUSTOM)))))).m_61124_(WEST_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(SOUTH_SHAPE_CUSTOM)))));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_(NORTH_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(SOUTH_SHAPE_CUSTOM)))))).m_61124_(SOUTH_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(NORTH_SHAPE_CUSTOM)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_(EAST_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(WEST_SHAPE_CUSTOM)))))).m_61124_(WEST_SHAPE_CUSTOM, (Comparable)((Object)((ModdedWallShape)((Object)state.m_61143_(EAST_SHAPE_CUSTOM)))));
            }
        }
        return super.m_6943_(state, mirror);
    }
}

