/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block;

import com.conquestreforged.core.asset.annotation.Assets;
import com.conquestreforged.core.asset.annotation.Model;
import com.conquestreforged.core.asset.annotation.Render;
import com.conquestreforged.core.asset.annotation.State;
import com.conquestreforged.core.util.RenderLayer;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@Assets(state=@State(name="%s_platform", template="parent_platform_horizontal"), item=@Model(name="item/%s_platform", parent="block/%s_platform_horizontal_top", template="item/acacia_stairs"), render=@Render(value=RenderLayer.CUTOUT), block={@Model(name="block/%s_platform_horizontal_bottom", template="block/parent_platform_horizontal_bottom"), @Model(name="block/%s_platform_horizontal_bottom_outer", template="block/parent_platform_horizontal_bottom_outer"), @Model(name="block/%s_platform_horizontal_bottom_inner", template="block/parent_platform_horizontal_bottom_inner"), @Model(name="block/%s_platform_horizontal_top", template="block/parent_platform_horizontal_top"), @Model(name="block/%s_platform_horizontal_top_outer", template="block/parent_platform_horizontal_top_outer"), @Model(name="block/%s_platform_horizontal_top_inner", template="block/parent_platform_horizontal_top_inner")})
public class PlatformHorizontal
extends StairBlock {
    protected static final VoxelShape AABB_SLAB_TOP = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape NWD_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0);
    protected static final VoxelShape SWD_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0);
    protected static final VoxelShape SED_CORNER = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0);
    protected static final VoxelShape SWU_CORNER = Block.m_49796_((double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.m_49796_((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape SEU_CORNER = Block.m_49796_((double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_OPEN_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_QUARTER_SHAPE = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_QUARTER_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0);
    private static final VoxelShape EAST_QUARTER_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_QUARTER_SHAPE = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    private static final VoxelShape EAST_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    private static final VoxelShape QTR_EAST_CORNER = Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE_CORNER = Shapes.m_83110_((VoxelShape)EAST_CORNER, (VoxelShape)QTR_EAST_CORNER);
    private static final VoxelShape WEST_CORNER = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape QTR_WEST_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
    private static final VoxelShape WEST_SHAPE_CORNER = Shapes.m_83110_((VoxelShape)WEST_CORNER, (VoxelShape)QTR_WEST_CORNER);
    private static final VoxelShape NORTH_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape QTR_NORTH_CORNER = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape NORTH_SHAPE_CORNER = Shapes.m_83110_((VoxelShape)NORTH_CORNER, (VoxelShape)QTR_NORTH_CORNER);
    private static final VoxelShape SOUTH_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    private static final VoxelShape QTR_SOUTH_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE_CORNER = Shapes.m_83110_((VoxelShape)SOUTH_CORNER, (VoxelShape)QTR_SOUTH_CORNER);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = PlatformHorizontal.composeShapes(AABB_SLAB_TOP, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = PlatformHorizontal.composeShapes(AABB_SLAB_BOTTOM, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    public PlatformHorizontal(BlockState parent, BlockBehaviour.Properties properties) {
        super(parent, properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_61143_((Property)f_56842_) == Half.BOTTOM) {
            if (state.m_61143_((Property)f_56841_) == Direction.NORTH) {
                if (state.m_61143_((Property)f_56843_) == StairsShape.INNER_LEFT) {
                    return SOUTH_SHAPE_CORNER;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.INNER_RIGHT) {
                    return WEST_SHAPE_CORNER;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.OUTER_LEFT) {
                    return SOUTH_QUARTER_SHAPE;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.OUTER_RIGHT) {
                    return WEST_QUARTER_SHAPE;
                }
                return NORTH_OPEN_AABB;
            }
            if (state.m_61143_((Property)f_56841_) == Direction.EAST) {
                if (state.m_61143_((Property)f_56843_) == StairsShape.INNER_LEFT) {
                    return WEST_SHAPE_CORNER;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.INNER_RIGHT) {
                    return NORTH_SHAPE_CORNER;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.OUTER_LEFT) {
                    return WEST_QUARTER_SHAPE;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.OUTER_RIGHT) {
                    return NORTH_QUARTER_SHAPE;
                }
                return EAST_OPEN_AABB;
            }
            if (state.m_61143_((Property)f_56841_) == Direction.SOUTH) {
                if (state.m_61143_((Property)f_56843_) == StairsShape.INNER_LEFT) {
                    return NORTH_SHAPE_CORNER;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.INNER_RIGHT) {
                    return EAST_SHAPE_CORNER;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.OUTER_LEFT) {
                    return NORTH_QUARTER_SHAPE;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.OUTER_RIGHT) {
                    return EAST_QUARTER_SHAPE;
                }
                return SOUTH_OPEN_AABB;
            }
            if (state.m_61143_((Property)f_56841_) == Direction.WEST) {
                if (state.m_61143_((Property)f_56843_) == StairsShape.INNER_LEFT) {
                    return EAST_SHAPE_CORNER;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.INNER_RIGHT) {
                    return SOUTH_SHAPE_CORNER;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.OUTER_LEFT) {
                    return EAST_QUARTER_SHAPE;
                }
                if (state.m_61143_((Property)f_56843_) == StairsShape.OUTER_RIGHT) {
                    return SOUTH_QUARTER_SHAPE;
                }
                return WEST_OPEN_AABB;
            }
        }
        return (state.m_61143_((Property)f_56842_) == Half.TOP ? SLAB_TOP_SHAPES : SLAB_BOTTOM_SHAPES)[field_196522_K[this.getShapeIndexIndex(state)]];
    }

    private int getShapeIndexIndex(BlockState state) {
        return ((StairsShape)state.m_61143_((Property)f_56843_)).ordinal() * 4 + ((Direction)state.m_61143_((Property)f_56841_)).m_122416_();
    }

    private static VoxelShape[] composeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> PlatformHorizontal.combineShapes(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }
}

