/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.client.models;

import com.conquestreforged.content.blocks.block.VerticalSlab;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class XZBakedModel
extends ForwardingBakedModel {
    public XZBakedModel(BakedModel baseModel) {
        this.wrapped = baseModel;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(BlockAndTintGetter blockView, BlockState state, BlockPos pos, Supplier<RandomSource> randomSupplier, RenderContext context) {
        BlockState offsetBlock;
        float translationAmountXZ = 0.0f;
        boolean translatableXZ = false;
        Direction directionXZ = null;
        Direction direction = null;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61372_) && ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_().m_122479_()) {
            direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        }
        if (direction != null && (offsetBlock = blockView.m_8055_(pos.m_5484_(direction.m_122424_(), 1))).m_60734_() instanceof VerticalSlab) {
            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                if (direction == offsetBlock.m_61143_((Property)BlockStateProperties.f_61374_)) {
                    translationAmountXZ = this.getTranslationAmount(offsetBlock);
                    directionXZ = direction;
                    translatableXZ = true;
                }
            } else {
                if (direction == offsetBlock.m_61143_((Property)BlockStateProperties.f_61374_)) {
                    translationAmountXZ = this.getTranslationAmount(offsetBlock);
                }
                directionXZ = direction;
                translatableXZ = true;
            }
        }
        if (translatableXZ) {
            float finalTranslation = translationAmountXZ;
            Direction finalDirection = directionXZ;
            context.pushTransform(quad -> {
                this.translateXZ(quad, finalTranslation, finalDirection);
                return true;
            });
        } else {
            context.pushTransform(quad -> true);
        }
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private float getTranslationAmount(BlockState offsetBlock) {
        int layers = (Integer)offsetBlock.m_61143_((Property)VerticalSlab.LAYERS);
        return switch (layers) {
            case 1 -> -0.875f;
            case 2 -> -0.75f;
            case 3 -> -0.5f;
            case 4 -> -0.25f;
            default -> 0.0f;
        };
    }

    public void translateXZ(MutableQuadView quad, float translationAmount, Direction direction) {
        float dx = 0.0f;
        float dz = 0.0f;
        switch (direction) {
            case NORTH: {
                dz = -translationAmount;
                break;
            }
            case EAST: {
                dx = translationAmount;
                break;
            }
            case SOUTH: {
                dz = translationAmount;
                break;
            }
            case WEST: {
                dx = -translationAmount;
                break;
            }
        }
        for (int i = 0; i < 4; ++i) {
            quad.pos(i, quad.x(i) + dx, quad.y(i), quad.z(i) + dz);
        }
    }
}

